/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.block;

import info.jbcs.minecraft.vending.Utils;
import info.jbcs.minecraft.vending.Vending;
import info.jbcs.minecraft.vending.block.EnumSupports;
import info.jbcs.minecraft.vending.init.VendingItems;
import info.jbcs.minecraft.vending.init.VendingSoundEvents;
import info.jbcs.minecraft.vending.stats.ModStats;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingMachine;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockVendingMachine
extends BlockContainer {
    private static final PropertyEnum<EnumSupports> SUPPORT = PropertyEnum.func_177709_a((String)"support", EnumSupports.class);
    private boolean isAdvanced;
    private boolean isMultiple;
    private boolean isOpen;
    private String name;

    public BlockVendingMachine(boolean advanced, boolean multiple, String name) {
        super(Material.field_151592_s);
        this.setProperties();
        this.isAdvanced = advanced;
        this.isMultiple = multiple;
        this.isOpen = true;
        this.name = name;
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SUPPORT, (Comparable)((Object)EnumSupports.STONE)));
    }

    private void setProperties() {
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(0.3f);
        this.func_149752_b(6000000.0f);
        this.func_149722_s();
        this.func_149647_a(Vending.tabVending);
    }

    public void func_180649_a(World world, BlockPos blockPos, EntityPlayer entityplayer) {
        TileEntityVendingMachine tileEntity = (TileEntityVendingMachine)world.func_175625_s(blockPos);
        if (tileEntity == null) {
            return;
        }
        if (!entityplayer.getDisplayNameString().equals(tileEntity.getOwnerName()) || !tileEntity.func_191420_l()) {
            tileEntity.vend(entityplayer, false);
            return;
        }
        if (tileEntity.isAdvanced()) {
            tileEntity.getInventoryWrapper().setBoughtItem(ItemStack.field_190927_a);
        }
        this.func_176226_b(world, blockPos, world.func_180495_p(blockPos), 0);
        world.func_175698_g(blockPos);
        world.func_184133_a(entityplayer, blockPos, VendingSoundEvents.PROCESSED, SoundCategory.MASTER, 0.3f, 0.6f);
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityVendingMachine tileEntity = (TileEntityVendingMachine)world.func_175625_s(blockPos);
        if (tileEntity == null) {
            return false;
        }
        if (!entityPlayer.field_71071_by.func_70448_g().func_190926_b() && entityPlayer.field_71071_by.func_70448_g().func_77973_b() == VendingItems.ITEM_WRENCH) {
            Vending.guiWrench.open(entityPlayer, world, blockPos);
            return true;
        }
        if (entityPlayer.getDisplayNameString().equals(tileEntity.getOwnerName()) && !entityPlayer.func_70093_af() || entityPlayer.field_71075_bZ.field_75098_d && !entityPlayer.func_70093_af()) {
            entityPlayer.func_71029_a(ModStats.VENDING_MACHINES_OPENED);
            Vending.guiVending.open(entityPlayer, world, blockPos);
            return true;
        }
        tileEntity.vend(entityPlayer, false);
        tileEntity.func_70296_d();
        Utils.markBlockForUpdate(world, blockPos);
        return true;
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        if (!worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
            return false;
        }
        if (!Vending.settings.isPlacingNextToDoorsBlocked()) {
            return true;
        }
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (!(worldIn.func_180495_p(pos.func_177982_a(x, 0, z)).func_177230_c() instanceof BlockDoor)) continue;
                return false;
            }
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos blockPos, IBlockState state, EntityLivingBase entityLiving, @Nonnull ItemStack stack) {
        world.func_175656_a(blockPos, this.func_176203_a(stack.func_77960_j()));
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("preConfigured") && tagCompound.func_74767_n("preConfigured")) {
            TileEntityVendingMachine e = new TileEntityVendingMachine(this.isAdvanced, tagCompound.func_74767_n("infinite"), this.isMultiple);
            e.setOpen(true);
            e.setOwnerName(tagCompound.func_74779_i("ownerName"));
            world.func_175690_a(blockPos, (TileEntity)e);
            return;
        }
        TileEntityVendingMachine e = new TileEntityVendingMachine(this.isAdvanced, false, this.isMultiple);
        e.setOpen(this.isOpen);
        if (entityLiving != null) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            e.setOwnerName(player.func_70005_c_());
            world.func_175690_a(blockPos, (TileEntity)e);
        }
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World var1, int metadata) {
        TileEntityVendingMachine e = new TileEntityVendingMachine(this.isAdvanced, false, this.isMultiple);
        e.setOpen(this.isOpen);
        return e;
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < EnumSupports.length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SUPPORT, (Comparable)((Object)EnumSupports.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumSupports)((Object)state.func_177229_b(SUPPORT))).getMetadata();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SUPPORT});
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0625, 0.125, 0.0625, 0.9375, 0.9375, 0.9375);
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public String getName() {
        return this.name;
    }
}

