/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending;

import info.jbcs.minecraft.vending.General;
import info.jbcs.minecraft.vending.items.wrapper.AdvancedItemHandlerHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Utils {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();
    private static HashMap<String, ResourceLocation> resources = new HashMap();

    public static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return Utils.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + Utils.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static void bind(String textureName) {
        ResourceLocation res = resources.get(textureName);
        if (res == null) {
            res = new ResourceLocation(textureName);
            resources.put(textureName, res);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
    }

    public static void throwItemAtPlayer(EntityPlayer entityPlayer, World world, BlockPos blockPos, ItemStack vended) {
        EntityItem entityitem = new EntityItem(world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 1.2, (double)blockPos.func_177952_p() + 0.5, vended);
        General.propelTowards((Entity)entityitem, (Entity)entityPlayer, 0.2);
        entityitem.field_70181_x = 0.2;
        entityitem.func_174867_a(10);
        world.func_72838_d((Entity)entityitem);
    }

    public static void markBlockForUpdate(World world, BlockPos pos) {
        if (world == null) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        world.func_184138_a(pos, blockState, blockState, 3);
    }

    public static NonNullList<ItemStack> splitItemsStack(ItemStack stack) {
        NonNullList itemStacks = NonNullList.func_191196_a();
        for (int i = stack.func_190916_E(); i > 0; ++i) {
            if (stack.func_190916_E() <= 0) {
                return itemStacks;
            }
            itemStacks.add((Object)stack.func_77979_a(stack.func_77976_d()));
        }
        return itemStacks;
    }

    public static NonNullList<ItemStack> joinItems(NonNullList<ItemStack> items) {
        NonNullList joinedItems = NonNullList.func_191196_a();
        for (ItemStack itemStack : items) {
            boolean added = false;
            for (ItemStack itemStack2 : joinedItems) {
                if (!AdvancedItemHandlerHelper.areStacksEqualIgnoreCount(itemStack, itemStack2)) continue;
                itemStack2.func_190920_e(itemStack2.func_190916_E() + itemStack.func_190916_E());
                added = true;
            }
            if (added) continue;
            joinedItems.add((Object)itemStack.func_77946_l());
        }
        return joinedItems;
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }
}

