/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tile;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.BlockTelepadFake;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.ShortRangeTelepadHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.network.PacketSimpleAsteroids;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityShortRangeTelepad
extends TileBaseElectricBlock
implements IMultiBlock,
IInventoryDefaults,
ISidedInventory {
    public static final int MAX_TELEPORT_TIME = 150;
    public static final int TELEPORTER_RANGE = 256;
    public static final int ENERGY_USE_ON_TELEPORT = 2500;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int address = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean addressValid = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int targetAddress = -1;
    public EnumTelepadSearchResult targetAddressResult = EnumTelepadSearchResult.NOT_FOUND;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int teleportTime = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String owner = "";
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean teleporting;
    private AxisAlignedBB renderAABB;

    public TileEntityShortRangeTelepad() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 115.0f : 50.0f);
    }

    public int canTeleportHere() {
        if (this.field_145850_b.field_72995_K) {
            return -1;
        }
        this.setAddress(this.address);
        this.setTargetAddress(this.targetAddress);
        if (!this.addressValid) {
            return 1;
        }
        if (this.getEnergyStoredGC() < 2500.0f) {
            return 2;
        }
        return 0;
    }

    public void func_73660_a() {
        if (this.ticks % 40 == 0 && !this.field_145850_b.field_72995_K) {
            this.setAddress(this.address);
            this.setTargetAddress(this.targetAddress);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.getDisabled(0) && this.targetAddressResult == EnumTelepadSearchResult.VALID && (this.ticks % 5 == 0 || this.teleporting)) {
                List containedEntities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 1)));
                if (containedEntities.size() > 0 && this.getEnergyStoredGC() >= 2500.0f) {
                    ShortRangeTelepadHandler.TelepadEntry entry = ShortRangeTelepadHandler.getLocationFromAddress(this.targetAddress);
                    if (entry != null) {
                        this.teleporting = true;
                    }
                } else {
                    this.teleporting = false;
                }
            }
            if (this.teleporting) {
                ++this.teleportTime;
                if (this.teleportTime >= 150) {
                    BlockVec3 finalPos;
                    ShortRangeTelepadHandler.TelepadEntry entry = ShortRangeTelepadHandler.getLocationFromAddress(this.targetAddress);
                    BlockVec3 blockVec3 = finalPos = entry == null ? null : entry.position;
                    if (finalPos != null) {
                        TileEntity tileAt = finalPos.getTileEntity((IBlockAccess)this.field_145850_b);
                        List containedEntities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 1)));
                        if (tileAt instanceof TileEntityShortRangeTelepad) {
                            TileEntityShortRangeTelepad destTelepad = (TileEntityShortRangeTelepad)tileAt;
                            int teleportResult = destTelepad.canTeleportHere();
                            if (teleportResult == 0) {
                                for (EntityLivingBase e : containedEntities) {
                                    e.func_70107_b((double)((float)finalPos.x + 0.5f), (double)((float)finalPos.y + 1.0f), (double)((float)finalPos.z + 0.5f));
                                    this.field_145850_b.func_72866_a((Entity)e, true);
                                    if (e instanceof EntityPlayerMP) {
                                        ((EntityPlayerMP)e).field_71135_a.func_147364_a((double)finalPos.x, (double)finalPos.y, (double)finalPos.z, e.field_70177_z, e.field_70125_A);
                                    }
                                    GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketSimpleAsteroids(PacketSimpleAsteroids.EnumSimplePacketAsteroids.C_TELEPAD_SEND, GCCoreUtil.getDimensionID((World)this.field_145850_b), new Object[]{finalPos, e.func_145782_y()}), GCCoreUtil.getDimensionID((World)this.field_145850_b));
                                }
                                if (containedEntities.size() > 0) {
                                    this.storage.setEnergyStored(this.storage.getEnergyStoredGC() - 2500.0f);
                                    destTelepad.storage.setEnergyStored(this.storage.getEnergyStoredGC() - 2500.0f);
                                }
                            } else {
                                switch (teleportResult) {
                                    case -1: {
                                        for (EntityLivingBase e : containedEntities) {
                                            if (!(e instanceof EntityPlayer)) continue;
                                            e.func_145747_a((ITextComponent)new TextComponentString("Cannot Send client-side"));
                                        }
                                        break;
                                    }
                                    case 1: {
                                        for (EntityLivingBase e : containedEntities) {
                                            if (!(e instanceof EntityPlayer)) continue;
                                            e.func_145747_a((ITextComponent)new TextComponentString("Target address invalid"));
                                        }
                                        break;
                                    }
                                    case 2: {
                                        for (EntityLivingBase e : containedEntities) {
                                            if (!(e instanceof EntityPlayer)) continue;
                                            e.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.message.target_no_energy.name")));
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    this.teleportTime = 0;
                    this.teleporting = false;
                }
            } else {
                this.teleportTime = Math.max(--this.teleportTime, 0);
            }
        }
        super.func_73660_a();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks);
        if (GCCoreUtil.getEffectiveSide() == Side.SERVER) {
            this.setAddress(nbt.func_74762_e("Address"));
        }
        this.targetAddress = nbt.func_74762_e("TargetAddress");
        this.owner = nbt.func_74779_i("Owner");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks);
        nbt.func_74768_a("TargetAddress", this.targetAddress);
        nbt.func_74768_a("Address", this.address);
        nbt.func_74778_a("Owner", this.owner);
        return nbt;
    }

    public void addExtraNetworkedData(List<Object> networkedList) {
        super.addExtraNetworkedData(networkedList);
        networkedList.add(this.targetAddressResult.ordinal());
    }

    public void readExtraNetworkedData(ByteBuf dataStream) {
        super.readExtraNetworkedData(dataStream);
        this.targetAddressResult = EnumTelepadSearchResult.values()[dataStream.readInt()];
    }

    public double getPacketRange() {
        return 24.0;
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        entityPlayer.openGui((Object)GalacticraftPlanets.instance, 3, this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        return true;
    }

    public void onCreate(World world, BlockPos placedPosition) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(placedPosition, positions);
        for (BlockPos vecToAdd : positions) {
            ((BlockTelepadFake)AsteroidBlocks.fakeTelepad).makeFakeBlock(world, vecToAdd, placedPosition, AsteroidBlocks.fakeTelepad.func_176223_P().func_177226_a((IProperty)BlockTelepadFake.TOP, (Comparable)Boolean.valueOf(vecToAdd.func_177956_o() == placedPosition.func_177956_o() + 2)));
        }
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return BlockMulti.EnumBlockMultiType.MINER_BASE;
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        int buildHeight = this.field_145850_b.func_72800_K() - 1;
        for (int y = 0; y < 3; y += 2) {
            if (placedPosition.func_177956_o() + y > buildHeight) {
                return;
            }
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    positions.add(placedPosition.func_177982_a(x, y, z));
                }
            }
        }
    }

    public void onDestroy(TileEntity callingBlock) {
        BlockPos thisBlock = this.func_174877_v();
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            IBlockState stateAt = this.field_145850_b.func_180495_p(pos);
            if (stateAt.func_177230_c() != AsteroidBlocks.fakeTelepad) continue;
            this.field_145850_b.func_175655_b(pos, false);
        }
        this.field_145850_b.func_175655_b(thisBlock, true);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 4), (double)(this.func_174877_v().func_177952_p() + 2));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"container.short_range_telepad.name");
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.func_82600_a((int)((this.func_145832_p() & 3) + 2));
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            switch (index) {
                case 0: {
                    this.disabled = disabled;
                    this.disableCooldown = 10;
                    if (this.field_145850_b == null || this.field_145850_b.field_72995_K) break;
                    ShortRangeTelepadHandler.addShortRangeTelepad(this);
                    break;
                }
            }
        }
    }

    public boolean getDisabled(int index) {
        switch (index) {
            case 0: {
                return this.disabled;
            }
        }
        return true;
    }

    public void setAddress(int address) {
        ShortRangeTelepadHandler.TelepadEntry entry;
        if (this.field_145850_b != null && address != this.address) {
            ShortRangeTelepadHandler.removeShortRangeTeleporter(this);
        }
        this.address = address;
        this.addressValid = this.address >= 0 ? (entry = ShortRangeTelepadHandler.getLocationFromAddress(this.address)) == null || this.field_145850_b != null && entry.dimensionID == GCCoreUtil.getDimensionID((World)this.field_145850_b) && entry.position.x == this.func_174877_v().func_177958_n() && entry.position.y == this.func_174877_v().func_177956_o() && entry.position.z == this.func_174877_v().func_177952_p() : false;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ShortRangeTelepadHandler.addShortRangeTelepad(this);
        }
    }

    public boolean updateTarget() {
        if (this.targetAddress >= 0 && !this.field_145850_b.field_72995_K) {
            this.targetAddressResult = EnumTelepadSearchResult.NOT_FOUND;
            ShortRangeTelepadHandler.TelepadEntry addressResult = ShortRangeTelepadHandler.getLocationFromAddress(this.targetAddress);
            if (addressResult != null) {
                if (GCCoreUtil.getDimensionID((World)this.field_145850_b) == addressResult.dimensionID) {
                    double distance = this.func_145835_a((float)addressResult.position.x + 0.5f, (float)addressResult.position.y + 0.5f, (float)addressResult.position.z + 0.5f);
                    if (distance < Math.pow(65536.0, 2.0)) {
                        if (!addressResult.enabled) {
                            this.targetAddressResult = EnumTelepadSearchResult.TARGET_DISABLED;
                            return false;
                        }
                        this.targetAddressResult = EnumTelepadSearchResult.VALID;
                        return true;
                    }
                    this.targetAddressResult = EnumTelepadSearchResult.TOO_FAR;
                    return false;
                }
                this.targetAddressResult = EnumTelepadSearchResult.WRONG_DIM;
                return false;
            }
            this.targetAddressResult = EnumTelepadSearchResult.NOT_FOUND;
            return false;
        }
        this.targetAddressResult = EnumTelepadSearchResult.NOT_FOUND;
        return false;
    }

    public void setTargetAddress(int address) {
        this.targetAddress = address;
        this.updateTarget();
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.stacks.get(var1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack oldstack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
        if (!oldstack.func_190926_b()) {
            this.func_70296_d();
        }
        return oldstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    @SideOnly(value=Side.CLIENT)
    public String getReceivingStatus() {
        if (!this.addressValid) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.message.invalid_address.name");
        }
        if (this.getEnergyStoredGC() <= 0.0f) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.message.no_energy.name");
        }
        if (this.getEnergyStoredGC() <= 2500.0f) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.message.not_enough_energy.name");
        }
        if (this.getDisabled(0)) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        return EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.message.receiving_active.name");
    }

    @SideOnly(value=Side.CLIENT)
    public String getSendingStatus() {
        if (!this.addressValid) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.message.invalid_target_address.name");
        }
        if (this.targetAddressResult == EnumTelepadSearchResult.TOO_FAR) {
            return EnumColor.RED + GCCoreUtil.translateWithFormat((String)"gui.message.telepad_too_far.name", (Object[])new Object[]{256});
        }
        if (this.targetAddressResult == EnumTelepadSearchResult.WRONG_DIM) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.message.telepad_wrong_dim.name");
        }
        if (this.targetAddressResult == EnumTelepadSearchResult.NOT_FOUND) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.message.telepad_not_found.name");
        }
        if (this.targetAddressResult == EnumTelepadSearchResult.TARGET_DISABLED) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.message.telepad_target_disabled.name");
        }
        if (this.getEnergyStoredGC() <= 0.0f) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.message.no_energy.name");
        }
        if (this.getEnergyStoredGC() <= 2500.0f) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.message.not_enough_energy.name");
        }
        if (this.getDisabled(0)) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        return EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.message.sending_active.name");
    }

    @SideOnly(value=Side.CLIENT)
    public Vector3 getParticleColor(Random rand, boolean sending) {
        float teleportTimeScaled = Math.min(1.0f, (float)this.teleportTime / 150.0f);
        float f = rand.nextFloat() * 0.6f + 0.4f;
        if (sending && this.targetAddressResult != EnumTelepadSearchResult.VALID) {
            return new Vector3((double)f, (double)(f * 0.3f), (double)(f * 0.3f));
        }
        if (!sending && !this.addressValid) {
            return new Vector3((double)f, (double)(f * 0.3f), (double)(f * 0.3f));
        }
        if (this.getEnergyStoredGC() < 2500.0f) {
            return new Vector3((double)f, (double)(f * 0.6f), (double)(f * 0.3f));
        }
        float r = f * 0.3f;
        float g = f * (0.3f + teleportTimeScaled * 0.7f);
        float b = f * (1.0f - teleportTimeScaled * 0.7f);
        return new Vector3((double)r, (double)g, (double)b);
    }

    public EnumFacing getFront() {
        return EnumFacing.NORTH;
    }

    public static enum EnumTelepadSearchResult {
        VALID,
        NOT_FOUND,
        TOO_FAR,
        WRONG_DIM,
        TARGET_DISABLED;

    }
}

