/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.permissions;

import brad16840.common.Logger;
import brad16840.common.MessageChannel;
import brad16840.common.permissions.ItemPermission;
import brad16840.common.permissions.PermissionGroup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;

public class PermissionData
extends WorldSavedData {
    private static final String identifier = "BCMod-Permissions";
    public HashMap<String, NBTTagCompound> permissions = new HashMap();
    public HashMap<String, NBTTagCompound> items = new HashMap();
    public static HashMap<String, PermissionGroup> groups = new HashMap();
    public static PermissionData permissionDataClient;
    public static PermissionData permissionDataServer;

    public static void loadData() {
        try {
            Exception exception;
            boolean loaded;
            block12: {
                NBTTagCompound nbttagcompound;
                FileInputStream fileinputstream;
                File dataFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "data");
                if (!dataFolder.exists()) {
                    dataFolder.mkdir();
                }
                permissionDataServer = new PermissionData(identifier);
                loaded = false;
                exception = null;
                File file1 = new File(dataFolder, "BCMod-Permissions.dat");
                try {
                    if (file1.exists()) {
                        fileinputstream = new FileInputStream(file1);
                        nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                        fileinputstream.close();
                        permissionDataServer.func_76184_a(nbttagcompound.func_74775_l("data"));
                        loaded = true;
                    }
                }
                catch (Exception ex) {
                    loaded = false;
                    exception = ex;
                }
                if (!loaded) {
                    file1 = new File(dataFolder, "BCMod-Permissions.dat_old");
                    try {
                        if (file1.exists()) {
                            fileinputstream = new FileInputStream(file1);
                            nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                            fileinputstream.close();
                            permissionDataServer.func_76184_a(nbttagcompound.func_74775_l("data"));
                            if (exception != null) {
                                exception.printStackTrace();
                                Logger.logger.error("Couldn't load BCMod-Permissions.dat but managed to load BCMod-Permissions.dat_old", (Throwable)exception);
                            }
                            loaded = true;
                        }
                    }
                    catch (Exception ex) {
                        loaded = false;
                        if (exception != null) break block12;
                        exception = ex;
                    }
                }
            }
            if (!loaded && exception != null) {
                throw exception;
            }
        }
        catch (Exception exception1) {
            exception1.printStackTrace();
            Logger.logger.error("Couldn't load BCMod-Permissions.dat", (Throwable)exception1);
        }
    }

    public static void saveData() {
        try {
            File dataFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "data");
            if (!dataFolder.exists()) {
                dataFolder.mkdir();
            }
            File file1 = new File(dataFolder, "BCMod-Permissions.dat_new");
            File file2 = new File(dataFolder, "BCMod-Permissions.dat_old");
            File file3 = new File(dataFolder, "BCMod-Permissions.dat");
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            permissionDataServer.func_189551_b(nbttagcompound);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74782_a("data", (NBTBase)nbttagcompound);
            FileOutputStream fileoutputstream = new FileOutputStream(file1);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound1, (OutputStream)fileoutputstream);
            fileoutputstream.close();
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file1.renameTo(file3);
            if (file1.exists()) {
                file1.delete();
            }
        }
        catch (Exception exception1) {
            exception1.printStackTrace();
            Logger.logger.error("Couldn't save BCMod-Permissions.dat", (Throwable)exception1);
        }
    }

    public PermissionData(String par1Str) {
        super(par1Str);
    }

    public void func_76184_a(NBTTagCompound tag) {
        NBTTagCompound element;
        Object[] keys;
        this.permissions.clear();
        this.items.clear();
        NBTTagCompound elements = tag.func_74775_l("permissions");
        for (Object key : keys = elements.func_150296_c().toArray()) {
            element = elements.func_74775_l((String)key);
            if (!element.func_74764_b("id")) continue;
            this.permissions.put(element.func_74779_i("id"), element);
        }
        elements = tag.func_74775_l("items");
        for (Object key : keys = elements.func_150296_c().toArray()) {
            element = elements.func_74775_l((String)key);
            if (!element.func_74764_b("id")) continue;
            this.items.put(element.func_74779_i("id"), element);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        if (!tag.func_74764_b("permissions")) {
            tag.func_74782_a("permissions", (NBTBase)new NBTTagCompound());
        }
        if (!tag.func_74764_b("items")) {
            tag.func_74782_a("items", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound pTag = tag.func_74775_l("permissions");
        for (Map.Entry<String, NBTTagCompound> entry : this.permissions.entrySet()) {
            pTag.func_74782_a(entry.getKey(), (NBTBase)entry.getValue());
        }
        NBTTagCompound iTag = tag.func_74775_l("items");
        for (Map.Entry<String, NBTTagCompound> entry : this.items.entrySet()) {
            iTag.func_74782_a(entry.getKey(), (NBTBase)entry.getValue());
        }
        return tag;
    }

    public void setPermission(PermissionGroup group) {
        (group instanceof ItemPermission ? this.items : this.permissions).put(group.getId(), group.getTagCompound());
        this.func_76185_a();
    }

    public void deletePermission(PermissionGroup group) {
        String id = group.getId();
        if (id.startsWith("G_")) {
            groups.remove(id);
            this.permissions.remove(id);
            this.func_76185_a();
        } else if (id.startsWith("I_")) {
            groups.remove(id);
            this.items.remove(id);
            this.func_76185_a();
        }
    }

    public boolean hasPermission(PermissionGroup group) {
        return (group instanceof ItemPermission ? this.items : this.permissions).containsKey(group.getId());
    }

    public NBTTagCompound getPermission(PermissionGroup group) {
        String id;
        if (!(group instanceof ItemPermission ? this.items : this.permissions).containsKey(id = group.getId())) {
            this.setPermission(group);
        }
        return (group instanceof ItemPermission ? this.items : this.permissions).get(id);
    }

    public static PermissionData get(World world) {
        PermissionData data;
        boolean clientside = MessageChannel.getEffectiveSide() == Side.CLIENT;
        PermissionData permissionData = data = clientside ? permissionDataClient : permissionDataServer;
        if (data == null) {
            data = new PermissionData(identifier);
            if (clientside) {
                permissionDataClient = data;
            } else {
                permissionDataServer = data;
            }
        }
        return data;
    }

    public void loadAllPermissions(World world) {
        PermissionGroup.getGroup(world, PermissionGroup.SpecialPermissionGroup.allowId);
        PermissionGroup.getGroup(world, PermissionGroup.SpecialPermissionGroup.denyId);
        for (String id : this.permissions.keySet()) {
            PermissionGroup.getGroup(world, id);
        }
        for (String id : this.items.keySet()) {
            PermissionGroup.getGroup(world, id);
        }
    }
}

