/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class NumberContainer
extends StackableContainer.SimpleContainer {
    private String translatable;
    private String oldNumber;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerTextField textField;
    private ResultCallback callback;
    private static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/rename.png");

    public NumberContainer(String oldNumber, String translatable, ResultCallback callback) {
        super(176, 68);
        this.oldNumber = oldNumber;
        this.callback = callback;
        this.translatable = translatable;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void saveAndClose() {
        String newNumber = this.textField.getText();
        this.callback.call(newNumber);
        this.gui.closeContainer(this.stackId);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.textField = this.gui.addTextField(10, this, 11, 24, 150, 9);
        this.textField.setMaxStringLength(30);
        this.textField.setCanLoseFocus(false);
        this.textField.setFocused(true);
        this.textField.setText(this.oldNumber);
        this.gui.addButton(new StackableContainer.ContainerButton(this, 0, 7, 41, 80, 20, new Translatable("button.save", new Object[0]).translate(), new ContainerStack.Callback(){

            @Override
            public void call() {
                NumberContainer.this.saveAndClose();
            }
        }));
        this.gui.addButton(new StackableContainer.ContainerButton(this, 1, 90, 41, 80, 20, new Translatable("button.cancel", new Object[0]).translate(), new ContainerStack.Callback(){

            @Override
            public void call() {
                NumberContainer.this.gui.closeContainer(NumberContainer.this.stackId);
            }
        }));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (this.textField.keyPressed(key, keyCode)) {
            return true;
        }
        if (keyCode == 28) {
            this.saveAndClose();
            return true;
        }
        return false;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        if (this.isClient()) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
        this.gui.text(this, new Translatable(this.translatable, new Object[0]).translate()).truncateString(160).drawCenteredString(88, 9, -12566464);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
        GL11.glDisable((int)2896);
        this.textField.drawBackground();
    }

    public static interface ResultCallback {
        public void call(String var1);
    }
}

