/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.gui.CraftingContainer;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ArmorContainer
extends CraftingContainer {
    private InventoryPlayer inventory;
    protected static final ResourceLocation inventoryTexture = new ResourceLocation("textures/gui/container/inventory.png");
    protected static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/armor.png");

    public ArmorContainer(InventoryPlayer inventory) {
        super(inventory.field_70458_d, 176, 100);
        this.inventory = inventory;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        int y;
        if (this.craftMatrix == null) {
            this.craftMatrix = new CraftingContainer.CraftingContainerInventory(this, this.container, 2, 2);
        }
        this.craftingSlot = new CraftingContainer.CraftingContainerSlot(this, player, this.craftMatrix, (IInventory)this.craftResult, 0, 144, 46 + this.getOffset());
        this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_OUT, this.craftingSlot);
        for (y = 0; y < 2; ++y) {
            for (int x = 0; x < 2; ++x) {
                this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_IN, new StackableContainer.ContainerSlot(this, player, (IInventory)this.craftMatrix, x + y * 2, 88 + x * 18, this.getOffset() + 36 + y * 18));
            }
        }
        for (y = 0; y < 4; ++y) {
            this.addSlotToContainer(ContainerStack.ContainerSection.ARMOR, new ArmorContainerSlot(player, (IInventory)this.inventory, this.inventory.func_70302_i_() - 1 - y, 8, 18 + y * 18 + this.getOffset(), y));
        }
        this.callbackContainer.func_75130_a((IInventory)this.craftMatrix);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
    }

    @Override
    public void onUnload(EntityPlayer player) {
        if (!this.world.field_72995_K && this.craftMatrix != null) {
            for (int i = 0; i < 4; ++i) {
                ItemStack itemstack = this.craftMatrix.func_70304_b(i);
                if (itemstack.func_190926_b()) continue;
                player.func_71019_a(itemstack, false);
            }
            this.craftResult.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, Slot slot, StackableContainer.ContainerSlotInterface containerSlot) {
        ItemStack itemstack = ItemStack.field_190927_a;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d((ItemStack)itemstack);
            if (entityequipmentslot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR && !this.container.func_75139_a(8 - entityequipmentslot.func_188454_b()).func_75216_d()) {
                int j = 8 - entityequipmentslot.func_188454_b();
                if (!this.container.mergeItemStack(this, itemstack1, j, j + 1, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
        this.gui.text(this, this.inventory.field_70458_d.getDisplayNameString()).truncateString(this.guiWidth - 16).drawString(8, 6 + this.getOffset(), -12566464);
        this.gui.text(this, I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0])).drawString(86, 26 + this.getOffset(), 0x404040);
        this.displayDebuffEffects();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, this.getOffset(), this.guiWidth, this.guiHeight - 3, 0, 0);
        ArmorContainer.drawPlayerOnGui(this.inventory.field_70458_d, this.gui.getOffsetX(this) + 51, this.gui.getOffsetY(this) + 85, 30, 51 - x, 35 - y);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawPlayerOnGui(EntityPlayer player, int par1, int par2, int par3, float par4, float par5) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)par1, (float)par2, (float)50.0f);
        GlStateManager.func_179152_a((float)(-par3), (float)par3, (float)par3);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = player.field_70761_aq;
        float f3 = player.field_70177_z;
        float f4 = player.field_70125_A;
        float f5 = player.field_70758_at;
        float f6 = player.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(par5 / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        player.field_70761_aq = (float)Math.atan(par4 / 40.0f) * 20.0f;
        player.field_70177_z = (float)Math.atan(par4 / 40.0f) * 40.0f;
        player.field_70125_A = -((float)Math.atan(par5 / 40.0f)) * 20.0f;
        player.field_70759_as = player.field_70177_z;
        player.field_70758_at = player.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)player, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        player.field_70761_aq = f2;
        player.field_70177_z = f3;
        player.field_70125_A = f4;
        player.field_70758_at = f5;
        player.field_70759_as = f6;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    @SideOnly(value=Side.CLIENT)
    private void displayDebuffEffects() {
        int i = -124;
        int j = 3;
        int itexture = i + this.container.getOffsetX(this) - (this.gui.getScrollX() + this.gui.getOffsetX(this));
        int jtexture = j + this.container.getOffsetY(this) - (this.gui.getScrollY() + this.gui.getOffsetY(this));
        Collection collection = this.inventory.field_70458_d.func_70651_bq();
        if (!collection.isEmpty()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            int k = 33;
            if (collection.size() > 5) {
                k = 132 / (collection.size() - 1);
            }
            for (PotionEffect potioneffect : Ordering.natural().sortedCopy((Iterable)collection)) {
                Potion potion = potioneffect.func_188419_a();
                if (!potion.shouldRender(potioneffect)) continue;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.gui.bindTexture(inventoryTexture);
                this.gui.drawTexture(this, itexture, jtexture, 140, 32, 0, 166);
                if (potion.func_76400_d()) {
                    int l = potion.func_76392_e();
                    this.gui.drawTexture(this, itexture + 6, jtexture + 7, 18, 18, l % 8 * 18, 198 + l / 8 * 18);
                }
                potion.renderInventoryEffect(itexture, jtexture, potioneffect, Minecraft.func_71410_x());
                if (!potion.shouldRenderInvText(potioneffect)) {
                    j += k;
                    jtexture += k;
                    continue;
                }
                String s = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
                if (potioneffect.func_76458_c() == 1) {
                    s = s + " " + I18n.func_135052_a((String)"enchantment.level.2", (Object[])new Object[0]);
                } else if (potioneffect.func_76458_c() == 2) {
                    s = s + " " + I18n.func_135052_a((String)"enchantment.level.3", (Object[])new Object[0]);
                } else if (potioneffect.func_76458_c() == 3) {
                    s = s + " " + I18n.func_135052_a((String)"enchantment.level.4", (Object[])new Object[0]);
                }
                this.gui.text(this, s).setShadow(true).drawString(i + 10 + 18, j + 6, 0xFFFFFF);
                this.gui.text(this, Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f)).setShadow(true).drawString(i + 10 + 18, j + 6 + 10, 0x7F7F7F);
                j += k;
                jtexture += k;
            }
        }
    }

    @Override
    public String getId() {
        return "none";
    }

    @Override
    public int getOffset() {
        if (this.container.layout.isTop(this.stackId)) {
            return 3;
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        return false;
    }

    @Override
    public int getSlotCount() {
        return 9;
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @Override
    public int getRowSize() {
        return 2;
    }

    public class ArmorContainerSlot
    extends StackableContainer.ContainerSlot {
        public final EntityEquipmentSlot armorType;

        public ArmorContainerSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4, int armorType) {
            super(ArmorContainer.this, player, inventory, par2, par3, par4);
            this.armorType = armorType == 0 ? EntityEquipmentSlot.HEAD : (armorType == 1 ? EntityEquipmentSlot.CHEST : (armorType == 2 ? EntityEquipmentSlot.LEGS : EntityEquipmentSlot.FEET));
        }

        public int func_75219_a() {
            return 1;
        }

        @Override
        public boolean func_75214_a(ItemStack stack) {
            if (!super.func_75214_a(stack)) {
                return false;
            }
            return stack.func_77973_b().isValidArmor(stack, this.armorType, (Entity)((ArmorContainer)ArmorContainer.this).inventory.field_70458_d);
        }

        @Override
        public boolean func_82869_a(EntityPlayer playerIn) {
            ItemStack itemstack = this.func_75211_c();
            return !itemstack.func_190926_b() && !playerIn.func_184812_l_() && EnchantmentHelper.func_190938_b((ItemStack)itemstack) ? false : super.func_82869_a(playerIn);
        }
    }
}

