/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks;

import brad16840.backpacks.items.Backpack;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.b3d.B3DLoader;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class BackpackModel
implements IBakedModel {
    protected int color = 3;
    protected static ArrayList<TextureAtlasSprite> backpackSprites = new ArrayList();
    protected static FaceBakery faceBakery = new FaceBakery();
    protected boolean isItem;
    protected boolean isGui;
    protected static IModel model;
    public static ItemTransformVec3f MovedUp;

    public BackpackModel() {
        int i;
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        for (i = 0; i < 16; ++i) {
            backpackSprites.add(map.func_110572_b("backpacks16840:items/backpack." + Backpack.colors[i]));
        }
        for (i = 0; i < 16; ++i) {
            backpackSprites.add(map.func_110572_b("backpacks16840:items/backpack." + Backpack.colors[i] + ".open"));
        }
        try {
            model = B3DLoader.INSTANCE.loadModel(new ResourceLocation("backpacks16840", "items/backpack3.b3d"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BackpackModel(int color) {
        this.color = color;
        this.isItem = true;
        this.isGui = false;
    }

    public int[] makeBakedQuadParts(VectorUV[] vertices) {
        int[] data = new int[28];
        for (int vertex = 0; vertex < 4; ++vertex) {
            int l = vertex * 7;
            data[l] = Float.floatToRawIntBits(vertices[vertex].x);
            data[l + 1] = Float.floatToRawIntBits(vertices[vertex].y);
            data[l + 2] = Float.floatToRawIntBits(vertices[vertex].z);
            data[l + 3] = -1;
            data[l + 4] = Float.floatToRawIntBits(vertices[vertex].u);
            data[l + 4 + 1] = Float.floatToRawIntBits(vertices[vertex].v);
        }
        return data;
    }

    public void addTrapezoidBox(List<BakedQuad> list, float x, float y, float z, float wf, float hf, float df, float sides, float top, float bottom, int wi, int hi, int di, boolean mirror) {
        VectorUV[] vertexPositions = new VectorUV[8];
        float par10 = 0.0f;
        float x2 = x + wf;
        float y2 = y + hf;
        float z2 = z + df;
        x -= par10;
        y -= par10;
        z -= par10;
        x2 += par10;
        y2 += par10;
        z2 += par10;
        if (mirror) {
            float f7 = x2;
            x2 = x;
            x = f7;
        }
        vertexPositions[0] = new VectorUV(x - sides, y - top, z, 0.0f, 0.0f);
        vertexPositions[1] = new VectorUV(x2 + sides, y - top, z, 0.0f, 8.0f);
        vertexPositions[2] = new VectorUV(x2 + sides, y2 + bottom, z, 8.0f, 8.0f);
        vertexPositions[3] = new VectorUV(x - sides, y2 + bottom, z, 8.0f, 0.0f);
        vertexPositions[4] = new VectorUV(x, y, z2, 0.0f, 0.0f);
        vertexPositions[5] = new VectorUV(x2, y, z2, 0.0f, 8.0f);
        vertexPositions[6] = new VectorUV(x2, y2, z2, 8.0f, 8.0f);
        vertexPositions[7] = new VectorUV(x, y2, z2, 8.0f, 0.0f);
        list.add(new BakedQuad(this.makeBakedQuadParts(new VectorUV[]{vertexPositions[5], vertexPositions[1], vertexPositions[2], vertexPositions[6]}), -1, null, backpackSprites.get(this.color), true, DefaultVertexFormats.field_176600_a));
        list.add(new BakedQuad(this.makeBakedQuadParts(new VectorUV[]{vertexPositions[5], vertexPositions[1], vertexPositions[2], vertexPositions[6]}), -1, null, backpackSprites.get(this.color), true, DefaultVertexFormats.field_176600_a));
        list.add(new BakedQuad(this.makeBakedQuadParts(new VectorUV[]{vertexPositions[5], vertexPositions[4], vertexPositions[0], vertexPositions[1]}), -1, null, backpackSprites.get(this.color), true, DefaultVertexFormats.field_176600_a));
        list.add(new BakedQuad(this.makeBakedQuadParts(new VectorUV[]{vertexPositions[2], vertexPositions[3], vertexPositions[7], vertexPositions[6]}), -1, null, backpackSprites.get(this.color), true, DefaultVertexFormats.field_176600_a));
        list.add(new BakedQuad(this.makeBakedQuadParts(new VectorUV[]{vertexPositions[1], vertexPositions[0], vertexPositions[3], vertexPositions[2]}), -1, null, backpackSprites.get(this.color), true, DefaultVertexFormats.field_176600_a));
        list.add(new BakedQuad(this.makeBakedQuadParts(new VectorUV[]{vertexPositions[4], vertexPositions[5], vertexPositions[6], vertexPositions[7]}), -1, null, backpackSprites.get(this.color), true, DefaultVertexFormats.field_176600_a));
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        int textureSize = 16;
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        BlockFaceUV uv = new BlockFaceUV(new float[]{0.0f, 0.0f, textureSize, textureSize}, 0);
        BlockPartFace face = new BlockPartFace(null, 0, "", uv);
        ModelRotation modelRot = ModelRotation.X0_Y0;
        boolean scale = true;
        if (this.isGui) {
            list.add(faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f((float)textureSize, (float)textureSize, 0.0f), face, backpackSprites.get(this.color), EnumFacing.NORTH, modelRot, null, scale, true));
            list.add(faceBakery.func_178414_a(new Vector3f((float)textureSize, (float)textureSize, 0.01f), new Vector3f(0.0f, 0.0f, 0.01f), face, backpackSprites.get(this.color), EnumFacing.NORTH.func_176734_d(), modelRot, null, scale, true));
            list.add(faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, (float)textureSize), new Vector3f((float)textureSize, (float)textureSize, (float)textureSize), face, backpackSprites.get(this.color), EnumFacing.SOUTH, modelRot, null, scale, true));
            list.add(faceBakery.func_178414_a(new Vector3f((float)textureSize, (float)textureSize, 15.99f), new Vector3f(0.0f, 0.0f, 15.99f), face, backpackSprites.get(this.color), EnumFacing.SOUTH.func_176734_d(), modelRot, null, scale, true));
            list.add(faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, (float)textureSize, (float)textureSize), face, backpackSprites.get(this.color), EnumFacing.WEST, modelRot, null, scale, true));
            list.add(faceBakery.func_178414_a(new Vector3f(0.01f, (float)textureSize, (float)textureSize), new Vector3f(0.01f, 0.0f, 0.0f), face, backpackSprites.get(this.color), EnumFacing.WEST.func_176734_d(), modelRot, null, scale, true));
            list.add(faceBakery.func_178414_a(new Vector3f((float)textureSize, 0.0f, 0.0f), new Vector3f((float)textureSize, (float)textureSize, (float)textureSize), face, backpackSprites.get(this.color), EnumFacing.EAST, modelRot, null, scale, true));
            list.add(faceBakery.func_178414_a(new Vector3f(15.99f, (float)textureSize, (float)textureSize), new Vector3f(15.99f, 0.0f, 0.0f), face, backpackSprites.get(this.color), EnumFacing.EAST.func_176734_d(), modelRot, null, scale, true));
        } else if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.CUTOUT || this.isItem) {
            list.add(faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f((float)textureSize, (float)textureSize, 0.0f), face, backpackSprites.get(this.color), EnumFacing.NORTH, modelRot, null, scale, true));
            this.addTrapezoidBox(list, -6.0f, -10.0f, 8.5f, 12.0f, 18.0f, 4.0f, 1.5f, 2.5f, 0.5f, 12, 18, 4, false);
            this.addTrapezoidBox(list, -5.5f, -1.5f, 12.0f, 11.0f, 9.2f, 1.5f, 0.5f, 1.5f, 0.2f, 10, 8, 4, false);
            this.addTrapezoidBox(list, -4.0f, 1.0f, 13.5f, 8.0f, 6.3f, 1.5f, 1.5f, 2.5f, 0.5f, 8, 6, 4, false);
            this.addTrapezoidBox(list, -1.0f, -5.5f, 12.0f, 2.0f, 2.0f, 2.0f, 1.5f, 2.5f, 0.5f, 2, 2, 2, false);
            this.addTrapezoidBox(list, -5.0f, -8.5f, 12.0f, 10.0f, 6.0f, 1.5f, 1.0f, 1.5f, 4.5f, 10, 6, 2, false);
        }
        return list;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        this.isGui = true;
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return backpackSprites.get(this.color);
    }

    public ItemCameraTransforms func_177552_f() {
        return new ItemCameraTransforms(MovedUp, ItemTransformVec3f.field_178366_a, ItemTransformVec3f.field_178366_a, ItemTransformVec3f.field_178366_a, ItemTransformVec3f.field_178366_a, ItemTransformVec3f.field_178366_a, ItemTransformVec3f.field_178366_a, ItemTransformVec3f.field_178366_a);
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelState)MovedUp, (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    static {
        MovedUp = new ItemTransformVec3f(new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(-0.05f, 0.05f, -0.15f), new Vector3f(-0.5f, -0.5f, -0.5f));
    }

    class VectorUV {
        public float x;
        public float y;
        public float z;
        public float u;
        public float v;

        public VectorUV(float x, float y, float z, float u, float v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
        }
    }
}

