/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.command;

import cf.terminator.laggoggles.Main;
import cf.terminator.laggoggles.api.Profiler;
import cf.terminator.laggoggles.client.gui.GuiScanResultsWorld;
import cf.terminator.laggoggles.packet.ObjectData;
import cf.terminator.laggoggles.profiler.ProfileResult;
import cf.terminator.laggoggles.profiler.ScanType;
import cf.terminator.laggoggles.server.RequestResultHandler;
import cf.terminator.laggoggles.server.ScanRequestHandler;
import cf.terminator.laggoggles.util.ClickableLink;
import cf.terminator.laggoggles.util.Perms;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class LagGogglesCommand
extends CommandBase {
    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public String func_71517_b() {
        return "LagGoggles".toLowerCase();
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b();
    }

    public void func_184881_a(MinecraftServer server, final ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 2 && args[0].equalsIgnoreCase("start")) {
            long secondsLeft;
            if (!this.hasPerms(sender, Perms.Permission.START)) {
                throw new CommandException("You don't have permission to do this!", new Object[0]);
            }
            final int seconds = LagGogglesCommand.func_175755_a((String)args[1]);
            if (!Profiler.canProfile()) {
                throw new CommandException("Profiler is already running.", new Object[0]);
            }
            if (sender instanceof EntityPlayerMP && !this.hasPerms(sender, Perms.Permission.FULL) && (secondsLeft = ScanRequestHandler.secondsLeft(((EntityPlayerMP)sender).func_146103_bH().getId())) > 0L) {
                throw new CommandException("Please wait " + secondsLeft + " seconds.", new Object[0]);
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Main.LOGGER.info("Profiler started by " + sender.func_70005_c_() + " (" + seconds + " seconds)");
                    sender.func_145747_a((ITextComponent)new TextComponentString("Running..."));
                    Profiler.runProfiler(seconds, ScanType.WORLD);
                    sender.func_145747_a((ITextComponent)new TextComponentString("Done! You can see results using /" + LagGogglesCommand.this.func_71517_b() + " dump"));
                    Main.LOGGER.info("Finished profiling!");
                }
            }).start();
            return;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("dump")) {
            if (!this.hasPerms(sender, Perms.Permission.GET)) {
                throw new CommandException("You don't have permission to do this!", new Object[0]);
            }
            this.dump(sender);
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "Running LagGoggles version: " + TextFormatting.GREEN + "FORGE-1.12.2-4.1"));
        sender.func_145747_a((ITextComponent)ClickableLink.getLink("https://minecraft.curseforge.com/projects/laggoggles"));
        sender.func_145747_a((ITextComponent)new TextComponentString(""));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "Available arguments:"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "/" + this.func_71517_b() + " " + TextFormatting.WHITE + "start <seconds>"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "/" + this.func_71517_b() + " " + TextFormatting.WHITE + "dump"));
    }

    private boolean hasPerms(ICommandSender sender, Perms.Permission permission) {
        if (sender instanceof MinecraftServer) {
            return true;
        }
        if (sender instanceof EntityPlayerMP) {
            return Perms.hasPermission((EntityPlayer)((EntityPlayerMP)sender), permission);
        }
        Main.LOGGER.info("Unknown object is executing a command, assuming it's okay. Object: (" + sender + ") Class: (" + sender.getClass().toString() + ")");
        return true;
    }

    private void dump(ICommandSender sender) throws CommandException {
        ProfileResult result;
        ProfileResult fullResult = Profiler.getLatestResult();
        if (fullResult == null) {
            throw new CommandException("No result available.", new Object[0]);
        }
        if (fullResult.getType() != ScanType.WORLD) {
            throw new CommandException("Result is not of type WORLD.", new Object[0]);
        }
        if (sender instanceof EntityPlayerMP && !this.hasPerms(sender, Perms.Permission.FULL)) {
            long secondsLeft = RequestResultHandler.secondsLeft(((EntityPlayerMP)sender).func_146103_bH().getId());
            if (secondsLeft > 0L) {
                throw new CommandException("Please wait " + secondsLeft + " seconds.", new Object[0]);
            }
            result = Perms.getResultFor((EntityPlayerMP)sender, fullResult);
        } else {
            result = fullResult;
        }
        this.msg(sender, "Total ticks", result.getTickCount());
        this.msg(sender, "Total time", result.getTotalTime() / 1000L / 1000L / 1000L + " seconds");
        this.msg(sender, "TPS", (double)Math.round(result.getTPS() * 100.0) / 100.0);
        this.title(sender, "ENTITIES");
        boolean has = false;
        for (GuiScanResultsWorld.LagSource source : result.getLagSources()) {
            if (source.data.type != ObjectData.Type.ENTITY) continue;
            this.msg(sender, LagGogglesCommand.muPerTickString(source.nanos, result), source.data);
            has = true;
        }
        if (!has) {
            sender.func_145747_a((ITextComponent)new TextComponentString("None"));
        }
        has = false;
        this.title(sender, "TILE ENTITIES");
        for (GuiScanResultsWorld.LagSource source : result.getLagSources()) {
            if (source.data.type != ObjectData.Type.TILE_ENTITY) continue;
            this.msg(sender, LagGogglesCommand.muPerTickString(source.nanos, result), source.data);
            has = true;
        }
        if (!has) {
            sender.func_145747_a((ITextComponent)new TextComponentString("None"));
        }
        has = false;
        this.title(sender, "BLOCKS");
        for (GuiScanResultsWorld.LagSource source : result.getLagSources()) {
            if (source.data.type != ObjectData.Type.BLOCK) continue;
            this.msg(sender, LagGogglesCommand.muPerTickString(source.nanos, result), source.data);
            has = true;
        }
        if (!has) {
            sender.func_145747_a((ITextComponent)new TextComponentString("None"));
        }
        has = false;
        this.title(sender, "EVENTS");
        for (GuiScanResultsWorld.LagSource source : result.getLagSources()) {
            if (source.data.type != ObjectData.Type.EVENT_BUS_LISTENER) continue;
            this.msg(sender, LagGogglesCommand.muPerTickString(source.nanos, result), source.data);
            has = true;
        }
        if (!has) {
            sender.func_145747_a((ITextComponent)new TextComponentString("None"));
        }
        this.title(sender, "END");
        sender.func_145747_a((ITextComponent)new TextComponentString("Results printed, copy your log."));
    }

    private void msg(ICommandSender sender, String key, Object value) {
        sender.func_145747_a((ITextComponent)new TextComponentString(key + ": " + value));
    }

    private void title(ICommandSender sender, String title) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "---[ " + title + " ]---"));
    }

    private static String muPerTickString(long nanos, ProfileResult result) {
        if (result == null) {
            return "?";
        }
        return Double.valueOf(nanos / result.getTickCount() / 1000L).intValue() + " micro-s/t";
    }
}

