/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import assets.recipehandler.CraftingHandler;
import assets.recipehandler.FurnaceHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class RecipeCommand
extends CommandBase {
    private static final RecipeItemHelper HELPER = new RecipeItemHelper();

    public String func_71517_b() {
        return "recipes";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.recipes.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if ("get".equals(args[0])) {
            if (args.length == 2) {
                return RecipeCommand.func_71530_a((String[])args, (String[])new String[]{"by_name", "by_item", "by_held"});
            }
            if (args.length == 3) {
                if ("by_name".equals(args[1])) {
                    return RecipeCommand.func_175762_a((String[])args, (Collection)ForgeRegistries.RECIPES.getKeys());
                }
                if ("by_item".equals(args[1])) {
                    return RecipeCommand.func_175762_a((String[])args, (Collection)ForgeRegistries.ITEMS.getKeys());
                }
            }
        }
        if ("check".equals(args[0])) {
            return RecipeCommand.func_71530_a((String[])args, (String[])new String[]{"result", "ingredients", "space"});
        }
        if ("container".equals(args[0])) {
            return RecipeCommand.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
        return args.length == 1 ? RecipeCommand.func_71530_a((String[])args, (String[])new String[]{"check", "conflict", "get", "dump", "container", "furnace"}) : super.func_184883_a(server, sender, args, targetPos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if ("conflict".equals(args[0])) {
            HashSet done = Sets.newHashSetWithExpectedSize((int)1000);
            IntArrayList leftA = new IntArrayList();
            IntArrayList leftB = new IntArrayList();
            for (IRecipe recipeA : ForgeRegistries.RECIPES) {
                for (IRecipe recipeB : ForgeRegistries.RECIPES) {
                    if (RecipeCommand.areSameGroup(recipeA, recipeB) || done.contains(recipeB.getRegistryName()) || ItemStack.func_77989_b((ItemStack)recipeA.func_77571_b(), (ItemStack)recipeB.func_77571_b())) continue;
                    HELPER.func_194119_a();
                    recipeA.func_192400_c().forEach(RecipeCommand::accountStacks);
                    leftB.clear();
                    if (!HELPER.func_194116_a(recipeB, (IntList)leftB)) continue;
                    HELPER.func_194119_a();
                    recipeB.func_192400_c().forEach(RecipeCommand::accountStacks);
                    leftA.clear();
                    if (!HELPER.func_194116_a(recipeA, (IntList)leftA) || !leftA.equals(leftB) || !RecipeCommand.canFit(recipeA, recipeB)) continue;
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.recipes.conflict", new Object[]{recipeA.getRegistryName(), recipeB.getRegistryName()}));
                }
                done.add(recipeA.getRegistryName());
            }
            return;
        }
        if ("dump".equals(args[0])) {
            ArrayList texts = Lists.newArrayListWithCapacity((int)1000);
            for (ResourceLocation key : ForgeRegistries.RECIPES.getKeys()) {
                texts.add(new TextComponentString(key.toString() + " | "));
            }
            RecipeCommand.sendMessages(sender, texts, 5);
            texts.clear();
            return;
        }
        if ("get".equals(args[0]) && args.length >= 2) {
            ItemStack stack = ItemStack.field_190927_a;
            if ("by_held".equals(args[1]) && sender.func_174793_f() != null) {
                for (ItemStack equiped : sender.func_174793_f().func_184214_aD()) {
                    if (equiped.func_190926_b()) continue;
                    stack = equiped;
                    break;
                }
            }
            if ("by_item".equals(args[1]) && args.length == 3) {
                stack = new ItemStack(RecipeCommand.func_147179_f((ICommandSender)sender, (String)args[2]));
            }
            if (!stack.func_190926_b()) {
                for (IRecipe recipeReg : ForgeRegistries.RECIPES) {
                    if (!ItemStack.func_185132_d((ItemStack)recipeReg.func_77571_b(), (ItemStack)stack)) continue;
                    RecipeCommand.displayRecipe(sender, recipeReg);
                }
            }
            if (!"by_name".equals(args[1]) || args.length != 3) return;
            IRecipe recipe = (IRecipe)ForgeRegistries.RECIPES.getValue(new ResourceLocation(args[2]));
            if (recipe == null) throw new CommandException("commands.recipes.notFound", new Object[]{args[2]});
            RecipeCommand.displayRecipe(sender, recipe);
            return;
        }
        if ("check".equals(args[0])) {
            ArrayList messages = Lists.newArrayListWithCapacity((int)20);
            if ("result".equals(args[1])) {
                for (IRecipe recipe : ForgeRegistries.RECIPES) {
                    if (recipe.func_192399_d() || !recipe.func_77571_b().func_190926_b()) continue;
                    messages.add(new TextComponentTranslation("commands.recipes.empty_output", new Object[]{recipe.getRegistryName()}));
                }
            } else if ("ingredients".equals(args[1])) {
                for (IRecipe recipe : ForgeRegistries.RECIPES) {
                    if (recipe.func_192399_d() || !RecipeCommand.emptyIngredients((Collection<Ingredient>)recipe.func_192400_c())) continue;
                    messages.add(new TextComponentTranslation("commands.recipes.empty_ingredients", new Object[]{recipe.getRegistryName()}));
                }
            } else {
                if (!"space".equals(args[1]) || args.length != 4) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                int width = RecipeCommand.func_180528_a((String)args[2], (int)1);
                int height = RecipeCommand.func_180528_a((String)args[3], (int)1);
                InventoryCrafting inv = new InventoryCrafting(new Container(){

                    public boolean func_75145_c(EntityPlayer playerIn) {
                        return true;
                    }
                }, width, height);
                for (IRecipe recipe : ForgeRegistries.RECIPES) {
                    if (recipe.func_192399_d()) continue;
                    if (!recipe.func_194133_a(width, height)) {
                        messages.add(new TextComponentTranslation("commands.recipes.bigger_space", new Object[]{recipe.getRegistryName(), width, height}));
                    }
                    if (!recipe.func_77569_a(inv, sender.func_130014_f_())) continue;
                    messages.add(new TextComponentTranslation("commands.recipes.match_empty", new Object[]{recipe.getRegistryName(), width, height}));
                }
            }
            RecipeCommand.sendMessages(sender, messages, 1);
            messages.clear();
            return;
        }
        if ("container".equals(args[0]) && args.length == 2) {
            boolean flag = RecipeCommand.func_180527_d((String)args[1]);
            Set<String> cont = CraftingHandler.getContainers(flag);
            if (cont == null) return;
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.recipes.container." + flag, new Object[]{cont}));
            return;
        } else {
            if (!"furnace".equals(args[0])) return;
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.recipes.furnace", new Object[]{FurnaceHandler.compare()}));
        }
    }

    private static boolean areSameGroup(IRecipe recipeA, IRecipe recipeB) {
        return recipeA.getRegistryName().func_110624_b().equals(recipeB.getRegistryName().func_110624_b()) || RecipeCommand.emptyIngredients((Collection<Ingredient>)recipeA.func_192400_c()) || RecipeCommand.emptyIngredients((Collection<Ingredient>)recipeB.func_192400_c());
    }

    private static boolean emptyIngredients(Collection<Ingredient> ingredients) {
        return ingredients.isEmpty() || ingredients.stream().allMatch(ingredient -> ingredient == Ingredient.field_193370_a || ingredient.apply(ItemStack.field_190927_a) || Arrays.stream(ingredient.func_193365_a()).allMatch(ItemStack::func_190926_b));
    }

    private static void displayRecipe(ICommandSender sender, IRecipe recipe) {
        TextComponentTranslation message = new TextComponentTranslation("commands.recipes.found", new Object[]{recipe.getRegistryName()});
        sender.func_145747_a((ITextComponent)message);
        if (!recipe.func_77571_b().func_190926_b()) {
            sender.func_145747_a(recipe.func_77571_b().func_151000_E());
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.recipes.empty_output", new Object[]{recipe.getRegistryName()}));
        }
        int max = 0;
        for (Ingredient ingredient : recipe.func_192400_c()) {
            max = max < ingredient.func_193365_a().length ? ingredient.func_193365_a().length : max;
        }
        ArrayList texts = Lists.newArrayListWithCapacity((int)(max * recipe.func_192400_c().size()));
        for (int index = 0; index < max; ++index) {
            message = new TextComponentTranslation(index > 0 ? "commands.recipes.orMadeFrom" : "commands.recipes.madeFrom", new Object[0]);
            sender.func_145747_a((ITextComponent)message);
            for (Ingredient ingredient : recipe.func_192400_c()) {
                int length = ingredient.func_193365_a().length;
                texts.add(length > 0 ? ingredient.func_193365_a()[index < length ? index : 0].func_151000_E() : ItemStack.field_190927_a.func_151000_E());
            }
            RecipeCommand.sendMessages(sender, texts, recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeWidth() : (texts.size() > 1 ? texts.size() - 1 : 1));
            texts.clear();
        }
        if (max == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.recipes.empty_ingredients", new Object[]{recipe.getRegistryName()}));
        }
    }

    private static void sendMessages(ICommandSender sender, Collection<ITextComponent> texts, int width) {
        for (int divider = width; divider > 0; --divider) {
            if (texts.size() % divider != 0 && width == texts.size() - 1) continue;
            Iterator<ITextComponent> itr = texts.iterator();
            for (int i = 0; i < texts.size(); i += divider) {
                ITextComponent message = itr.next();
                for (int j = i + 1; j < i + divider && j < texts.size(); ++j) {
                    message.func_150257_a(itr.next());
                }
                sender.func_145747_a(message);
            }
            break;
        }
    }

    private static boolean canFit(IRecipe recipeA, IRecipe recipeB) {
        if (recipeA instanceof IShapedRecipe) {
            if (recipeB instanceof IShapedRecipe) {
                return ((IShapedRecipe)recipeA).getRecipeWidth() == ((IShapedRecipe)recipeB).getRecipeWidth() && ((IShapedRecipe)recipeA).getRecipeHeight() == ((IShapedRecipe)recipeB).getRecipeHeight();
            }
            if (!recipeB.func_194133_a(((IShapedRecipe)recipeA).getRecipeWidth(), ((IShapedRecipe)recipeA).getRecipeHeight())) {
                return false;
            }
        }
        if (recipeB instanceof IShapedRecipe && !recipeA.func_194133_a(((IShapedRecipe)recipeB).getRecipeWidth(), ((IShapedRecipe)recipeB).getRecipeHeight())) {
            return false;
        }
        for (int i = 1; i < 10; ++i) {
            for (int j = 1; j < 10; ++j) {
                if (recipeA.func_194133_a(i, j) == recipeB.func_194133_a(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    private static void accountStacks(Ingredient ingredient) {
        for (ItemStack stack : ingredient.func_193365_a()) {
            HELPER.func_194112_a(stack);
        }
    }
}

