/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import assets.recipehandler.CraftingSpace;
import assets.recipehandler.ICompat;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.crafting.IRecipeContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class CraftingHandler {
    private static HashMap<String, Field> knownCraftingContainer;
    private static HashSet<String> notCraftingContainer;
    private static HashSet<ICompat> compatibilities;
    private static Field slotCraftInv;
    private static ArrayList<IRecipe> crafts;
    private static int previousNumberOfCraft;
    private static long delayTimer;
    private static int recipeIndex;

    public static void enableGuessing(List<String> blackList) {
        knownCraftingContainer = new HashMap(10);
        notCraftingContainer = new HashSet<String>(blackList);
        slotCraftInv = ReflectionHelper.findField(SlotCrafting.class, (String[])new String[]{"field_75239_a", "craftMatrix"});
    }

    public static boolean addCompatibility(ICompat module) {
        return compatibilities.add(module);
    }

    public static int getRecipeIndex() {
        return recipeIndex;
    }

    public static void setRecipeIndex(int id) {
        if (id >= 0) {
            recipeIndex = id;
        }
    }

    @Nullable
    public static InventoryCrafting getCraftingMatrix(@Nullable Container container) {
        String name;
        if (container == null) {
            return null;
        }
        if (container instanceof ContainerPlayer) {
            return ((ContainerPlayer)container).field_75181_e;
        }
        if (container instanceof ContainerWorkbench) {
            return ((ContainerWorkbench)container).field_75162_e;
        }
        if (container instanceof IRecipeContainer) {
            return ((IRecipeContainer)container).getCraftMatrix();
        }
        if (notCraftingContainer != null && !notCraftingContainer.contains(name = container.getClass().getName())) {
            for (Slot slot : container.field_75151_b) {
                if (slot == null || !(slot.field_75224_c instanceof InventoryCrafting)) continue;
                return (InventoryCrafting)slot.field_75224_c;
            }
            for (ICompat iCompat : compatibilities) {
                if (!iCompat.getContainer().equals(name)) continue;
                return iCompat.getCraftInv(container);
            }
            Field f = knownCraftingContainer.get(name);
            if (f == null) {
                for (Field field : container.getClass().getDeclaredFields()) {
                    if (field == null) continue;
                    try {
                        field.setAccessible(true);
                        InventoryCrafting craft = CraftingHandler.convert(field.get(container));
                        if (craft == null) continue;
                        knownCraftingContainer.put(name, field);
                        return craft;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                notCraftingContainer.add(name);
            } else {
                try {
                    return CraftingHandler.convert(f.get(container));
                }
                catch (Exception exception) {
                    knownCraftingContainer.put(name, null);
                }
            }
        }
        return null;
    }

    @Nullable
    private static InventoryCrafting convert(Object craft) {
        IItemHandler handler;
        if (craft instanceof InventoryCrafting) {
            return (InventoryCrafting)craft;
        }
        if (craft instanceof IItemHandler && ((IItemHandler)craft).getSlots() == 9) {
            return CraftingSpace.ITEM_HANDLER.copy((IItemHandler)craft);
        }
        if (craft instanceof IInventory && ((IInventory)craft).func_70302_i_() == 9) {
            return CraftingSpace.INVENTORY.copy((IInventory)craft);
        }
        if (craft instanceof ICapabilityProvider && (handler = (IItemHandler)((ICapabilityProvider)craft).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null && handler.getSlots() == 9) {
            return CraftingSpace.ITEM_HANDLER.copy(handler);
        }
        return null;
    }

    public static ItemStack findNextMatchingRecipe(InventoryCrafting craft, @Nullable World world) {
        recipeIndex = recipeIndex == Integer.MAX_VALUE ? 0 : ++recipeIndex;
        return CraftingHandler.findCraftResult(craft, world);
    }

    public static ItemStack findCraftResult(InventoryCrafting craft, @Nullable World world) {
        IRecipe recipe = CraftingHandler.findMatchingRecipe(craft, world);
        return recipe != null ? recipe.func_77572_b(craft) : ItemStack.field_190927_a;
    }

    @Nullable
    public static IRecipe findMatchingRecipe(InventoryCrafting craft, @Nullable World world) {
        if (world == null) {
            return null;
        }
        CraftingHandler.getCrafts(craft, world);
        delayTimer = world.func_82737_E();
        if (previousNumberOfCraft <= 0) {
            recipeIndex = 0;
            return null;
        }
        return crafts.get(recipeIndex % previousNumberOfCraft);
    }

    public static List<IRecipe> getCrafts(InventoryCrafting craft, World world) {
        if (crafts.isEmpty() || !crafts.get(previousNumberOfCraft <= 0 ? 0 : recipeIndex % previousNumberOfCraft).func_77569_a(craft, world)) {
            crafts.clear();
            for (IRecipe irecipe : ForgeRegistries.RECIPES) {
                if (!irecipe.func_77569_a(craft, world)) continue;
                crafts.add(irecipe);
            }
        }
        previousNumberOfCraft = crafts.size();
        return crafts;
    }

    public static boolean setCraftUsed(EntityPlayerMP player, IRecipe recipe) {
        if (recipe.func_192399_d() || !player.func_130014_f_().func_82736_K().func_82766_b("doLimitedCrafting") || player.func_192037_E().func_193830_f(recipe)) {
            InventoryCraftResult resultInv = CraftingHandler.getResultInv(player.field_71070_bA);
            if (resultInv != null) {
                resultInv.func_193056_a(recipe);
            } else {
                try {
                    for (Field recF : player.field_71070_bA.getClass().getDeclaredFields()) {
                        if (!recF.getType().equals(IRecipe.class)) continue;
                        recF.setAccessible(true);
                        recF.set(player.field_71070_bA, recipe);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static Slot getResultSlot(Container container, InventoryCrafting inventory, int index) {
        Slot slot;
        if (index < container.field_75151_b.size() && (slot = container.func_75139_a(index)) instanceof SlotCrafting) {
            return slot;
        }
        InventoryCraftResult resultInv = CraftingHandler.getResultInv(container);
        if (resultInv != null) {
            for (Slot slot2 : container.field_75151_b) {
                if (slot2 == null || !slot2.func_75217_a((IInventory)resultInv, slot2.getSlotIndex())) continue;
                return slot2;
            }
        } else {
            String type = container.getClass().getName();
            for (ICompat mod : compatibilities) {
                if (!mod.getContainer().equals(type)) continue;
                return mod.getResultSlot(container);
            }
        }
        if (slotCraftInv != null) {
            try {
                for (Slot slot2 : container.field_75151_b) {
                    if (!(slot2 instanceof SlotCrafting) || inventory != slotCraftInv.get(slot2)) continue;
                    return slot2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static InventoryCraftResult getResultInv(Container container) {
        if (container instanceof ContainerPlayer) {
            return ((ContainerPlayer)container).field_75179_f;
        }
        if (container instanceof ContainerWorkbench) {
            return ((ContainerWorkbench)container).field_75160_f;
        }
        if (container instanceof IRecipeContainer) {
            return ((IRecipeContainer)container).getCraftResult();
        }
        for (Slot slot : container.field_75151_b) {
            if (slot == null || !(slot.field_75224_c instanceof InventoryCraftResult)) continue;
            return (InventoryCraftResult)slot.field_75224_c;
        }
        return null;
    }

    public static int getNumberOfCraft(@Nullable Container container, @Nullable World world) {
        if (world == null) {
            return -1;
        }
        if (world.func_82737_E() - delayTimer > 10L) {
            delayTimer = world.func_82737_E();
            InventoryCrafting craft = CraftingHandler.getCraftingMatrix(container);
            if (craft == null) {
                previousNumberOfCraft = -1;
                return -1;
            }
            InventoryCraftResult result = CraftingHandler.getResultInv(container);
            if (result != null && result.func_191420_l()) {
                CraftingHandler.reset();
            } else {
                CraftingHandler.getCrafts(craft, world);
            }
        }
        return previousNumberOfCraft;
    }

    private static void reset() {
        if (previousNumberOfCraft != 0) {
            previousNumberOfCraft = 0;
            recipeIndex = 0;
        }
    }

    @Nullable
    public static Set<String> getContainers(boolean isCraft) {
        return isCraft ? (knownCraftingContainer != null ? knownCraftingContainer.keySet() : null) : notCraftingContainer;
    }

    static {
        compatibilities = new HashSet(4);
        crafts = new ArrayList(2);
        previousNumberOfCraft = 0;
        delayTimer = 0L;
        recipeIndex = 0;
    }
}

