/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import assets.recipehandler.CraftingHandler;
import assets.recipehandler.RecipeMod;
import com.google.common.util.concurrent.ListenableFuture;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

public final class ChangePacket {
    public static final String CHANNEL = "recipemod:key";
    private ItemStack itemstack = ItemStack.field_190927_a;
    private int slot;
    private int index;
    private boolean shift;

    public ChangePacket() {
    }

    public ChangePacket(int slot, @Nonnull ItemStack stack, int recipeIndex) {
        this.slot = slot;
        this.itemstack = stack;
        this.index = recipeIndex;
    }

    public ChangePacket setShift() {
        this.shift = true;
        return this;
    }

    public ChangePacket fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        this.itemstack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.index = buf.readInt();
        this.shift = buf.readBoolean();
        return this;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemstack);
        buf.writeInt(this.index);
        buf.writeBoolean(this.shift);
    }

    @Nullable
    ChangePacket handle(final EntityPlayerMP player) {
        if (!this.itemstack.func_190926_b() && this.slot >= 0 && this.index >= 0) {
            ListenableFuture future = player.field_71133_b.func_175586_a((Callable)new Callable<ChangePacket>(){

                @Override
                @Nullable
                public ChangePacket call() {
                    InventoryCrafting crafting = CraftingHandler.getCraftingMatrix(player.field_71070_bA);
                    if (crafting != null) {
                        Slot result;
                        ItemStack itr;
                        CraftingHandler.setRecipeIndex(ChangePacket.this.index);
                        IRecipe recipe = CraftingHandler.findMatchingRecipe(crafting, player.func_130014_f_());
                        if (recipe != null && ItemStack.func_77989_b((ItemStack)(itr = recipe.func_77572_b(crafting)), (ItemStack)ChangePacket.this.itemstack) && (result = CraftingHandler.getResultSlot(player.field_71070_bA, crafting, ChangePacket.this.slot)) != null && CraftingHandler.setCraftUsed(player, recipe)) {
                            result.func_75215_d(ChangePacket.this.itemstack.func_77946_l());
                            if (ChangePacket.this.shift) {
                                return new ChangePacket(ChangePacket.this.slot, ChangePacket.this.itemstack, ChangePacket.this.index).setShift();
                            }
                            return new ChangePacket(ChangePacket.this.slot, ChangePacket.this.itemstack, ChangePacket.this.index);
                        }
                    }
                    return null;
                }
            });
            try {
                return (ChangePacket)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public FMLProxyPacket toProxy(Side side) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        this.toBytes((ByteBuf)buf);
        FMLProxyPacket proxy = new FMLProxyPacket(buf, CHANNEL);
        proxy.setTarget(side);
        return proxy;
    }

    public Runnable getRun() {
        return () -> {
            Slot result;
            Container container;
            InventoryCrafting crafting;
            if (!this.itemstack.func_190926_b() && (crafting = CraftingHandler.getCraftingMatrix(container = RecipeMod.registry.getContainer())) != null && (result = CraftingHandler.getResultSlot(container, crafting, this.slot)) != null) {
                result.func_75215_d(this.itemstack);
                if (this.shift) {
                    CraftingHandler.setRecipeIndex(this.index);
                    RecipeMod.registry.sendShift(crafting, result);
                }
            }
        };
    }
}

