/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import com.google.common.collect.Multimap;
import invtweaks.InvTweaksConfig;
import invtweaks.InvTweaksConfigManager;
import invtweaks.InvTweaksGuiSettingsButton;
import invtweaks.InvTweaksGuiSortingButton;
import invtweaks.InvTweaksHandlerSorting;
import invtweaks.InvTweaksItemTree;
import invtweaks.InvTweaksObfuscation;
import invtweaks.InvTweaksShortcutMapping;
import invtweaks.InvTweaksShortcutType;
import invtweaks.api.IItemTreeItem;
import invtweaks.api.SortingMethod;
import invtweaks.api.container.ContainerSection;
import invtweaks.container.ContainerSectionManager;
import invtweaks.container.DirectContainerManager;
import invtweaks.container.IContainerManager;
import invtweaks.forge.InvTweaksMod;
import invtweaks.integration.ItemListChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class InvTweaks
extends InvTweaksObfuscation {
    public static Logger log;
    private static InvTweaks instance;
    @Nullable
    private InvTweaksConfigManager cfgManager = null;
    private SortingMethod chestAlgorithm = SortingMethod.DEFAULT;
    private long chestAlgorithmClickTimestamp = 0L;
    private boolean chestAlgorithmButtonDown = false;
    @NotNull
    private ItemStack storedStack = ItemStack.field_190927_a;
    @Nullable
    private String storedStackId = null;
    private int storedStackDamage = Short.MAX_VALUE;
    private int storedFocusedSlot = -1;
    @NotNull
    private final ItemStack[] hotbarClone = new ItemStack[9];
    private boolean hadFocus = true;
    private boolean mouseWasDown = false;
    private boolean wasInGUI = false;
    private boolean previousRecipeBookVisibility = false;
    private int tickNumber = 0;
    private int lastPollingTickNumber = -3;
    private long sortingKeyPressedDate = 0L;
    private boolean sortKeyDown = false;
    private boolean sortKeyEnabled = true;
    private boolean textboxMode = false;
    private boolean itemPickupPending = false;
    private int itemPickupTimeout = 0;
    private String mostRecentComparison = "";
    private boolean debugTree = false;
    @NotNull
    private final List<String> queuedMessages = new ArrayList<String>();
    private final ItemListChecker itemListChecker = new ItemListChecker();

    public InvTweaks(Minecraft mc_) {
        super(mc_);
        for (int i = 0; i < this.hotbarClone.length; ++i) {
            this.hotbarClone[i] = ItemStack.field_190927_a;
        }
        instance = this;
        this.cfgManager = new InvTweaksConfigManager(this.mc);
        if (this.cfgManager.makeSureConfigurationIsLoaded()) {
            log.info("Mod initialized");
        } else {
            log.error("Mod failed to initialize!");
        }
    }

    public static void logInGameStatic(@NotNull String message) {
        InvTweaks.getInstance().logInGame(message);
    }

    public static void logInGameErrorStatic(@NotNull String message, @NotNull Exception e) {
        InvTweaks.getInstance().logInGameError(message, e);
    }

    public static InvTweaks getInstance() {
        return instance;
    }

    public static Minecraft getMinecraftInstance() {
        return InvTweaks.instance.mc;
    }

    @Nullable
    public static InvTweaksConfigManager getConfigManager() {
        if (instance == null) {
            return null;
        }
        return InvTweaks.instance.cfgManager;
    }

    @NotNull
    public static IContainerManager getContainerManager(@NotNull Container container) {
        return new DirectContainerManager(container);
    }

    @NotNull
    public static IContainerManager getCurrentContainerManager() {
        return InvTweaks.getContainerManager(InvTweaksObfuscation.getCurrentContainer());
    }

    private static int getContainerRowSize(@NotNull GuiContainer guiContainer) {
        return InvTweaks.getSpecialChestRowSize(guiContainer.field_147002_h);
    }

    @NotNull
    private static String buildLogString(@NotNull Level level, String message, @Nullable Exception e) {
        if (e != null) {
            StackTraceElement[] trace = e.getStackTrace();
            if (trace.length == 0) {
                return InvTweaks.buildLogString(level, message) + ": " + e.getMessage();
            }
            StackTraceElement exceptionLine = trace[0];
            if (exceptionLine != null && exceptionLine.getFileName() != null) {
                return InvTweaks.buildLogString(level, message) + ": " + e.getMessage() + " (l" + exceptionLine.getLineNumber() + " in " + exceptionLine.getFileName().replace("InvTweaks", "") + ")";
            }
            return InvTweaks.buildLogString(level, message) + ": " + e.getMessage();
        }
        return InvTweaks.buildLogString(level, message);
    }

    @NotNull
    private static String buildLogString(@NotNull Level level, String message) {
        return "InvTweaks: " + (level.equals(Level.SEVERE) ? "[ERROR] " : "") + message;
    }

    public void addScheduledTask(Runnable task) {
        InvTweaksMod.proxy.addClientScheduledTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTickInGame() {
        InvTweaks invTweaks = this;
        synchronized (invTweaks) {
            if (!this.onTick()) {
                return;
            }
            this.handleAutoRefill();
            if (this.wasInGUI) {
                this.wasInGUI = false;
                this.textboxMode = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTickInGUI(GuiScreen guiScreen) {
        if (this.mc.field_71442_b.func_78747_a()) {
            this.onTick();
            return;
        }
        InvTweaks invTweaks = this;
        synchronized (invTweaks) {
            ItemStack currentStack;
            this.handleMiddleClick(guiScreen);
            if (!this.onTick()) {
                return;
            }
            if (this.isTimeForPolling()) {
                this.unlockKeysIfNecessary();
            }
            if (InvTweaks.isGuiContainer(guiScreen)) {
                this.handleGUILayout((GuiContainer)guiScreen);
            }
            if (!this.wasInGUI) {
                this.mouseWasDown = true;
            }
            if (InvTweaks.isGuiContainer(guiScreen)) {
                this.handleShortcuts((GuiContainer)guiScreen);
            }
            this.storedStackId = (currentStack = this.getFocusedStack()).func_190926_b() ? null : currentStack.func_77973_b().getRegistryName().toString();
            int n = this.storedStackDamage = currentStack.func_190926_b() ? 0 : currentStack.func_77952_i();
            if (!this.wasInGUI) {
                this.wasInGUI = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSortingKeyPressed() {
        InvTweaks invTweaks = this;
        synchronized (invTweaks) {
            if (!this.cfgManager.makeSureConfigurationIsLoaded()) {
                return;
            }
            GuiScreen guiScreen = this.getCurrentScreen();
            if (guiScreen == null || InvTweaks.isGuiContainer(guiScreen) && (InvTweaks.isValidChest(((GuiContainer)guiScreen).field_147002_h) || InvTweaks.isValidInventory(((GuiContainer)guiScreen).field_147002_h))) {
                this.handleSorting(guiScreen);
            }
        }
    }

    public void onItemPickup() {
        if (!this.cfgManager.makeSureConfigurationIsLoaded()) {
            return;
        }
        InvTweaksConfig config = this.cfgManager.getConfig();
        if (this.cfgManager.getConfig().getProperty("enableSortingOnPickup").equals("false")) {
            this.itemPickupPending = false;
            return;
        }
        try {
            ContainerSectionManager containerMgr = new ContainerSectionManager(ContainerSection.INVENTORY);
            int currentSlot = -1;
            for (int i = 0; i < 9; ++i) {
                ItemStack currentHotbarStack = containerMgr.getItemStack(i + 27);
                if (currentHotbarStack.func_190926_b() || currentHotbarStack.func_190921_D() <= 0 || !this.hotbarClone[i].func_190926_b()) continue;
                currentSlot = i + 27;
            }
            if (currentSlot != -1) {
                this.itemPickupPending = false;
                InvTweaksItemTree tree = config.getTree();
                ItemStack stack = containerMgr.getItemStack(currentSlot);
                List<IItemTreeItem> items = tree.getItems(stack.func_77973_b().getRegistryName().toString(), stack.func_77952_i());
                List preferredPositions = config.getRules().stream().filter(rule -> tree.matches(items, rule.getKeyword())).flatMapToInt(e -> Arrays.stream(e.getPreferredSlots())).boxed().collect(Collectors.toList());
                boolean hasToBeMoved = true;
                Iterator iterator = preferredPositions.iterator();
                while (iterator.hasNext()) {
                    int newSlot = (Integer)iterator.next();
                    if (newSlot == currentSlot) {
                        hasToBeMoved = false;
                        break;
                    }
                    if (!containerMgr.getItemStack(newSlot).func_190926_b() || !containerMgr.move(currentSlot, newSlot)) continue;
                    break;
                }
                if (hasToBeMoved) {
                    for (int i = 0; !(i >= containerMgr.getSize() || containerMgr.getItemStack(i).func_190926_b() && containerMgr.move(currentSlot, i)); ++i) {
                    }
                }
                containerMgr.applyChanges();
            } else if (--this.itemPickupTimeout == 0) {
                this.itemPickupPending = false;
            }
        }
        catch (Exception e2) {
            this.logInGameError("Failed to move picked up stack", e2);
            this.itemPickupPending = false;
        }
    }

    public int compareItems(@NotNull ItemStack i, @NotNull ItemStack j) {
        return this.compareItems(i, j, this.getItemOrder(i), this.getItemOrder(j), false);
    }

    public int compareItems(@NotNull ItemStack i, @NotNull ItemStack j, boolean onlyTreeSort) {
        return this.compareItems(i, j, this.getItemOrder(i), this.getItemOrder(j), onlyTreeSort);
    }

    int compareItems(@NotNull ItemStack i, @NotNull ItemStack j, int orderI, int orderJ) {
        return this.compareItems(i, j, orderI, orderJ, false);
    }

    int compareItems(@NotNull ItemStack i, @NotNull ItemStack j, int orderI, int orderJ, boolean api) {
        if (i.func_190926_b() && j.func_190926_b()) {
            if (this.debugTree) {
                this.mostRecentComparison = "Both stacks are Empty.";
            }
            return 0;
        }
        if (j.func_190926_b()) {
            if (this.debugTree) {
                this.mostRecentComparison = "J is Empty.";
            }
            return -1;
        }
        if (i.func_190926_b() || orderI == -1) {
            if (this.debugTree) {
                this.mostRecentComparison = "I is Empty or orderI was -1.";
            }
            return 1;
        }
        if (this.debugTree) {
            this.mostRecentComparison = "";
        }
        if (api) {
            int lastOrder;
            if (this.debugTree) {
                this.mostRecentComparison = "API Active, ";
            }
            if (orderI > (lastOrder = this.cfgManager.getConfig().getTree().getLastTreeOrder())) {
                orderI = Integer.MAX_VALUE;
            }
            if (orderJ > lastOrder) {
                orderJ = Integer.MAX_VALUE;
            }
        }
        if (this.debugTree) {
            this.mostRecentComparison = this.mostRecentComparison + "I: " + orderI + ", J: " + orderJ;
        }
        if (orderI != orderJ) {
            if (this.debugTree) {
                this.mostRecentComparison = this.mostRecentComparison + ", Normal: " + (orderI - orderJ);
            }
            return orderI - orderJ;
        }
        if (orderI == Integer.MAX_VALUE && orderJ == Integer.MAX_VALUE && api) {
            if (this.debugTree) {
                this.mostRecentComparison = this.mostRecentComparison + ", API Bailout.";
            }
            return 0;
        }
        Item iItem = i.func_77973_b();
        Item jItem = j.func_77973_b();
        int cTool = this.compareTools(i, j, iItem, jItem);
        if (this.debugTree) {
            this.mostRecentComparison = this.mostRecentComparison + ", Tool: " + cTool;
        }
        if (cTool != 0) {
            return cTool;
        }
        int cSword = this.compareSword(i, j, iItem, jItem);
        if (this.debugTree) {
            this.mostRecentComparison = this.mostRecentComparison + ", Sword: " + cSword;
        }
        if (cSword != 0) {
            return cSword;
        }
        int cArmor = this.compareArmor(i, j, iItem, jItem);
        if (this.debugTree) {
            this.mostRecentComparison = this.mostRecentComparison + ", Armor: " + cArmor;
        }
        if (cArmor != 0) {
            return cArmor;
        }
        int cName = this.compareNames(i, j);
        if (this.debugTree) {
            this.mostRecentComparison = this.mostRecentComparison + ", Name" + cName;
        }
        if (cName != 0) {
            return cName;
        }
        int cEnchant = this.compareEnchantment(i, j);
        if (cEnchant != 0) {
            return cEnchant;
        }
        int maxDamage = InvTweaks.compareMaxDamage(i, j);
        if (this.debugTree) {
            this.mostRecentComparison = this.mostRecentComparison + ", Max Damage: " + maxDamage;
        }
        if (maxDamage != 0) {
            return maxDamage;
        }
        int curDamage = InvTweaks.compareCurDamage(i, j);
        if (this.debugTree) {
            this.mostRecentComparison = this.mostRecentComparison + ", Current Damage: " + curDamage;
        }
        if (curDamage != 0) {
            return curDamage;
        }
        if (j.func_190916_E() != i.func_190916_E()) {
            if (this.debugTree) {
                this.mostRecentComparison = this.mostRecentComparison + ", Stack Size";
            }
            return j.func_190916_E() - i.func_190916_E();
        }
        if (this.debugTree) {
            this.mostRecentComparison = this.mostRecentComparison + ", Final: " + ObjectUtils.compare((Comparable)((Object)i.func_77973_b().getRegistryName().toString()), (Comparable)((Object)j.func_77973_b().getRegistryName().toString()));
        }
        return ObjectUtils.compare((Comparable)((Object)i.func_77973_b().getRegistryName().toString()), (Comparable)((Object)j.func_77973_b().getRegistryName().toString()));
    }

    private int compareNames(ItemStack i, ItemStack j) {
        boolean iHasName = i.func_82837_s();
        boolean jHasName = j.func_82837_s();
        String iDisplayName = i.func_82833_r();
        String jDisplayName = j.func_82833_r();
        if (iHasName || jHasName) {
            if (!iHasName) {
                if (this.debugTree) {
                    this.mostRecentComparison = this.mostRecentComparison + ", J has custom Name";
                }
                return -1;
            }
            if (!jHasName) {
                if (this.debugTree) {
                    this.mostRecentComparison = this.mostRecentComparison + ", I has custom Name";
                }
                return 1;
            }
        }
        if (!iDisplayName.equals(jDisplayName)) {
            if (this.debugTree) {
                this.mostRecentComparison = this.mostRecentComparison + ", Name: " + iDisplayName.compareTo(jDisplayName);
            }
            return iDisplayName.compareTo(jDisplayName);
        }
        return 0;
    }

    private static int compareMaxDamage(ItemStack i, ItemStack j) {
        int maxDamage1 = i.func_77958_k() <= 0 ? Integer.MAX_VALUE : i.func_77958_k();
        int maxDamage2 = j.func_77958_k() <= 0 ? Integer.MAX_VALUE : j.func_77958_k();
        return maxDamage2 - maxDamage1;
    }

    private static int compareCurDamage(ItemStack i, ItemStack j) {
        int curDamage1 = i.func_77952_i();
        int curDamage2 = j.func_77952_i();
        if (i.func_77984_f() && !InvTweaks.getConfigManager().getConfig().getProperty("invertToolDamageSorting").equals("true")) {
            return curDamage2 - curDamage1;
        }
        return curDamage1 - curDamage2;
    }

    public static String getToolClass(ItemStack itemStack, Item item) {
        if (itemStack == null || item == null) {
            return "";
        }
        HashSet<String> toolClassSet = item.getToolClasses(itemStack);
        if (toolClassSet.contains("sword")) {
            HashSet<String> newClassSet = new HashSet<String>();
            for (String toolClass : toolClassSet) {
                if (toolClass == "sword") continue;
                newClassSet.add(toolClass);
            }
            toolClassSet = newClassSet;
        }
        if (toolClassSet.isEmpty()) {
            if (item instanceof ItemHoe) {
                return "hoe";
            }
            if (item instanceof ItemShears) {
                return "shears";
            }
            if (item instanceof ItemFishingRod) {
                return "fishingrod";
            }
            return "";
        }
        if (toolClassSet.size() == 1) {
            return (String)toolClassSet.toArray()[0];
        }
        String[] prefOrder = new String[]{"pickaxe", "axe", "shovel", "hoe", "shears", "wrench"};
        for (int i = 0; i < prefOrder.length; ++i) {
            if (!toolClassSet.contains(prefOrder[i])) continue;
            return prefOrder[i];
        }
        return (String)toolClassSet.toArray()[0];
    }

    private int compareTools(ItemStack i, ItemStack j, Item iItem, Item jItem) {
        boolean isTool2;
        String toolClass1 = InvTweaks.getToolClass(i, iItem);
        String toolClass2 = InvTweaks.getToolClass(j, jItem);
        if (this.debugTree) {
            this.mostRecentComparison = this.mostRecentComparison + ", ToolClass (" + toolClass1 + ", " + toolClass2 + ")";
        }
        boolean isTool1 = toolClass1 != "";
        boolean bl = isTool2 = toolClass2 != "";
        if (!isTool1 || !isTool2) {
            return Boolean.compare(isTool2, isTool1);
        }
        int toolClassComparison = toolClass1.compareTo(toolClass2);
        if (toolClassComparison != 0) {
            return toolClassComparison;
        }
        int harvestLevel1 = iItem.getHarvestLevel(i, toolClass1, null, null);
        int harvestLevel2 = jItem.getHarvestLevel(j, toolClass2, null, null);
        int toolLevelComparison = harvestLevel2 - harvestLevel1;
        if (this.debugTree) {
            this.mostRecentComparison = this.mostRecentComparison + ", HarvestLevel (" + harvestLevel1 + ", " + harvestLevel2 + ")";
        }
        if (toolLevelComparison != 0) {
            return Integer.compare(harvestLevel2, harvestLevel1);
        }
        return InvTweaks.compareMaxDamage(i, j);
    }

    private int compareSword(ItemStack itemStack1, ItemStack itemStack2, Item iItem, Item jItem) {
        boolean hasSpeed2;
        Multimap multimap1 = itemStack1 != null ? itemStack1.func_111283_C(EntityEquipmentSlot.MAINHAND) : null;
        Multimap multimap2 = itemStack2 != null ? itemStack2.func_111283_C(EntityEquipmentSlot.MAINHAND) : null;
        String attackDamageName = SharedMonsterAttributes.field_111264_e.func_111108_a();
        String attackSpeedName = SharedMonsterAttributes.field_188790_f.func_111108_a();
        boolean hasDamage1 = itemStack1 != null ? multimap1.containsKey((Object)attackDamageName) : false;
        boolean hasDamage2 = itemStack2 != null ? multimap2.containsKey((Object)attackDamageName) : false;
        boolean hasSpeed1 = itemStack1 != null ? multimap1.containsKey((Object)attackSpeedName) : false;
        boolean bl = hasSpeed2 = itemStack2 != null ? multimap2.containsKey((Object)attackSpeedName) : false;
        if (this.debugTree) {
            this.mostRecentComparison = this.mostRecentComparison + ", HasDamage (" + hasDamage1 + ", " + hasDamage2 + ")";
        }
        if (!hasDamage1 || !hasDamage2) {
            return Boolean.compare(hasDamage2, hasDamage1);
        }
        Collection damageMap1 = multimap1.get((Object)attackDamageName);
        Collection damageMap2 = multimap2.get((Object)attackDamageName);
        Double attackDamage1 = ((AttributeModifier)damageMap1.toArray()[0]).func_111164_d();
        Double attackDamage2 = ((AttributeModifier)damageMap2.toArray()[0]).func_111164_d();
        int damageComparison = Double.compare(attackDamage2, attackDamage1);
        if (damageComparison == 0 && hasSpeed1 && hasSpeed2) {
            Collection speedMap1 = multimap1.get((Object)attackSpeedName);
            Collection speedMap2 = multimap2.get((Object)attackSpeedName);
            Double speed1 = ((AttributeModifier)speedMap1.toArray()[0]).func_111164_d();
            Double speed2 = ((AttributeModifier)speedMap2.toArray()[0]).func_111164_d();
            int speedComparison = Double.compare(speed2, speed1);
            if (speedComparison != 0) {
                return speedComparison;
            }
        } else if (damageComparison != 0) {
            return damageComparison;
        }
        return InvTweaks.compareMaxDamage(itemStack1, itemStack2);
    }

    private int compareArmor(ItemStack i, ItemStack j, Item iItem, Item jItem) {
        int isArmor2;
        int isArmor1 = iItem instanceof ItemArmor ? 1 : 0;
        int n = isArmor2 = jItem instanceof ItemArmor ? 1 : 0;
        if (isArmor1 == 0 || isArmor2 == 0) {
            return isArmor2 - isArmor1;
        }
        ItemArmor a1 = (ItemArmor)iItem;
        ItemArmor a2 = (ItemArmor)jItem;
        if (a1.field_77881_a != a2.field_77881_a) {
            return a2.field_77881_a.compareTo((Enum)a1.field_77881_a);
        }
        if (a1.field_77879_b != a2.field_77879_b) {
            return a2.field_77879_b - a1.field_77879_b;
        }
        if (a1.field_189415_e != a2.field_189415_e) {
            return a2.field_189415_e > a1.field_189415_e ? -1 : 1;
        }
        return InvTweaks.compareMaxDamage(i, j);
    }

    private int compareEnchantment(ItemStack i, ItemStack j) {
        int enchId;
        Map iEnchs = EnchantmentHelper.func_82781_a((ItemStack)i);
        Map jEnchs = EnchantmentHelper.func_82781_a((ItemStack)j);
        if (iEnchs.size() != jEnchs.size()) {
            if (this.debugTree) {
                this.mostRecentComparison = this.mostRecentComparison + ", Enchantment Count";
            }
            return jEnchs.size() - iEnchs.size();
        }
        int iEnchMaxId = 0;
        int iEnchMaxLvl = 0;
        int jEnchMaxId = 0;
        int jEnchMaxLvl = 0;
        for (Map.Entry ench : iEnchs.entrySet()) {
            enchId = Enchantment.func_185258_b((Enchantment)((Enchantment)ench.getKey()));
            if ((Integer)ench.getValue() > iEnchMaxLvl) {
                iEnchMaxId = enchId;
                iEnchMaxLvl = (Integer)ench.getValue();
                continue;
            }
            if ((Integer)ench.getValue() != iEnchMaxLvl || enchId <= iEnchMaxId) continue;
            iEnchMaxId = enchId;
        }
        for (Map.Entry ench : jEnchs.entrySet()) {
            enchId = Enchantment.func_185258_b((Enchantment)((Enchantment)ench.getKey()));
            if ((Integer)ench.getValue() > jEnchMaxLvl) {
                jEnchMaxId = enchId;
                jEnchMaxLvl = (Integer)ench.getValue();
                continue;
            }
            if ((Integer)ench.getValue() != jEnchMaxLvl || enchId <= jEnchMaxId) continue;
            jEnchMaxId = enchId;
        }
        if (iEnchMaxId != jEnchMaxId) {
            if (this.debugTree) {
                this.mostRecentComparison = this.mostRecentComparison + ", Highest Enchantment";
            }
            return jEnchMaxId - iEnchMaxId;
        }
        if (iEnchMaxLvl != jEnchMaxLvl) {
            if (this.debugTree) {
                this.mostRecentComparison = this.mostRecentComparison + ", Highest Enchantment Level";
            }
            return jEnchMaxLvl - iEnchMaxLvl;
        }
        if (this.debugTree) {
            this.mostRecentComparison = this.mostRecentComparison + ", Enchantment Level same";
        }
        return 0;
    }

    public void setItemPickupPending(boolean value) {
        this.itemPickupPending = value;
        this.itemPickupTimeout = 5;
    }

    public void setSortKeyEnabled(boolean enabled) {
        this.sortKeyEnabled = enabled;
    }

    public void setTextboxMode(boolean enabled) {
        this.textboxMode = enabled;
    }

    public void logInGame(@NotNull String message) {
        this.logInGame(message, false);
    }

    public void printQueuedMessages() {
        if (this.mc.field_71456_v != null && !this.queuedMessages.isEmpty()) {
            this.queuedMessages.forEach(this::addChatMessage);
            this.queuedMessages.clear();
        }
    }

    public void logInGame(@NotNull String message, boolean alreadyTranslated) {
        String formattedMsg = InvTweaks.buildLogString(Level.INFO, alreadyTranslated ? message : I18n.func_135052_a((String)message, (Object[])new Object[0]));
        if (this.mc.field_71456_v == null) {
            this.queuedMessages.add(formattedMsg);
        } else {
            this.addChatMessage(formattedMsg);
        }
        log.info(formattedMsg);
    }

    public void logInGameError(@NotNull String message, @NotNull Exception e) {
        String formattedMsg = InvTweaks.buildLogString(Level.SEVERE, I18n.func_135052_a((String)message, (Object[])new Object[0]), e);
        log.error(formattedMsg, (Throwable)e);
        if (this.mc.field_71456_v == null) {
            this.queuedMessages.add(formattedMsg);
        } else {
            this.addChatMessage(formattedMsg);
        }
    }

    private boolean onTick() {
        GuiScreen currentScreen;
        this.printQueuedMessages();
        ++this.tickNumber;
        if (this.mc.field_71442_b.func_78747_a()) {
            return false;
        }
        InvTweaksConfig config = this.cfgManager.getConfig();
        if (config == null) {
            return false;
        }
        if (this.itemPickupPending) {
            this.onItemPickup();
        }
        if ((currentScreen = this.getCurrentScreen()) == null || InvTweaks.isGuiInventory(currentScreen)) {
            this.cloneHotbar();
        }
        if (this.isSortingShortcutDown()) {
            if (!this.sortKeyDown) {
                this.sortKeyDown = true;
                this.onSortingKeyPressed();
            }
        } else {
            this.sortKeyDown = false;
        }
        this.handleConfigSwitch();
        return true;
    }

    private void handleConfigSwitch() {
        InvTweaksConfig config = this.cfgManager.getConfig();
        GuiScreen currentScreen = this.getCurrentScreen();
        this.cfgManager.getShortcutsHandler().updatePressedKeys();
        InvTweaksShortcutMapping switchMapping = this.cfgManager.getShortcutsHandler().isShortcutDown(InvTweaksShortcutType.MOVE_TO_SPECIFIC_HOTBAR_SLOT);
        if (this.isSortingShortcutDown() && switchMapping != null) {
            String newRuleset = null;
            int pressedKey = switchMapping.getKeyCodes().get(0);
            if (pressedKey >= 2 && pressedKey <= 10) {
                newRuleset = config.switchConfig(pressedKey - 2);
            } else {
                switch (pressedKey) {
                    case 79: {
                        newRuleset = config.switchConfig(0);
                        break;
                    }
                    case 80: {
                        newRuleset = config.switchConfig(1);
                        break;
                    }
                    case 81: {
                        newRuleset = config.switchConfig(2);
                        break;
                    }
                    case 75: {
                        newRuleset = config.switchConfig(3);
                        break;
                    }
                    case 76: {
                        newRuleset = config.switchConfig(4);
                        break;
                    }
                    case 77: {
                        newRuleset = config.switchConfig(5);
                        break;
                    }
                    case 71: {
                        newRuleset = config.switchConfig(6);
                        break;
                    }
                    case 72: {
                        newRuleset = config.switchConfig(7);
                        break;
                    }
                    case 73: {
                        newRuleset = config.switchConfig(8);
                    }
                }
            }
            if (newRuleset != null) {
                this.logInGame(String.format(I18n.func_135052_a((String)"invtweaks.loadconfig.enabled", (Object[])new Object[0]), newRuleset), true);
                this.sortingKeyPressedDate = Integer.MAX_VALUE;
            }
        }
        if (this.isSortingShortcutDown()) {
            long currentTime = System.currentTimeMillis();
            if (this.sortingKeyPressedDate == 0L) {
                this.sortingKeyPressedDate = currentTime;
            } else if (currentTime - this.sortingKeyPressedDate > 1000L && this.sortingKeyPressedDate != Integer.MAX_VALUE) {
                String previousRuleset = config.getCurrentRulesetName();
                String newRuleset = config.switchConfig();
                if (previousRuleset != null && newRuleset != null && !previousRuleset.equals(newRuleset)) {
                    this.logInGame(String.format(I18n.func_135052_a((String)"invtweaks.loadconfig.enabled", (Object[])new Object[0]), newRuleset), true);
                    this.handleSorting(currentScreen);
                }
                this.sortingKeyPressedDate = currentTime;
            }
        } else {
            this.sortingKeyPressedDate = 0L;
        }
    }

    private String ListOfClassNameKind(Object o) {
        String resString = "";
        Class<?> testClass = o.getClass();
        while (testClass != null) {
            resString = resString + testClass.getName().toLowerCase();
            if ((testClass = testClass.getSuperclass()) == null) continue;
            resString = resString + ", ";
        }
        return resString;
    }

    private void handleSorting(GuiScreen guiScreen) {
        NonNullList<ItemStack> mainInventory;
        ItemStack selectedItem = ItemStack.field_190927_a;
        int focusedSlot = this.getFocusedSlot();
        if (focusedSlot < (mainInventory = this.getMainInventory()).size() && focusedSlot >= 0) {
            selectedItem = (ItemStack)mainInventory.get(focusedSlot);
        }
        if (this.debugTree && selectedItem != null && !selectedItem.func_190926_b()) {
            this.logInGame("Hand Item Details:", true);
            this.logInGame(selectedItem.toString(), true);
            this.logInGame("Classes: " + this.ListOfClassNameKind(selectedItem.func_77973_b()));
            this.logInGame("Item Order Index: " + this.getItemOrder(selectedItem), true);
            ItemStack offhandStack = this.getOffhandStack();
            if (offhandStack != null && !offhandStack.func_190926_b()) {
                this.logInGame("Off-Hand Item Details:", true);
                this.logInGame(offhandStack.toString(), true);
                this.logInGame("Item Order Index: " + this.getItemOrder(offhandStack), true);
                this.logInGame("Comparator result: " + this.compareItems(selectedItem, offhandStack), true);
                this.logInGame("Comparator debug: " + this.mostRecentComparison, true);
            }
        }
        try {
            new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), ContainerSection.INVENTORY, SortingMethod.INVENTORY, 9).sort();
        }
        catch (Exception e) {
            this.logInGameError("invtweaks.sort.inventory.error", e);
            e.printStackTrace();
        }
        this.playClick();
    }

    private void handleAutoRefill() {
        ItemStack currentStack = this.getFocusedStack();
        ItemStack offhandStack = this.getOffhandStack();
        String currentStackId = currentStack.func_190926_b() ? null : currentStack.func_77973_b().getRegistryName().toString();
        int currentStackDamage = currentStack.func_190926_b() ? 0 : currentStack.func_77952_i();
        int focusedSlot = this.getFocusedSlot() + 27;
        InvTweaksConfig config = this.cfgManager.getConfig();
        if (this.storedFocusedSlot != focusedSlot) {
            this.storedFocusedSlot = focusedSlot;
        } else if (!(ItemStack.func_179545_c((ItemStack)currentStack, (ItemStack)this.storedStack) || this.storedStackId == null || this.storedStack.func_190926_b() || ItemStack.func_77989_b((ItemStack)offhandStack, (ItemStack)this.storedStack))) {
            if (currentStack.func_190926_b() || currentStack.func_77973_b() == Items.field_151054_z && Objects.equals(this.storedStackId, "minecraft:mushroom_stew") && (this.getCurrentScreen() == null || InvTweaks.isGuiEditSign(this.getCurrentScreen()))) {
                if (config.isAutoRefillEnabled(this.storedStackId, this.storedStackDamage)) {
                    try {
                        this.cfgManager.getAutoRefillHandler().autoRefillSlot(focusedSlot, this.storedStackId, this.storedStackDamage);
                    }
                    catch (Exception e) {
                        this.logInGameError("invtweaks.sort.autorefill.error", e);
                    }
                }
            } else {
                int autoRefillThreshhold;
                int itemMaxDamage = currentStack.func_77958_k();
                if (this.canToolBeReplaced(currentStackDamage, itemMaxDamage, autoRefillThreshhold = config.getIntProperty("autoRefillDamageThreshhold")) && config.getProperty("autoRefillBeforeBreak").equals("true") && config.isAutoRefillEnabled(this.storedStackId, this.storedStackDamage)) {
                    try {
                        this.cfgManager.getAutoRefillHandler().autoRefillSlot(focusedSlot, this.storedStackId, this.storedStackDamage);
                    }
                    catch (Exception e) {
                        this.logInGameError("invtweaks.sort.autorefill.error", e);
                    }
                }
            }
        }
        this.storedStack = currentStack.func_77946_l();
        this.storedStackId = currentStackId;
        this.storedStackDamage = currentStackDamage;
    }

    private boolean canToolBeReplaced(int currentStackDamage, int itemMaxDamage, int autoRefillThreshhold) {
        return itemMaxDamage != 0 && itemMaxDamage - currentStackDamage < autoRefillThreshhold && itemMaxDamage - this.storedStackDamage >= autoRefillThreshhold;
    }

    private void handleMiddleClick(GuiScreen guiScreen) {
        if (Mouse.isButtonDown((int)2)) {
            if (!this.cfgManager.makeSureConfigurationIsLoaded()) {
                return;
            }
            InvTweaksConfig config = this.cfgManager.getConfig();
            if (config.getProperty("enableMiddleClick").equals("true") && InvTweaks.isGuiContainer(guiScreen)) {
                GuiContainer guiContainer = (GuiContainer)guiScreen;
                Container container = guiContainer.field_147002_h;
                if (!this.chestAlgorithmButtonDown) {
                    this.chestAlgorithmButtonDown = true;
                    IContainerManager containerMgr = InvTweaks.getContainerManager(container);
                    Slot slotAtMousePosition = InvTweaksObfuscation.getSlotAtMousePosition((GuiContainer)this.getCurrentScreen());
                    ContainerSection target = null;
                    if (slotAtMousePosition != null) {
                        target = containerMgr.getSlotSection(InvTweaks.getSlotNumber(slotAtMousePosition));
                    }
                    if (InvTweaks.isValidChest(container)) {
                        if (ContainerSection.CHEST.equals((Object)target)) {
                            this.playClick();
                            long timestamp = System.currentTimeMillis();
                            if (timestamp - this.chestAlgorithmClickTimestamp > 2000L || InvTweaks.getContainerRowSize(guiContainer) > 9) {
                                this.chestAlgorithm = SortingMethod.DEFAULT;
                            }
                            try {
                                new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), ContainerSection.CHEST, this.chestAlgorithm, InvTweaks.getContainerRowSize(guiContainer)).sort();
                            }
                            catch (Exception e) {
                                this.logInGameError("invtweaks.sort.chest.error", e);
                                e.printStackTrace();
                            }
                            this.chestAlgorithm = SortingMethod.values()[(this.chestAlgorithm.ordinal() + 1) % 3];
                            this.chestAlgorithmClickTimestamp = timestamp;
                        } else if (ContainerSection.CRAFTING_IN.equals((Object)target) || ContainerSection.CRAFTING_IN_PERSISTENT.equals((Object)target)) {
                            try {
                                new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), target, SortingMethod.EVEN_STACKS, containerMgr.getSize(target) == 9 ? 3 : 2).sort();
                            }
                            catch (Exception e) {
                                this.logInGameError("invtweaks.sort.crafting.error", e);
                                e.printStackTrace();
                            }
                        } else if (ContainerSection.INVENTORY_HOTBAR.equals((Object)target) || ContainerSection.INVENTORY_NOT_HOTBAR.equals((Object)target)) {
                            this.handleSorting(guiScreen);
                        }
                    } else if (InvTweaks.isValidInventory(container)) {
                        if (ContainerSection.CRAFTING_IN.equals((Object)target) || ContainerSection.CRAFTING_IN_PERSISTENT.equals((Object)target)) {
                            try {
                                new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), target, SortingMethod.EVEN_STACKS, containerMgr.getSize(target) == 9 ? 3 : 2).sort();
                            }
                            catch (Exception e) {
                                this.logInGameError("invtweaks.sort.crafting.error", e);
                                e.printStackTrace();
                            }
                        } else {
                            this.handleSorting(guiScreen);
                        }
                    }
                }
            }
        } else {
            this.chestAlgorithmButtonDown = false;
        }
    }

    private boolean hasRecipeButton(@NotNull GuiContainer guiContainer) {
        if (guiContainer instanceof GuiInventory) {
            return true;
        }
        return guiContainer instanceof GuiCrafting;
    }

    private boolean isRecipeBookVisible(@NotNull GuiContainer guiContainer) {
        if (guiContainer instanceof GuiInventory) {
            return ((GuiInventory)guiContainer).field_192045_A.func_191878_b();
        }
        if (guiContainer instanceof GuiCrafting) {
            return ((GuiCrafting)guiContainer).field_192050_x.func_191878_b();
        }
        return false;
    }

    private void handleGUILayout(@NotNull GuiContainer guiContainer) {
        InvTweaksConfig config = this.cfgManager.getConfig();
        Container container = guiContainer.field_147002_h;
        boolean isValidChest = InvTweaks.isValidChest(container);
        if (InvTweaks.showButtons(container)) {
            int w = 10;
            int h = 10;
            boolean isItemListVisible = this.itemListChecker.isVisible();
            boolean wasItemListVisible = this.itemListChecker.wasVisible();
            boolean isRecipeBookVisible = this.isRecipeBookVisible(guiContainer);
            boolean wasRecipeBookVisible = this.previousRecipeBookVisibility;
            boolean relayout = isItemListVisible != wasItemListVisible || isRecipeBookVisible != wasRecipeBookVisible;
            this.previousRecipeBookVisibility = isRecipeBookVisible;
            boolean customButtonsAdded = false;
            List controlList = guiContainer.field_146292_n;
            ArrayList<GuiButton> toRemove = new ArrayList<GuiButton>();
            for (GuiButton button : controlList) {
                if (button.field_146127_k < 54696386 || button.field_146127_k >= 54696390) continue;
                if (relayout) {
                    toRemove.add(button);
                    continue;
                }
                customButtonsAdded = true;
                break;
            }
            controlList.removeAll(toRemove);
            guiContainer.field_146292_n = controlList;
            if (!customButtonsAdded) {
                boolean customTextureAvailable = this.hasTexture(new ResourceLocation("inventorytweaks", "textures/gui/button10px.png"));
                int id = 54696386;
                int x = guiContainer.field_147003_i + guiContainer.field_146999_f - 16;
                int y = guiContainer.field_147009_r + 5;
                if (!isValidChest) {
                    controlList.add(new InvTweaksGuiSettingsButton(this.cfgManager, id, x, y, w, h, "...", I18n.func_135052_a((String)"invtweaks.button.settings.tooltip", (Object[])new Object[0]), customTextureAvailable));
                } else {
                    this.chestAlgorithmClickTimestamp = 0L;
                    boolean isChestWayTooBig = InvTweaks.isLargeChest(guiContainer.field_147002_h);
                    if (isChestWayTooBig && isItemListVisible) {
                        x -= 20;
                        y += 50;
                    }
                    controlList.add(new InvTweaksGuiSettingsButton(this.cfgManager, id++, isChestWayTooBig ? x + 22 : x - 1, isChestWayTooBig ? y - 3 : y, w, h, "...", I18n.func_135052_a((String)"invtweaks.button.settings.tooltip", (Object[])new Object[0]), customTextureAvailable));
                    if (!config.getProperty("showChestButtons").equals("false")) {
                        int rowSize = InvTweaks.getContainerRowSize(guiContainer);
                        InvTweaksGuiSortingButton button = new InvTweaksGuiSortingButton(this.cfgManager, id++, isChestWayTooBig ? x + 22 : x - 37, isChestWayTooBig ? y + 38 : y, w, h, "s", I18n.func_135052_a((String)"invtweaks.button.chest1.tooltip", (Object[])new Object[0]), SortingMethod.DEFAULT, rowSize, customTextureAvailable);
                        controlList.add(button);
                        if (rowSize <= 9) {
                            button = new InvTweaksGuiSortingButton(this.cfgManager, id++, isChestWayTooBig ? x + 22 : x - 13, isChestWayTooBig ? y + 12 : y, w, h, "h", I18n.func_135052_a((String)"invtweaks.button.chest3.tooltip", (Object[])new Object[0]), SortingMethod.HORIZONTAL, rowSize, customTextureAvailable);
                            controlList.add(button);
                            button = new InvTweaksGuiSortingButton(this.cfgManager, id++, isChestWayTooBig ? x + 22 : x - 25, isChestWayTooBig ? y + 25 : y, w, h, "v", I18n.func_135052_a((String)"invtweaks.button.chest2.tooltip", (Object[])new Object[0]), SortingMethod.VERTICAL, rowSize, customTextureAvailable);
                            controlList.add(button);
                        }
                    }
                }
            }
        } else if (InvTweaks.isGuiInventoryCreative(guiContainer)) {
            List controlList = guiContainer.field_146292_n;
            GuiButton buttonToRemove = null;
            for (GuiButton o : controlList) {
                if (o.field_146127_k != 54696386) continue;
                buttonToRemove = o;
                break;
            }
            if (buttonToRemove != null) {
                controlList.remove(buttonToRemove);
            }
        }
    }

    private void handleShortcuts(@NotNull GuiContainer guiScreen) {
        if (!InvTweaks.isValidChest(guiScreen.field_147002_h) && !InvTweaks.isValidInventory(guiScreen.field_147002_h)) {
            return;
        }
        if (Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)1)) {
            if (!this.mouseWasDown) {
                this.mouseWasDown = true;
                if (this.cfgManager.getConfig().getProperty("enableShortcuts").equals("true")) {
                    this.cfgManager.getShortcutsHandler().handleShortcut();
                }
            }
        } else {
            this.mouseWasDown = false;
        }
    }

    private int getItemOrder(@NotNull ItemStack itemStack) {
        List<IItemTreeItem> items = this.cfgManager.getConfig().getTree().getItems(itemStack.func_77973_b().getRegistryName().toString(), itemStack.func_77952_i(), itemStack.func_77978_p());
        return items.size() > 0 ? items.get(0).getOrder() : Integer.MAX_VALUE;
    }

    private boolean isSortingShortcutDown() {
        if (this.sortKeyEnabled && !this.textboxMode) {
            int keyCode = this.cfgManager.getConfig().getSortKeyCode();
            if (keyCode > 0) {
                return Keyboard.isKeyDown((int)keyCode);
            }
            return Mouse.isButtonDown((int)(100 + keyCode));
        }
        return false;
    }

    private boolean isTimeForPolling() {
        if (this.tickNumber - this.lastPollingTickNumber >= 3) {
            this.lastPollingTickNumber = this.tickNumber;
        }
        return this.tickNumber - this.lastPollingTickNumber == 0;
    }

    private void unlockKeysIfNecessary() {
        boolean hasFocus = Display.isActive();
        if (!this.hadFocus && hasFocus) {
            Keyboard.destroy();
            boolean firstTry = true;
            while (!Keyboard.isCreated()) {
                try {
                    Keyboard.create();
                }
                catch (LWJGLException e) {
                    if (!firstTry) continue;
                    this.logInGameError("invtweaks.keyboardfix.error", (Exception)((Object)e));
                    firstTry = false;
                }
            }
            if (!firstTry) {
                this.logInGame("invtweaks.keyboardfix.recover");
            }
        }
        this.hadFocus = hasFocus;
    }

    private void cloneHotbar() {
        NonNullList<ItemStack> mainInventory = this.getMainInventory();
        for (int i = 0; i < 9; ++i) {
            this.hotbarClone[i] = ((ItemStack)mainInventory.get(i)).func_77946_l();
        }
    }

    private void playClick() {
        if (!this.cfgManager.getConfig().getProperty("enableSounds").equals("false")) {
            this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }
}

