/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.ping.proxy;

import dmillerw.ping.client.KeyHandler;
import dmillerw.ping.data.PingType;
import dmillerw.ping.data.PingWrapper;
import dmillerw.ping.network.PacketHandler;
import dmillerw.ping.network.packet.ClientSendPing;
import dmillerw.ping.proxy.CommonProxy;
import dmillerw.ping.util.RaytraceHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ClientProxy
extends CommonProxy {
    public static int pingR;
    public static int pingG;
    public static int pingB;
    public static boolean blockOverlay;
    public static boolean menuBackground;
    public static boolean sound;
    public static double pingAcceptDistance;
    public static int pingDuration;
    public static Configuration configuration;

    public static void sendPing(PingType type) {
        RayTraceResult mob = RaytraceHelper.raytrace((EntityPlayer)Minecraft.func_71410_x().field_71439_g, 50.0);
        if (mob != null && mob.field_72313_a == RayTraceResult.Type.BLOCK) {
            ClientProxy.sendPing(mob, new Color(pingR, pingG, pingB).getRGB(), type);
        }
    }

    private static void sendPing(RayTraceResult mob, int color, PingType type) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new ClientSendPing(new PingWrapper(mob.func_178782_a(), color, type)));
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.KEY_BINDING);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.PING_ALERT);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.PING_MINE);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.PING_LOOK);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.PING_GOTO);
        configuration = new Configuration(event.getSuggestedConfigurationFile());
        configuration.load();
    }

    @Override
    public void syncConfig() {
        Property p_pingR = configuration.get("visual", "red", 255, "Value from 0 - 255");
        Property p_pingG = configuration.get("visual", "green", 0, "Value from 0 - 255");
        Property p_pingB = configuration.get("visual", "blue", 0, "Value from 0 - 255");
        pingR = this.verify(p_pingR);
        pingG = this.verify(p_pingG);
        pingB = this.verify(p_pingB);
        blockOverlay = configuration.get("visual", "blockOverlay", true, "Whether to render a colored overlay on the Pinged block").getBoolean();
        menuBackground = configuration.get("visual", "backgroundMenu", true, "Whether to render the Ping Menu background").getBoolean();
        sound = configuration.get("general", "sound", true, "Whether to play a sound when a Ping is received").getBoolean();
        pingAcceptDistance = configuration.get("general", "pingAcceptDistance", 64.0, "Maximum distance a Ping can be from you and still be received").getDouble();
        pingDuration = configuration.get("general", "pingDuration", 125, "How long a Ping should remain active before disappearing").getInt();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    private int verify(Property property) {
        int value = property.getInt();
        if (value < 0) {
            value = 0;
        } else if (value > 255) {
            value = 255;
        }
        return value;
    }
}

