/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.world;

import com.google.common.base.Predicate;
import com.kashdeya.tinyprogressions.handlers.ConfigHandler;
import com.kashdeya.tinyprogressions.inits.TechBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OldWorldGen
implements IWorldGenerator {
    private WorldGenerator ender_ore;
    private WorldGenerator lava_block;
    private WorldGenerator water_block;
    private WorldGenerator charcoal_block;
    private WorldGenerator wub_ore;

    public OldWorldGen() {
        if (ConfigHandler.ender_ore) {
            this.ender_ore = new WorldGenMinable(TechBlocks.ender_ore.func_176223_P(), ConfigHandler.ender_ore_size, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        }
        if (ConfigHandler.lava_block) {
            this.lava_block = new WorldGenMinable(TechBlocks.lava_block.func_176223_P(), ConfigHandler.lava_block_size, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        }
        if (ConfigHandler.water_block) {
            this.water_block = new WorldGenMinable(TechBlocks.water_block.func_176223_P(), ConfigHandler.water_block_size, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        }
        if (ConfigHandler.CharcoalWorldgen && ConfigHandler.CharcoalBlock) {
            this.charcoal_block = new WorldGenMinable(TechBlocks.charcoal_block.func_176223_P(), ConfigHandler.charcoal_size, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_189877_df));
        }
        if (ConfigHandler.vasholine) {
            this.wub_ore = new WorldGenMinable(TechBlocks.wub_ore.func_176223_P(), ConfigHandler.wub_block_count, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z + rand.nextInt(16);
            BlockPos pos = new BlockPos(x, y, z);
            generator.func_180709_b(world, rand, pos);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                if (ConfigHandler.ender_ore) {
                    this.runGenerator(this.ender_ore, world, random, chunkX * 16, chunkZ * 16, ConfigHandler.ender_ore_frequency, ConfigHandler.ender_ore_min, ConfigHandler.ender_ore_max);
                }
                if (ConfigHandler.lava_block) {
                    this.runGenerator(this.lava_block, world, random, chunkX * 16, chunkZ * 16, ConfigHandler.lava_block_frequency, ConfigHandler.lava_block_min, ConfigHandler.lava_block_max);
                }
                if (ConfigHandler.water_block) {
                    this.runGenerator(this.water_block, world, random, chunkX * 16, chunkZ * 16, ConfigHandler.water_block_frequency, ConfigHandler.water_block_min, ConfigHandler.water_block_max);
                }
                if (!ConfigHandler.vasholine) break;
                this.runGenerator(this.wub_ore, world, random, chunkX * 16, chunkZ * 16, 5, 1, 12);
                break;
            }
            case 1: {
                break;
            }
            case -1: {
                if (!ConfigHandler.CharcoalWorldgen || !ConfigHandler.CharcoalBlock) break;
                this.runGenerator(this.charcoal_block, world, random, chunkX * 16, chunkZ * 16, ConfigHandler.charcoal_frequency, ConfigHandler.charcoal_min, ConfigHandler.charcoal_max);
            }
        }
    }
}

