/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import jline.internal.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class StorageUtil {
    public static byte[] storeData(@Nullable ItemStack itemstack) {
        if (itemstack == null || itemstack.func_190926_b()) {
            return new byte[0];
        }
        NBTTagCompound nbt = itemstack.func_77955_b(new NBTTagCompound());
        String id = nbt.func_74779_i("id");
        if (id.equals("minecraft:air")) {
            return new byte[0];
        }
        byte count = nbt.func_74771_c("Count");
        if (count == 0) {
            return new byte[0];
        }
        short damage = nbt.func_74765_d("Damage");
        boolean vanilla = id.startsWith("minecraft:") && id.indexOf(58, "minecraft:".length()) < 0;
        NBTTagCompound tag = nbt.func_74764_b("tag") ? nbt.func_74775_l("tag") : null;
        NBTTagCompound forgeCaps = nbt.func_74764_b("ForgeCaps") ? nbt.func_74775_l("ForgeCaps") : null;
        byte type = 0;
        if (damage != 0) {
            type = (byte)(type | 1);
        }
        if (tag != null) {
            type = (byte)(type | 2);
        }
        if (forgeCaps != null) {
            type = (byte)(type | 4);
        }
        if (count == 1) {
            type = (byte)(type | 8);
        }
        if (count == 64) {
            type = (byte)(type | 0x10);
        }
        ByteBuf data = Unpooled.buffer();
        PacketBuffer buffer = new PacketBuffer(data);
        data.writeByte((int)type);
        PacketBuffer packetBuffer = buffer = vanilla ? StorageUtil.writeSmallString(buffer, id.substring("minecraft:".length())) : StorageUtil.writeSmallString(buffer, id);
        if (count != 1 && count != 64) {
            buffer.writeByte((int)count);
        }
        if (damage != 0) {
            buffer.writeShort((int)damage);
        }
        if (tag != null) {
            try {
                buffer = StorageUtil.writeNBT(buffer, tag);
            }
            catch (IOException e) {
                return new byte[0];
            }
        }
        if (forgeCaps != null) {
            try {
                buffer = StorageUtil.writeNBT(buffer, forgeCaps);
            }
            catch (IOException e) {
                return new byte[0];
            }
        }
        int readableBytes = data.readableBytes();
        byte[] b = new byte[readableBytes];
        data.readBytes(b);
        return b;
    }

    public static ItemStack loadData(@Nonnull byte[] bytes) {
        NBTTagCompound forgeCaps;
        NBTTagCompound tags;
        if (bytes.length == 0) {
            return ItemStack.field_190927_a;
        }
        ByteBuf data = Unpooled.wrappedBuffer((byte[])bytes);
        PacketBuffer buffer = new PacketBuffer(data);
        byte type = buffer.readByte();
        String id = StorageUtil.readSmallString(buffer);
        if (id.indexOf(58) < 0) {
            id = "minecraft:" + id;
        }
        byte count = (type & 8) != 0 ? (byte)1 : ((type & 0x10) != 0 ? (byte)64 : (byte)buffer.readByte());
        short damage = (type & 1) != 0 ? buffer.readShort() : (short)0;
        if ((type & 2) != 0) {
            try {
                tags = StorageUtil.readNBTChecked(buffer);
            }
            catch (IOException e) {
                return ItemStack.field_190927_a;
            }
        } else {
            tags = null;
        }
        if ((type & 4) != 0) {
            try {
                forgeCaps = StorageUtil.readNBTChecked(buffer);
            }
            catch (IOException e) {
                return ItemStack.field_190927_a;
            }
        } else {
            forgeCaps = null;
        }
        if (buffer.readableBytes() > 0) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound finalTag = new NBTTagCompound();
        finalTag.func_74778_a("id", id);
        finalTag.func_74774_a("Count", count);
        finalTag.func_74777_a("Damage", damage);
        if (tags != null) {
            finalTag.func_74782_a("tag", (NBTBase)tags);
        }
        if (forgeCaps != null) {
            finalTag.func_74782_a("ForgeCaps", (NBTBase)forgeCaps);
        }
        return new ItemStack(finalTag);
    }

    private static PacketBuffer writeSmallString(PacketBuffer buffer, String string) {
        if (string == null) {
            buffer.writeByte(0);
        } else {
            byte[] stringData = string.getBytes(Charset.forName("UTF-8"));
            buffer.writeByte(stringData.length);
            buffer.writeBytes(stringData);
        }
        return buffer;
    }

    private static String readSmallString(PacketBuffer buffer) {
        short length = buffer.readUnsignedByte();
        if (length <= 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        return new String(bytes, Charset.forName("UTF-8"));
    }

    private static PacketBuffer writeNBT(PacketBuffer buffer, NBTTagCompound nbt) throws IOException {
        if (nbt == null) {
            buffer.writeShort(0);
            return buffer;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)output);
        byte[] compressed = output.toByteArray();
        buffer.writeShort(compressed.length);
        buffer.writeBytes(compressed);
        return buffer;
    }

    private static NBTTagCompound readNBTChecked(PacketBuffer buffer) throws IOException {
        int length = buffer.readUnsignedShort();
        if (length <= 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        return CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(bytes));
    }
}

