/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.blocks.growthblock;

import com.kashdeya.tinyprogressions.blocks.growthblock.BlockGrowth;
import com.kashdeya.tinyprogressions.handlers.ConfigHandler;
import com.kashdeya.tinyprogressions.inits.TechBlocks;
import com.kashdeya.tinyprogressions.main.TinyProgressions;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrowthUpgrade
extends Block {
    private int range = 4;
    private int rangeY = 5;
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)15);

    public BlockGrowthUpgrade() {
        super(Material.field_151586_h);
        this.func_149675_a(true);
        this.func_149711_c(1.25f);
        this.func_149715_a(0.5f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149752_b(2000.0f);
        this.func_149647_a(TinyProgressions.tabTP);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c("growth_upgrade");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(7)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEVEL});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random par5Random) {
        this.growCropsNearby(world, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)TechBlocks.growth_upgrade);
    }

    public void growCropsNearby(World world, BlockPos pos, IBlockState state) {
        int xO = pos.func_177958_n();
        int yO = pos.func_177956_o();
        int zO = pos.func_177952_p();
        for (int xD = -4; xD <= 4; ++xD) {
            for (int yD = -6; yD <= 6; ++yD) {
                for (int zD = -4; zD <= 4; ++zD) {
                    int x = xO + xD;
                    int y = yO + yD;
                    int z = zO + zD;
                    double distance = Math.sqrt(Math.pow(x - xO, 2.0) + Math.pow(y - yO, 2.0) + Math.pow(z - zO, 2.0));
                    distance = Math.max(1.0, distance);
                    double distanceCoefficient = 1.0 - 1.0 / distance;
                    IBlockState cropState = world.func_180495_p(new BlockPos(x, y, z));
                    Block cropBlock = cropState.func_177230_c();
                    if (!(cropBlock instanceof IPlantable) && !(cropBlock instanceof IGrowable) || cropBlock instanceof BlockGrowth) continue;
                    world.func_180497_b(new BlockPos(x, y, z), cropBlock, (int)(distanceCoefficient * (double)ConfigHandler.BlockGrowthUpgradeTicks * 20.0), 1);
                    cropBlock.func_180650_b(world, new BlockPos(x, y, z), cropState, world.field_73012_v);
                }
            }
        }
        world.func_180497_b(pos, state.func_177230_c(), ConfigHandler.BlockGrowthUpgradeTicks * 20, 1);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState worldIn, World pos, BlockPos state, Random rand) {
        if (ConfigHandler.ParticalTicks) {
            super.func_180655_c(worldIn, pos, state, rand);
            for (int i = -4; i <= 4; ++i) {
                for (int j = -4; j <= 4; ++j) {
                    if (i > -4 && i < 4 && j == -2) {
                        j = 4;
                    }
                    if (rand.nextInt(ConfigHandler.GrowthUpgradeParticalTicks) != 0) continue;
                    for (int k = 0; k <= 1; ++k) {
                        for (int xAxis = -this.range; xAxis <= this.range; ++xAxis) {
                            for (int zAxis = -this.range; zAxis <= this.range; ++zAxis) {
                                for (int yAxis = -this.rangeY; yAxis <= this.rangeY; ++yAxis) {
                                    BlockPos blockpos = state.func_177982_a(i, k, j);
                                    Block checkBlock = pos.func_180495_p(blockpos.func_177982_a(xAxis, yAxis, zAxis)).func_177230_c();
                                    if (!(checkBlock instanceof IGrowable) && checkBlock != Blocks.field_150391_bh && checkBlock != Blocks.field_150434_aF && checkBlock != Blocks.field_150436_aH && checkBlock != Blocks.field_185766_cS) continue;
                                    pos.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)state.func_177958_n() + 0.5, (double)state.func_177956_o() + 2.0, (double)state.func_177952_p() + 0.5, (double)((float)i + rand.nextFloat()) - 0.5, (double)((float)k - rand.nextFloat() - 1.0f), (double)((float)j + rand.nextFloat()) - 0.5, new int[0]);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos).func_185904_a().func_76220_a();
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_185904_a().func_76220_a();
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return this.func_176196_c(worldIn, pos);
    }

    protected static void addCollisionBoxToList(BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable AxisAlignedBB blockBox) {
        AxisAlignedBB axisalignedbb;
        if (blockBox != field_185506_k && entityBox.func_72326_a(axisalignedbb = blockBox.func_186670_a(pos))) {
            collidingBoxes.add(axisalignedbb);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.growthupgrade_1", new Object[0]).func_150254_d());
        tooltip.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.growthupgrade_2", new Object[0]).func_150254_d());
        tooltip.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.growthupgrade_3", new Object[0]).func_150254_d());
        tooltip.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.growthupgrade_4", new Object[0]).func_150254_d());
        tooltip.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.growthupgrade_5", new Object[0]).func_150254_d());
    }
}

