/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.matrix;

import java.util.Objects;
import net.minecraft.util.math.Vec3d;

public final class Mat4d {
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;

    public Mat4d() {
    }

    public Mat4d(Mat4d matrix) {
        Objects.requireNonNull(matrix, "matrix");
        this.m00 = matrix.m00;
        this.m01 = matrix.m01;
        this.m02 = matrix.m02;
        this.m03 = matrix.m03;
        this.m10 = matrix.m10;
        this.m11 = matrix.m11;
        this.m12 = matrix.m12;
        this.m13 = matrix.m13;
        this.m20 = matrix.m20;
        this.m21 = matrix.m21;
        this.m22 = matrix.m22;
        this.m23 = matrix.m23;
        this.m30 = matrix.m30;
        this.m31 = matrix.m31;
        this.m32 = matrix.m32;
        this.m33 = matrix.m33;
    }

    public void asIdentity() {
        this.m33 = 1.0;
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m30 = 0.0;
        this.m23 = 0.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
        this.m13 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m03 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
    }

    public void asTranslation(double x, double y, double z) {
        this.asIdentity();
        this.m03 = x;
        this.m13 = y;
        this.m23 = z;
    }

    public void asRotation(double x, double y, double z, double angle) {
        this.asIdentity();
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double t = 1.0 - c;
        this.m00 = c + x * x * t;
        this.m11 = c + y * y * t;
        this.m22 = c + z * z * t;
        double a = x * y * t;
        double b = z * s;
        this.m10 = a + b;
        this.m01 = a - b;
        a = x * z * t;
        b = y * s;
        this.m20 = a - b;
        this.m02 = a + b;
        a = y * z * t;
        b = x * s;
        this.m21 = a + b;
        this.m12 = a - b;
    }

    public void mul(Mat4d m) {
        Objects.requireNonNull(m, "m");
        double m00 = this.m00 * m.m00 + this.m01 * m.m10 + this.m02 * m.m20 + this.m03 * m.m30;
        double m01 = this.m00 * m.m01 + this.m01 * m.m11 + this.m02 * m.m21 + this.m03 * m.m31;
        double m02 = this.m00 * m.m02 + this.m01 * m.m12 + this.m02 * m.m22 + this.m03 * m.m32;
        double m03 = this.m00 * m.m03 + this.m01 * m.m13 + this.m02 * m.m23 + this.m03 * m.m33;
        double m10 = this.m10 * m.m00 + this.m11 * m.m10 + this.m12 * m.m20 + this.m13 * m.m30;
        double m11 = this.m10 * m.m01 + this.m11 * m.m11 + this.m12 * m.m21 + this.m13 * m.m31;
        double m12 = this.m10 * m.m02 + this.m11 * m.m12 + this.m12 * m.m22 + this.m13 * m.m32;
        double m13 = this.m10 * m.m03 + this.m11 * m.m13 + this.m12 * m.m23 + this.m13 * m.m33;
        double m20 = this.m20 * m.m00 + this.m21 * m.m10 + this.m22 * m.m20 + this.m23 * m.m30;
        double m21 = this.m20 * m.m01 + this.m21 * m.m11 + this.m22 * m.m21 + this.m23 * m.m31;
        double m22 = this.m20 * m.m02 + this.m21 * m.m12 + this.m22 * m.m22 + this.m23 * m.m32;
        double m23 = this.m20 * m.m03 + this.m21 * m.m13 + this.m22 * m.m23 + this.m23 * m.m33;
        double m30 = this.m30 * m.m00 + this.m31 * m.m10 + this.m32 * m.m20 + this.m33 * m.m30;
        double m31 = this.m30 * m.m01 + this.m31 * m.m11 + this.m32 * m.m21 + this.m33 * m.m31;
        double m32 = this.m30 * m.m02 + this.m31 * m.m12 + this.m32 * m.m22 + this.m33 * m.m32;
        double m33 = this.m30 * m.m03 + this.m31 * m.m13 + this.m32 * m.m23 + this.m33 * m.m33;
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    public Vec3d transform(Vec3d point) {
        Objects.requireNonNull(point, "point");
        return new Vec3d(this.m00 * point.field_72450_a + this.m01 * point.field_72448_b + this.m02 * point.field_72449_c + this.m03, this.m10 * point.field_72450_a + this.m11 * point.field_72448_b + this.m12 * point.field_72449_c + this.m13, this.m20 * point.field_72450_a + this.m21 * point.field_72448_b + this.m22 * point.field_72449_c + this.m23);
    }
}

