/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictUtils {
    @Nullable
    private static ImmutableMultimap<Integer, ItemStack> dyeItemStacks;

    private OreDictUtils() {
    }

    public static boolean isDye(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() == Items.field_151100_aR) {
                return true;
            }
            for (ItemStack dye : OreDictUtils.getAllDyes()) {
                if (!OreDictionary.itemMatches((ItemStack)dye, (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getDyeMetadata(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() == Items.field_151100_aR) {
                return stack.func_77960_j();
            }
            OreDictUtils.getDyeItemStacks();
            for (Dye dye : Dye.values()) {
                for (ItemStack dyeStack : OreDictUtils.getDyeItemStacks().get((Object)dye.getDamage())) {
                    if (!OreDictionary.itemMatches((ItemStack)dyeStack, (ItemStack)stack, (boolean)false)) continue;
                    return dye.getDamage();
                }
            }
        }
        return -1;
    }

    public static ImmutableList<ItemStack> getDyes(EnumDyeColor color) {
        return OreDictUtils.getDyeItemStacks().get((Object)color.func_176767_b()).asList();
    }

    public static ImmutableList<ItemStack> getAllDyes() {
        return OreDictUtils.getDyeItemStacks().values().asList();
    }

    public static boolean matches(ItemStack stack, String name) {
        return OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)name), (ItemStack[])new ItemStack[]{stack});
    }

    private static ImmutableMultimap<Integer, ItemStack> getDyeItemStacks() {
        if (dyeItemStacks == null) {
            ImmutableMultimap.Builder bob = ImmutableMultimap.builder();
            for (Dye dye : Dye.values()) {
                bob.putAll((Object)dye.getDamage(), (Iterable)OreDictionary.getOres((String)dye.getName()));
            }
            dyeItemStacks = bob.build();
        }
        return dyeItemStacks;
    }

    private static enum Dye {
        BLACK("dyeBlack"),
        RED("dyeRed"),
        GREEN("dyeGreen"),
        BROWN("dyeBrown"),
        BLUE("dyeBlue"),
        PURPLE("dyePurple"),
        CYAN("dyeCyan"),
        LIGHT_GRAY("dyeLightGray"),
        GRAY("dyeGray"),
        PINK("dyePink"),
        LIME("dyeLime"),
        YELLOW("dyeYellow"),
        LIGHT_BLUE("dyeLightBlue"),
        MAGENTA("dyeMagenta"),
        ORANGE("dyeOrange"),
        WHITE("dyeWhite");

        private final String name;
        private final int damage;

        private Dye(String name) {
            this.name = name;
            this.damage = this.ordinal();
        }

        private String getName() {
            return this.name;
        }

        private int getDamage() {
            return this.damage;
        }
    }
}

