/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.block;

import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.server.ServerEventHandler;
import com.pau101.fairylights.server.block.entity.BlockEntityFastener;
import com.pau101.fairylights.server.capability.CapabilityHandler;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.accessor.FastenerAccessorBlock;
import com.pau101.fairylights.server.fastener.connection.ConnectionType;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.server.fastener.connection.type.hanginglights.ConnectionHangingLights;
import com.pau101.fairylights.util.Utils;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class BlockFastener
extends BlockContainer {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyBool TRIGGERED = PropertyBool.func_177716_a((String)"triggered");
    private static final AxisAlignedBB BOUNDS_DOWN = BlockFastener.createAABB(EnumFacing.DOWN);
    private static final AxisAlignedBB BOUNDS_UP = BlockFastener.createAABB(EnumFacing.UP);
    private static final AxisAlignedBB BOUNDS_NORTH = BlockFastener.createAABB(EnumFacing.NORTH);
    private static final AxisAlignedBB BOUNDS_SOUTH = BlockFastener.createAABB(EnumFacing.SOUTH);
    private static final AxisAlignedBB BOUNDS_WEST = BlockFastener.createAABB(EnumFacing.WEST);
    private static final AxisAlignedBB BOUNDS_EAST = BlockFastener.createAABB(EnumFacing.EAST);
    private static final AxisAlignedBB[] BOUNDS = new AxisAlignedBB[]{BOUNDS_DOWN, BOUNDS_UP, BOUNDS_NORTH, BOUNDS_SOUTH, BOUNDS_WEST, BOUNDS_EAST};

    public BlockFastener() {
        super(Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)));
        this.func_149752_b(2000.0f);
        Utils.name(this, "fastener");
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TRIGGERED});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() | ((Boolean)state.func_177229_b((IProperty)TRIGGERED) != false ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS[((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal()];
    }

    public TileEntity func_149915_a(World world, int data) {
        return new BlockEntityFastener();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return Items.field_190931_a;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ((Fastener)world.func_175625_s(pos).getCapability(CapabilityHandler.FASTENER_CAP, null)).dropItems(world, pos);
        super.func_180663_b(world, pos, state);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        IBlockState blockState = world.func_180495_p(pos);
        Block blockPlacingOn = blockState.func_177230_c();
        return world.isSideSolid(pos, side) || blockPlacingOn instanceof BlockSlab && (side.func_176740_k() != EnumFacing.Axis.Y || side == EnumFacing.DOWN && blockState.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM) || blockPlacingOn instanceof BlockLeaves || blockPlacingOn instanceof BlockStairs;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return worldIn.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing, true) ? this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing) : this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (world.func_175640_z(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()))) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos blockOnPos = pos.func_177972_a(facing.func_176734_d());
        if (this.func_176198_a(world, blockOnPos, facing)) {
            boolean receivingPower = world.func_175640_z(pos);
            boolean isPowered = (Boolean)state.func_177229_b((IProperty)TRIGGERED);
            if (receivingPower && !isPowered) {
                world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
                world.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
            } else if (!receivingPower && isPowered) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
            }
        } else {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        Fastener fastener = (Fastener)world.func_175625_s(pos).getCapability(CapabilityHandler.FASTENER_CAP, null);
        int level = 0;
        for (Map.Entry<UUID, Connection> e : fastener.getConnections().entrySet()) {
            ConnectionHangingLights logic;
            int lvl;
            BlockPos to;
            Connection connection = e.getValue();
            if (connection.getType() != ConnectionType.HANGING_LIGHTS || !connection.getDestination().isLoaded(world) || !connection.isOrigin() && (connection = (fastener = (Fastener)world.func_175625_s(to = connection.getDestination().get(world).getPos()).getCapability(CapabilityHandler.FASTENER_CAP, null)).getConnections().get(e.getKey())) == null || (lvl = (int)Math.ceil((logic = (ConnectionHangingLights)connection).getJingleProgress() * 15.0f)) <= level) continue;
            level = lvl;
        }
        return level;
    }

    public int func_149738_a(World world) {
        return 2;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            this.jingle(world, pos);
        }
    }

    private boolean jingle(World world, BlockPos pos) {
        Fastener fastener = (Fastener)world.func_175625_s(pos).getCapability(CapabilityHandler.FASTENER_CAP, null);
        for (Map.Entry<UUID, Connection> e : fastener.getConnections().entrySet()) {
            ConnectionHangingLights logic;
            BlockPos to;
            Connection connection = e.getValue();
            if (connection.getType() != ConnectionType.HANGING_LIGHTS || !connection.getDestination().isLoaded(world) || !connection.isDestination(new FastenerAccessorBlock(to = connection.getDestination().get(world).getPos())) || !((Boolean)world.func_180495_p(to).func_177229_b((IProperty)TRIGGERED)).booleanValue() || !connection.isOrigin() && (connection = (fastener = (Fastener)world.func_175625_s(to).getCapability(CapabilityHandler.FASTENER_CAP, null)).getConnections().get(e.getKey())) == null || !(logic = (ConnectionHangingLights)connection).canCurrentlyPlayAJingle() || !ServerEventHandler.tryJingle(world, connection, logic, FairyLights.randomJingles)) continue;
            return true;
        }
        return false;
    }

    public Vec3d getOffset(EnumFacing facing, float offset) {
        return BlockFastener.getFastenerOffset(facing, offset);
    }

    private static AxisAlignedBB createAABB(EnumFacing facing) {
        Vec3d offset = BlockFastener.getFastenerOffset(facing, 0.0f);
        double x = offset.field_72450_a;
        double y = offset.field_72448_b;
        double z = offset.field_72449_c;
        return new AxisAlignedBB(x, y, z, x + 0.25, y + 0.25, z + 0.25);
    }

    public static Vec3d getFastenerOffset(EnumFacing facing, float offset) {
        double x = offset;
        double y = offset;
        double z = offset;
        switch (facing) {
            case DOWN: {
                y += 0.75;
            }
            case UP: {
                x += 0.375;
                z += 0.375;
                break;
            }
            case WEST: {
                x += 0.75;
            }
            case EAST: {
                z += 0.375;
                y += 0.375;
                break;
            }
            case NORTH: {
                z += 0.75;
            }
            case SOUTH: {
                x += 0.375;
                y += 0.375;
            }
        }
        return new Vec3d(x, y, z);
    }
}

