/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.questing.tasks.ITickableTask;
import betterquesting.api.storage.IQuestSettings;
import bq_standard.XPHelper;
import bq_standard.client.gui.tasks.GuiTaskXP;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskXP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class TaskXP
implements ITask,
IProgression<Long>,
ITickableTask {
    private ArrayList<UUID> completeUsers = new ArrayList();
    public final HashMap<UUID, Long> userProgress = new HashMap();
    public boolean levels = true;
    public int amount = 30;
    public boolean consume = true;

    public ResourceLocation getFactoryID() {
        return FactoryTaskXP.INSTANCE.getRegistryName();
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public void updateTask(EntityPlayer player, IQuest quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (player.field_70173_aa % 60 == 0 && !((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue()) {
            if (!this.consume) {
                this.setUserProgress(playerID, XPHelper.getPlayerXP(player));
            }
            long rawXP = this.levels ? XPHelper.getLevelXP(this.amount) : (long)this.amount;
            long totalXP = quest == null || (Boolean)quest.getProperties().getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(playerID) : this.getGlobalProgress();
            if (totalXP >= rawXP) {
                this.setComplete(playerID);
            }
        }
    }

    public void detect(EntityPlayer player, IQuest quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.isComplete(playerID)) {
            return;
        }
        long progress = this.getUsersProgress(playerID);
        long rawXP = this.levels ? XPHelper.getLevelXP(this.amount) : (long)this.amount;
        long plrXP = XPHelper.getPlayerXP(player);
        long remaining = rawXP - progress;
        long cost = Math.min(remaining, plrXP);
        if (this.consume) {
            this.setUserProgress(playerID, progress += cost);
            XPHelper.addXP(player, -cost);
        } else {
            this.setUserProgress(playerID, plrXP);
        }
        long totalXP = quest == null || (Boolean)quest.getProperties().getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(playerID) : this.getGlobalProgress();
        if (totalXP >= rawXP) {
            this.setComplete(playerID);
        }
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.xp";
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json, EnumSaveType saveType) {
        if (saveType == EnumSaveType.PROGRESS) {
            return this.writeProgressToJson(json);
        }
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        json.func_74768_a("amount", this.amount);
        json.func_74757_a("isLevels", this.levels);
        json.func_74757_a("consume", this.consume);
        return json;
    }

    public void readFromNBT(NBTTagCompound json, EnumSaveType saveType) {
        if (saveType == EnumSaveType.PROGRESS) {
            this.readProgressFromJson(json);
            return;
        }
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.amount = json.func_150297_b("amount", 99) ? json.func_74762_e("amount") : 30;
        this.levels = json.func_74767_n("isLevels");
        this.consume = json.func_74767_n("consume");
    }

    public void readProgressFromJson(NBTTagCompound json) {
        this.completeUsers = new ArrayList();
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            NBTBase entry = cList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 8) continue;
            try {
                this.completeUsers.add(UUID.fromString(((NBTTagString)entry).func_150285_a_()));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        this.userProgress.clear();
        NBTTagList pList = json.func_150295_c("userProgress", 10);
        for (int i = 0; i < pList.func_74745_c(); ++i) {
            UUID uuid;
            NBTBase entry = pList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 10) continue;
            NBTTagCompound pTag = (NBTTagCompound)entry;
            try {
                uuid = UUID.fromString(pTag.func_74779_i("uuid"));
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
                continue;
            }
            this.userProgress.put(uuid, pTag.func_74763_f("value"));
        }
    }

    public NBTTagCompound writeProgressToJson(NBTTagCompound json) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        NBTTagList progArray = new NBTTagList();
        for (Map.Entry<UUID, Long> entry : this.userProgress.entrySet()) {
            NBTTagCompound pJson = new NBTTagCompound();
            pJson.func_74778_a("uuid", entry.getKey().toString());
            pJson.func_74772_a("value", entry.getValue().longValue());
            progArray.func_74742_a((NBTBase)pJson);
        }
        json.func_74782_a("userProgress", (NBTBase)progArray);
        return json;
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
        this.userProgress.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
        this.userProgress.clear();
    }

    public float getParticipation(UUID uuid) {
        long rawXP;
        long l = rawXP = !this.levels ? (long)this.amount : XPHelper.getLevelXP(this.amount);
        if (rawXP <= 0L) {
            return 1.0f;
        }
        return (float)this.getUsersProgress(uuid).longValue() / (float)rawXP;
    }

    public IGuiEmbedded getTaskGui(int posX, int posY, int sizeX, int sizeY, IQuest quest) {
        return new GuiTaskXP(this, quest, posX, posY, sizeX, sizeY);
    }

    public GuiScreen getTaskEditor(GuiScreen screen, IQuest quest) {
        return null;
    }

    public void setUserProgress(UUID uuid, Long progress) {
        this.userProgress.put(uuid, progress);
    }

    public Long getUsersProgress(UUID ... users) {
        long i = 0L;
        for (UUID uuid : users) {
            Long n = this.userProgress.get(uuid);
            i += n == null ? 0L : n;
        }
        return i;
    }

    public Long getPartyProgress(UUID uuid) {
        long total = 0L;
        IParty party = ((IPartyDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.PARTY_DB)).getUserParty(uuid);
        if (party == null) {
            return this.getUsersProgress(uuid);
        }
        for (UUID mem : party.getMembers()) {
            if (mem != null && party.getStatus(mem).ordinal() <= 0) continue;
            total += this.getUsersProgress(mem).longValue();
        }
        return total;
    }

    public Long getGlobalProgress() {
        long total = 0L;
        for (Long i : this.userProgress.values()) {
            total += i == null ? 0L : 1L;
        }
        return total;
    }

    public IJsonDoc getDocumentation() {
        return null;
    }
}

