/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.ItemComparison;
import bq_standard.client.gui.editors.GuiHuntEditor;
import bq_standard.client.gui.tasks.GuiTaskHunt;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskHunt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskHunt
implements ITask,
IProgression<Integer> {
    private ArrayList<UUID> completeUsers = new ArrayList();
    public HashMap<UUID, Integer> userProgress = new HashMap();
    public String idName = "minecraft:zombie";
    public int required = 1;
    public boolean ignoreNBT = true;
    public boolean subtypes = true;
    public NBTTagCompound targetTags = new NBTTagCompound();

    public ResourceLocation getFactoryID() {
        return FactoryTaskHunt.INSTANCE.getRegistryName();
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.hunt";
    }

    public void detect(EntityPlayer player, IQuest quest) {
        if (this.isComplete(QuestingAPI.getQuestingUUID((EntityPlayer)player))) {
            return;
        }
        int progress = quest == null || (Boolean)quest.getProperties().getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(QuestingAPI.getQuestingUUID((EntityPlayer)player)) : this.getGlobalProgress();
        if (progress >= this.required) {
            this.setComplete(QuestingAPI.getQuestingUUID((EntityPlayer)player));
        }
    }

    public void onKilledByPlayer(IQuest quest, EntityLivingBase entity, DamageSource source) {
        EntityPlayer player = (EntityPlayer)source.func_76346_g();
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (player == null || entity == null || this.isComplete(playerID)) {
            return;
        }
        int progress = this.getUsersProgress(playerID);
        Class<?> subject = entity.getClass();
        ResourceLocation targetID = new ResourceLocation(this.idName);
        Class target = EntityList.getClass((ResourceLocation)targetID);
        ResourceLocation subjectID = EntityList.func_191306_a(subject);
        if (subjectID == null || target == null) {
            return;
        }
        if (this.subtypes && !target.isAssignableFrom(subject)) {
            return;
        }
        if (!this.subtypes && !subjectID.equals((Object)targetID)) {
            return;
        }
        NBTTagCompound subjectTags = new NBTTagCompound();
        entity.func_70039_c(subjectTags);
        if (!this.ignoreNBT && !ItemComparison.CompareNBTTag((NBTBase)this.targetTags, (NBTBase)subjectTags, (boolean)true)) {
            return;
        }
        this.setUserProgress(playerID, progress + 1);
        this.detect(player, quest);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json, EnumSaveType saveType) {
        if (saveType == EnumSaveType.PROGRESS) {
            return this.writeProgressToJson(json);
        }
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        json.func_74778_a("target", this.idName);
        json.func_74768_a("required", this.required);
        json.func_74757_a("subtypes", this.subtypes);
        json.func_74757_a("ignoreNBT", this.ignoreNBT);
        json.func_74782_a("targetNBT", (NBTBase)this.targetTags);
        return json;
    }

    public void readFromNBT(NBTTagCompound json, EnumSaveType saveType) {
        if (saveType == EnumSaveType.PROGRESS) {
            this.readProgressFromJson(json);
            return;
        }
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.idName = json.func_74779_i("target");
        this.required = json.func_74762_e("required");
        this.subtypes = json.func_74767_n("subtypes");
        this.ignoreNBT = json.func_74767_n("ignoreNBT");
        this.targetTags = json.func_74775_l("targetNBT");
    }

    private void readProgressFromJson(NBTTagCompound json) {
        this.completeUsers = new ArrayList();
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            NBTBase entry = cList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 8) continue;
            try {
                this.completeUsers.add(UUID.fromString(((NBTTagString)entry).func_150285_a_()));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        this.userProgress = new HashMap();
        NBTTagList pList = json.func_150295_c("userProgress", 10);
        for (int i = 0; i < pList.func_74745_c(); ++i) {
            UUID uuid;
            NBTBase entry = pList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 10) continue;
            NBTTagCompound pTag = (NBTTagCompound)entry;
            try {
                uuid = UUID.fromString(pTag.func_74779_i("uuid"));
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
                continue;
            }
            this.userProgress.put(uuid, pTag.func_74762_e("value"));
        }
    }

    private NBTTagCompound writeProgressToJson(NBTTagCompound json) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        NBTTagList progArray = new NBTTagList();
        for (Map.Entry<UUID, Integer> entry : this.userProgress.entrySet()) {
            NBTTagCompound pJson = new NBTTagCompound();
            pJson.func_74778_a("uuid", entry.getKey().toString());
            pJson.func_74768_a("value", entry.getValue().intValue());
            progArray.func_74742_a((NBTBase)pJson);
        }
        json.func_74782_a("userProgress", (NBTBase)progArray);
        return json;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, IQuest quest) {
        return new GuiHuntEditor(parent, this);
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
        this.userProgress.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
        this.userProgress.clear();
    }

    public float getParticipation(UUID uuid) {
        if (this.required <= 0) {
            return 1.0f;
        }
        return (float)this.getUsersProgress(uuid).intValue() / (float)this.required;
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiEmbedded getTaskGui(int posX, int posY, int sizeX, int sizeY, IQuest quest) {
        return new GuiTaskHunt(this, quest, posX, posY, sizeX, sizeY);
    }

    public void setUserProgress(UUID uuid, Integer progress) {
        this.userProgress.put(uuid, progress);
    }

    public Integer getUsersProgress(UUID ... users) {
        int i = 0;
        for (UUID uuid : users) {
            Integer n = this.userProgress.get(uuid);
            i += n == null ? 0 : n;
        }
        return i;
    }

    public Integer getPartyProgress(UUID uuid) {
        int total = 0;
        IParty party = ((IPartyDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.PARTY_DB)).getUserParty(uuid);
        if (party == null) {
            return this.getUsersProgress(uuid);
        }
        for (UUID mem : party.getMembers()) {
            if (mem != null && party.getStatus(mem).ordinal() <= 0) continue;
            total += this.getUsersProgress(mem).intValue();
        }
        return total;
    }

    public Integer getGlobalProgress() {
        int total = 0;
        for (Integer i : this.userProgress.values()) {
            total += i == null ? 0 : i;
        }
        return total;
    }

    public IJsonDoc getDocumentation() {
        return null;
    }
}

