/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api.questing.tasks.IFluidTask;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.questing.tasks.ITickableTask;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api.utils.JsonHelper;
import bq_standard.client.gui.tasks.GuiTaskFluid;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskFluid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskFluid
implements ITask,
IFluidTask,
IItemTask,
IProgression<int[]>,
ITickableTask {
    private List<UUID> completeUsers = new ArrayList<UUID>();
    public List<FluidStack> requiredFluids = new ArrayList<FluidStack>();
    public Map<UUID, int[]> userProgress = new HashMap<UUID, int[]>();
    public boolean consume = true;
    public boolean autoConsume = false;
    public boolean ignoreNbt = false;

    public ResourceLocation getFactoryID() {
        return FactoryTaskFluid.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.fluid";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public void updateTask(EntityPlayer player, IQuest quest) {
        if (player.field_70173_aa % 60 == 0 && !((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue()) {
            if (!this.consume || this.autoConsume) {
                this.detect(player, quest);
            } else {
                boolean flag = true;
                int[] totalProgress = quest == null || (Boolean)quest.getProperties().getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(QuestingAPI.getQuestingUUID((EntityPlayer)player)) : this.getGlobalProgress();
                for (int j = 0; j < this.requiredFluids.size(); ++j) {
                    FluidStack rStack = this.requiredFluids.get(j);
                    if (rStack == null || totalProgress[j] >= rStack.amount) continue;
                    flag = false;
                    break;
                }
                if (flag) {
                    this.setComplete(QuestingAPI.getQuestingUUID((EntityPlayer)player));
                }
            }
        }
    }

    public void detect(EntityPlayer player, IQuest quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (player.field_71071_by == null || this.isComplete(playerID)) {
            return;
        }
        int[] progress = this.getUsersProgress(playerID);
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            IFluidHandlerItem handler;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || (handler = FluidUtil.getFluidHandler((ItemStack)stack)) == null) continue;
            for (int j = 0; j < this.requiredFluids.size(); ++j) {
                FluidStack fluid;
                FluidStack rStack = this.requiredFluids.get(j);
                if (rStack == null || progress[j] >= rStack.amount) continue;
                int remaining = rStack.amount - progress[j];
                FluidStack drain = rStack.copy();
                drain.amount = remaining;
                if (this.ignoreNbt) {
                    drain.tag = null;
                }
                if ((fluid = handler.drain(drain, this.consume)) == null || fluid.amount <= 0) continue;
                if (this.consume) {
                    player.field_71071_by.func_70299_a(i, handler.getContainer());
                }
                int n = j;
                progress[n] = progress[n] + Math.min(remaining, fluid.amount);
            }
        }
        boolean flag = true;
        int[] totalProgress = progress;
        if (this.consume) {
            this.setUserProgress(QuestingAPI.getQuestingUUID((EntityPlayer)player), progress);
            totalProgress = quest == null || (Boolean)quest.getProperties().getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(playerID) : this.getGlobalProgress();
        }
        for (int j = 0; j < this.requiredFluids.size(); ++j) {
            FluidStack rStack = this.requiredFluids.get(j);
            if (rStack == null || totalProgress[j] >= rStack.amount) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.setComplete(playerID);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json, EnumSaveType saveType) {
        if (saveType == EnumSaveType.PROGRESS) {
            return this.writeProgressToJson(json);
        }
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        json.func_74757_a("consume", this.consume);
        json.func_74757_a("autoConsume", this.autoConsume);
        json.func_74757_a("ignoreNBT", this.ignoreNbt);
        NBTTagList itemArray = new NBTTagList();
        for (FluidStack stack : this.requiredFluids) {
            itemArray.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        json.func_74782_a("requiredFluids", (NBTBase)itemArray);
        return json;
    }

    public void readFromNBT(NBTTagCompound json, EnumSaveType saveType) {
        if (saveType == EnumSaveType.PROGRESS) {
            this.readProgressFromJson(json);
            return;
        }
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.consume = json.func_74767_n("consume");
        this.autoConsume = json.func_74767_n("autoConsume");
        this.ignoreNbt = json.func_74767_n("ignoreNBT");
        this.requiredFluids = new ArrayList<FluidStack>();
        NBTTagList fList = json.func_150295_c("requiredFluids", 10);
        for (int i = 0; i < fList.func_74745_c(); ++i) {
            FluidStack fluid;
            NBTBase entry = fList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 10 || (fluid = JsonHelper.JsonToFluidStack((NBTTagCompound)((NBTTagCompound)entry))) == null) continue;
            this.requiredFluids.add(fluid);
        }
    }

    private void readProgressFromJson(NBTTagCompound json) {
        this.completeUsers = new ArrayList<UUID>();
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            NBTBase entry = cList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 8) continue;
            try {
                this.completeUsers.add(UUID.fromString(((NBTTagString)entry).func_150285_a_()));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        this.userProgress = new HashMap<UUID, int[]>();
        NBTTagList pList = json.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            UUID uuid;
            NBTBase entry = pList.func_179238_g(n);
            if (entry == null || entry.func_74732_a() != 10) continue;
            NBTTagCompound pTag = (NBTTagCompound)entry;
            try {
                uuid = UUID.fromString(pTag.func_74779_i("uuid"));
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
                continue;
            }
            int[] data = new int[this.requiredFluids.size()];
            NBTTagList dJson = pTag.func_150295_c("data", 3);
            for (int i = 0; i < data.length && i < dJson.func_74745_c(); ++i) {
                try {
                    data[i] = dJson.func_186858_c(i);
                    continue;
                }
                catch (Exception e) {
                    BQ_Standard.logger.log(Level.ERROR, "Incorrect task progress format", (Throwable)e);
                }
            }
            this.userProgress.put(uuid, data);
        }
    }

    private NBTTagCompound writeProgressToJson(NBTTagCompound json) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        NBTTagList progArray = new NBTTagList();
        for (Map.Entry<UUID, int[]> entry : this.userProgress.entrySet()) {
            NBTTagCompound pJson = new NBTTagCompound();
            pJson.func_74778_a("uuid", entry.getKey().toString());
            NBTTagList pArray = new NBTTagList();
            for (int i : entry.getValue()) {
                pArray.func_74742_a((NBTBase)new NBTTagInt(i));
            }
            pJson.func_74782_a("data", (NBTBase)pArray);
            progArray.func_74742_a((NBTBase)pJson);
        }
        json.func_74782_a("userProgress", (NBTBase)progArray);
        return json;
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
        this.userProgress.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
        this.userProgress.clear();
    }

    public float getParticipation(UUID uuid) {
        if (this.requiredFluids.size() <= 0) {
            return 1.0f;
        }
        float total = 0.0f;
        int[] progress = this.getUsersProgress(uuid);
        for (int i = 0; i < this.requiredFluids.size(); ++i) {
            FluidStack rStack = this.requiredFluids.get(i);
            total += (float)progress[i] / (float)rStack.amount;
        }
        return total / (float)this.requiredFluids.size();
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiEmbedded getTaskGui(int posX, int posY, int sizeX, int sizeY, IQuest quest) {
        return new GuiTaskFluid(this, quest, posX, posY, sizeX, sizeY);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen screen, IQuest quest) {
        return null;
    }

    public boolean canAcceptFluid(UUID owner, FluidStack fluid) {
        if (owner == null || fluid == null || fluid.getFluid() == null || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return false;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredFluids.size(); ++j) {
            FluidStack rStack = this.requiredFluids.get(j);
            if (rStack == null || progress[j] >= rStack.amount || !rStack.equals((Object)fluid)) continue;
            return true;
        }
        return false;
    }

    public boolean canAcceptItem(UUID owner, ItemStack item) {
        if (owner == null || item == null || item.func_190926_b() || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return false;
        }
        FluidStack contents = FluidUtil.getFluidContained((ItemStack)item);
        return contents != null && this.canAcceptFluid(owner, contents);
    }

    public FluidStack submitFluid(UUID owner, FluidStack fluid) {
        if (owner == null || fluid == null || fluid.amount <= 0 || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return fluid;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredFluids.size(); ++j) {
            FluidStack rStack = this.requiredFluids.get(j);
            if (rStack == null || progress[j] >= rStack.amount) continue;
            int remaining = rStack.amount - progress[j];
            if (!rStack.isFluidEqual(fluid)) continue;
            int removed = Math.min(fluid.amount, remaining);
            int n = j;
            progress[n] = progress[n] + removed;
            fluid.amount -= removed;
            if (fluid.amount > 0) continue;
            fluid = null;
            break;
        }
        if (this.consume) {
            this.setUserProgress(owner, progress);
        }
        return fluid;
    }

    public ItemStack submitItem(UUID owner, ItemStack input) {
        ItemStack item = input;
        if (item == null || item.func_190926_b()) {
            return item;
        }
        item = item.func_77946_l();
        item.func_190920_e(1);
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)item);
        FluidStack fluid = handler.drain(Integer.MAX_VALUE, false);
        if (fluid != null && handler != null) {
            int amount = fluid.amount;
            fluid = this.submitFluid(owner, fluid);
            input.func_190918_g(1);
            handler.drain(amount - (fluid == null ? 0 : fluid.amount), true);
            return handler.getContainer();
        }
        return item;
    }

    public void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID ... users) {
        int[] progress = new int[this.requiredFluids.size()];
        for (UUID uuid : users) {
            int[] tmp = this.userProgress.get(uuid);
            if (tmp == null || tmp.length != this.requiredFluids.size()) continue;
            for (int n = 0; n < progress.length; ++n) {
                int n2 = n;
                progress[n2] = progress[n2] + tmp[n];
            }
        }
        return progress == null || progress.length != this.requiredFluids.size() ? new int[this.requiredFluids.size()] : progress;
    }

    public int[] getPartyProgress(UUID uuid) {
        int[] total = new int[this.requiredFluids.size()];
        IParty party = ((IPartyDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.PARTY_DB)).getUserParty(uuid);
        if (party == null) {
            return this.getUsersProgress(uuid);
        }
        for (UUID mem : party.getMembers()) {
            if (mem != null && party.getStatus(mem).ordinal() <= 0) continue;
            int[] progress = this.getUsersProgress(mem);
            for (int i = 0; i < progress.length; ++i) {
                int n = i;
                total[n] = total[n] + progress[i];
            }
        }
        return total;
    }

    public int[] getGlobalProgress() {
        int[] total = new int[this.requiredFluids.size()];
        for (int[] up : this.userProgress.values()) {
            if (up == null) continue;
            int[] progress = up.length != this.requiredFluids.size() ? new int[this.requiredFluids.size()] : up;
            for (int i = 0; i < progress.length; ++i) {
                int n = i;
                total[n] = total[n] + progress[i];
            }
        }
        return total;
    }

    public IJsonDoc getDocumentation() {
        return null;
    }
}

