/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api.utils.JsonHelper;
import bq_standard.client.gui.tasks.GuiTaskCrafting;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskCrafting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskCrafting
implements ITask,
IProgression<int[]> {
    private ArrayList<UUID> completeUsers = new ArrayList();
    public ArrayList<BigItemStack> requiredItems = new ArrayList();
    public HashMap<UUID, int[]> userProgress = new HashMap();
    boolean partialMatch = true;
    boolean ignoreNBT = false;

    public ResourceLocation getFactoryID() {
        return FactoryTaskCrafting.INSTANCE.getRegistryName();
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.crafting";
    }

    public void detect(EntityPlayer player, IQuest quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.isComplete(playerID)) {
            return;
        }
        int[] progress = quest == null || (Boolean)quest.getProperties().getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(playerID) : this.getGlobalProgress();
        boolean flag = true;
        for (int i = 0; i < this.requiredItems.size(); ++i) {
            BigItemStack rStack = this.requiredItems.get(i);
            if (progress[i] >= rStack.stackSize) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.setComplete(playerID);
        }
    }

    public void onItemCrafted(IQuest quest, EntityPlayer player, ItemStack stack) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.isComplete(playerID)) {
            return;
        }
        int[] progress = this.getUsersProgress(playerID);
        for (int i = 0; i < this.requiredItems.size(); ++i) {
            BigItemStack rStack = this.requiredItems.get(i);
            if (progress[i] >= rStack.stackSize || !ItemComparison.StackMatch((ItemStack)rStack.getBaseStack(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch) && !ItemComparison.OreDictionaryMatch((String)rStack.oreDict, (NBTTagCompound)rStack.GetTagCompound(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) continue;
            int n = i;
            progress[n] = progress[n] + stack.func_190916_E();
        }
        this.setUserProgress(QuestingAPI.getQuestingUUID((EntityPlayer)player), progress);
        this.detect(player, quest);
    }

    public void onItemSmelted(IQuest quest, EntityPlayer player, ItemStack stack) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        int[] progress = this.getUsersProgress(playerID);
        for (int i = 0; i < this.requiredItems.size(); ++i) {
            BigItemStack rStack = this.requiredItems.get(i);
            if (progress[i] >= rStack.stackSize || !ItemComparison.StackMatch((ItemStack)rStack.getBaseStack(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch) && !ItemComparison.OreDictionaryMatch((String)rStack.oreDict, (NBTTagCompound)rStack.GetTagCompound(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) continue;
            int n = i;
            progress[n] = progress[n] + stack.func_190916_E();
        }
        this.setUserProgress(playerID, progress);
        this.detect(player, quest);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json, EnumSaveType saveType) {
        if (saveType == EnumSaveType.PROGRESS) {
            return this.writeProgressToJson(json);
        }
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        json.func_74757_a("partialMatch", this.partialMatch);
        json.func_74757_a("ignoreNBT", this.ignoreNBT);
        NBTTagList itemArray = new NBTTagList();
        for (BigItemStack stack : this.requiredItems) {
            itemArray.func_74742_a((NBTBase)JsonHelper.ItemStackToJson((BigItemStack)stack, (NBTTagCompound)new NBTTagCompound()));
        }
        json.func_74782_a("requiredItems", (NBTBase)itemArray);
        return json;
    }

    public void readFromNBT(NBTTagCompound json, EnumSaveType saveType) {
        if (saveType == EnumSaveType.PROGRESS) {
            this.readProgressFromJson(json);
            return;
        }
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.partialMatch = json.func_74767_n("partialMatch");
        this.ignoreNBT = json.func_74767_n("ignoreNBT");
        this.requiredItems = new ArrayList();
        NBTTagList iList = json.func_150295_c("requiredItems", 10);
        for (int i = 0; i < iList.func_74745_c(); ++i) {
            NBTBase entry = iList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 10) continue;
            try {
                BigItemStack item = JsonHelper.JsonToItemStack((NBTTagCompound)((NBTTagCompound)entry));
                if (item == null) continue;
                this.requiredItems.add(item);
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load quest item data", (Throwable)e);
            }
        }
    }

    public void readProgressFromJson(NBTTagCompound json) {
        this.completeUsers = new ArrayList();
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            NBTBase entry = cList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 8) continue;
            try {
                this.completeUsers.add(UUID.fromString(((NBTTagString)entry).func_150285_a_()));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        this.userProgress = new HashMap();
        NBTTagList pList = json.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            UUID uuid;
            NBTBase entry = pList.func_179238_g(n);
            if (entry == null || entry.func_74732_a() != 10) continue;
            NBTTagCompound pTag = (NBTTagCompound)entry;
            try {
                uuid = UUID.fromString(pTag.func_74779_i("uuid"));
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
                continue;
            }
            int[] data = new int[this.requiredItems.size()];
            NBTTagList dJson = pTag.func_150295_c("data", 3);
            for (int i = 0; i < data.length && i < dJson.func_74745_c(); ++i) {
                try {
                    data[i] = dJson.func_186858_c(i);
                    continue;
                }
                catch (Exception e) {
                    BQ_Standard.logger.log(Level.ERROR, "Incorrect task progress format", (Throwable)e);
                }
            }
            this.userProgress.put(uuid, data);
        }
    }

    public NBTTagCompound writeProgressToJson(NBTTagCompound json) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        NBTTagList progArray = new NBTTagList();
        for (Map.Entry<UUID, int[]> entry : this.userProgress.entrySet()) {
            NBTTagCompound pJson = new NBTTagCompound();
            pJson.func_74778_a("uuid", entry.getKey().toString());
            NBTTagList pArray = new NBTTagList();
            for (int i : entry.getValue()) {
                pArray.func_74742_a((NBTBase)new NBTTagInt(i));
            }
            pJson.func_74782_a("data", (NBTBase)pArray);
            progArray.func_74742_a((NBTBase)pJson);
        }
        json.func_74782_a("userProgress", (NBTBase)progArray);
        return json;
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
        this.userProgress.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
        this.userProgress.clear();
    }

    public float getParticipation(UUID uuid) {
        if (this.requiredItems.size() <= 0) {
            return 1.0f;
        }
        float total = 0.0f;
        int[] progress = this.getUsersProgress(uuid);
        for (int i = 0; i < this.requiredItems.size(); ++i) {
            BigItemStack rStack = this.requiredItems.get(i);
            total += (float)progress[i] / (float)rStack.stackSize;
        }
        return total / (float)this.requiredItems.size();
    }

    public IGuiEmbedded getTaskGui(int posX, int posY, int sizeX, int sizeY, IQuest quest) {
        return new GuiTaskCrafting(this, quest, posX, posY, sizeX, sizeY);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, IQuest quest) {
        return null;
    }

    public void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID ... users) {
        int[] progress = new int[this.requiredItems.size()];
        for (UUID uuid : users) {
            int[] tmp = this.userProgress.get(uuid);
            if (tmp == null || tmp.length != this.requiredItems.size()) continue;
            for (int n = 0; n < progress.length; ++n) {
                int n2 = n;
                progress[n2] = progress[n2] + tmp[n];
            }
        }
        return progress == null || progress.length != this.requiredItems.size() ? new int[this.requiredItems.size()] : progress;
    }

    public int[] getPartyProgress(UUID uuid) {
        int[] total = new int[this.requiredItems.size()];
        IParty party = ((IPartyDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.PARTY_DB)).getUserParty(uuid);
        if (party == null) {
            return this.getUsersProgress(uuid);
        }
        for (UUID mem : party.getMembers()) {
            if (mem != null && party.getStatus(mem).ordinal() <= 0) continue;
            int[] progress = this.getUsersProgress(mem);
            for (int i = 0; i < progress.length; ++i) {
                int n = i;
                total[n] = total[n] + progress[i];
            }
        }
        return total;
    }

    public int[] getGlobalProgress() {
        int[] total = new int[this.requiredItems.size()];
        for (int[] up : this.userProgress.values()) {
            if (up == null) continue;
            int[] progress = up.length != this.requiredItems.size() ? new int[this.requiredItems.size()] : up;
            for (int i = 0; i < progress.length; ++i) {
                int n = i;
                total[n] = total[n] + progress[i];
            }
        }
        return total;
    }

    public IJsonDoc getDocumentation() {
        return null;
    }
}

