/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.api.placeholders.ItemPlaceholder;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import bq_standard.client.gui.tasks.GuiTaskBlockBreak;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskBlockBreak;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class TaskBlockBreak
implements ITask,
IProgression<int[]> {
    private ArrayList<UUID> completeUsers = new ArrayList();
    public HashMap<UUID, int[]> userProgress = new HashMap();
    public ArrayList<JsonBlockType> blockTypes = new ArrayList();

    public TaskBlockBreak() {
        this.blockTypes.add(new JsonBlockType());
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskBlockBreak.INSTANCE.getRegistryName();
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.block_break";
    }

    public void detect(EntityPlayer player, IQuest quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.isComplete(playerID)) {
            return;
        }
        boolean flag = true;
        int[] progress = quest == null || (Boolean)quest.getProperties().getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(playerID) : this.getGlobalProgress();
        for (int j = 0; j < this.blockTypes.size(); ++j) {
            JsonBlockType block = this.blockTypes.get(j);
            if (block == null || progress[j] >= block.n) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.setComplete(playerID);
        }
    }

    public void onBlockBreak(IQuest quest, EntityPlayer player, IBlockState state, BlockPos pos) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.isComplete(playerID)) {
            return;
        }
        int[] progress = this.getUsersProgress(playerID);
        TileEntity tile = player.field_70170_p.func_175625_s(pos);
        NBTTagCompound tags = new NBTTagCompound();
        if (tile != null) {
            tile.func_189515_b(tags);
        }
        for (int i = 0; i < this.blockTypes.size(); ++i) {
            boolean flag;
            JsonBlockType block = this.blockTypes.get(i);
            boolean bl = block.oreDict.length() > 0 && OreDictionary.getOres((String)block.oreDict).contains((Object)new ItemStack(state.func_177230_c(), 1, block.m < 0 ? Short.MAX_VALUE : state.func_177230_c().func_176201_c(state))) ? true : (flag = false);
            if (!flag && (state.func_177230_c() != block.b || block.m >= 0 && state.func_177230_c().func_176201_c(state) != block.m) || !ItemComparison.CompareNBTTag((NBTBase)block.tags, (NBTBase)tags, (boolean)true)) continue;
            int n = i;
            progress[n] = progress[n] + 1;
            this.setUserProgress(player.func_110124_au(), progress);
            break;
        }
        this.detect(player, quest);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json, EnumSaveType saveType) {
        if (saveType == EnumSaveType.PROGRESS) {
            return this.writeProgressToJson(json);
        }
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        NBTTagList bAry = new NBTTagList();
        for (JsonBlockType block : this.blockTypes) {
            NBTTagCompound jbt = block.writeToJson(new NBTTagCompound());
            bAry.func_74742_a((NBTBase)jbt);
        }
        json.func_74782_a("blocks", (NBTBase)bAry);
        return json;
    }

    public void readFromNBT(NBTTagCompound json, EnumSaveType saveType) {
        if (saveType == EnumSaveType.PROGRESS) {
            this.readProgressFromJson(json);
            return;
        }
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.blockTypes.clear();
        NBTTagList bList = json.func_150295_c("blocks", 10);
        for (int i = 0; i < bList.func_74745_c(); ++i) {
            NBTBase element = bList.func_179238_g(i);
            if (element == null || element.func_74732_a() != 10) continue;
            JsonBlockType block = new JsonBlockType();
            block.readFromJson((NBTTagCompound)element);
            this.blockTypes.add(block);
        }
        if (json.func_150297_b("blockID", 8)) {
            Block targetBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(json.func_74779_i("blockID")));
            targetBlock = targetBlock != null ? targetBlock : Blocks.field_150364_r;
            int targetMeta = json.func_74762_e("blockMeta");
            NBTTagCompound targetNbt = json.func_74775_l("blockNBT");
            int targetNum = json.func_74762_e("amount");
            JsonBlockType leg = new JsonBlockType();
            leg.b = targetBlock;
            leg.m = targetMeta;
            leg.tags = targetNbt;
            leg.n = targetNum;
            this.blockTypes.add(leg);
        }
    }

    public void readProgressFromJson(NBTTagCompound json) {
        this.completeUsers = new ArrayList();
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            NBTBase entry = cList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 8) continue;
            try {
                this.completeUsers.add(UUID.fromString(((NBTTagString)entry).func_150285_a_()));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        this.userProgress = new HashMap();
        NBTTagList pList = json.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            UUID uuid;
            NBTBase entry = pList.func_179238_g(n);
            if (entry == null || entry.func_74732_a() != 10) continue;
            NBTTagCompound pTag = (NBTTagCompound)entry;
            try {
                uuid = UUID.fromString(pTag.func_74779_i("uuid"));
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
                continue;
            }
            int[] data = new int[this.blockTypes.size()];
            NBTTagList dJson = pTag.func_150295_c("data", 3);
            for (int i = 0; i < data.length && i < dJson.func_74745_c(); ++i) {
                try {
                    data[i] = dJson.func_186858_c(i);
                    continue;
                }
                catch (Exception e) {
                    BQ_Standard.logger.log(Level.ERROR, "Incorrect task progress format", (Throwable)e);
                }
            }
            this.userProgress.put(uuid, data);
        }
    }

    public NBTTagCompound writeProgressToJson(NBTTagCompound json) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        NBTTagList progArray = new NBTTagList();
        for (Map.Entry<UUID, int[]> entry : this.userProgress.entrySet()) {
            NBTTagCompound pJson = new NBTTagCompound();
            pJson.func_74778_a("uuid", entry.getKey().toString());
            NBTTagList pArray = new NBTTagList();
            for (int i : entry.getValue()) {
                pArray.func_74742_a((NBTBase)new NBTTagInt(i));
            }
            pJson.func_74782_a("data", (NBTBase)pArray);
            progArray.func_74742_a((NBTBase)pJson);
        }
        json.func_74782_a("userProgress", (NBTBase)progArray);
        return json;
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
        this.userProgress.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
        this.userProgress = new HashMap();
    }

    public float getParticipation(UUID uuid) {
        if (this.blockTypes.size() <= 0) {
            return 1.0f;
        }
        float total = 0.0f;
        int[] progress = this.getUsersProgress(uuid);
        for (int i = 0; i < this.blockTypes.size(); ++i) {
            JsonBlockType block = this.blockTypes.get(i);
            total += (float)progress[i] / (float)block.n;
        }
        return total / (float)this.blockTypes.size();
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiEmbedded getTaskGui(int posX, int posY, int sizeX, int sizeY, IQuest quest) {
        return new GuiTaskBlockBreak(this, quest, posX, posY, sizeX, sizeY);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen screen, IQuest quest) {
        return null;
    }

    public void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID ... users) {
        int[] progress = new int[this.blockTypes.size()];
        for (UUID uuid : users) {
            int[] tmp = this.userProgress.get(uuid);
            if (tmp == null || tmp.length != this.blockTypes.size()) continue;
            for (int n = 0; n < progress.length; ++n) {
                int n2 = n;
                progress[n2] = progress[n2] + tmp[n];
            }
        }
        return progress == null || progress.length != this.blockTypes.size() ? new int[this.blockTypes.size()] : progress;
    }

    public int[] getPartyProgress(UUID uuid) {
        int[] total = new int[this.blockTypes.size()];
        IParty party = ((IPartyDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.PARTY_DB)).getUserParty(uuid);
        if (party == null) {
            return this.getUsersProgress(uuid);
        }
        for (UUID mem : party.getMembers()) {
            if (mem != null && party.getStatus(mem).ordinal() <= 0) continue;
            int[] progress = this.getUsersProgress(mem);
            for (int i = 0; i < progress.length; ++i) {
                int n = i;
                total[n] = total[n] + progress[i];
            }
        }
        return total;
    }

    public int[] getGlobalProgress() {
        int[] total = new int[this.blockTypes.size()];
        for (int[] up : this.userProgress.values()) {
            if (up == null) continue;
            int[] progress = up.length != this.blockTypes.size() ? new int[this.blockTypes.size()] : up;
            for (int i = 0; i < progress.length; ++i) {
                int n = i;
                total[n] = total[n] + progress[i];
            }
        }
        return total;
    }

    public IJsonDoc getDocumentation() {
        return null;
    }

    public static class JsonBlockType {
        public Block b = Blocks.field_150364_r;
        public int m = -1;
        public NBTTagCompound tags = new NBTTagCompound();
        public int n = 1;
        public String oreDict = "";

        public NBTTagCompound writeToJson(NBTTagCompound json) {
            json.func_74778_a("blockID", this.b.getRegistryName().toString());
            json.func_74768_a("meta", this.m);
            json.func_74782_a("nbt", (NBTBase)this.tags);
            json.func_74768_a("amount", this.n);
            json.func_74778_a("oreDict", this.oreDict);
            return json;
        }

        public void readFromJson(NBTTagCompound json) {
            this.b = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(json.func_74779_i("blockID")));
            this.b = this.b != null ? this.b : Blocks.field_150364_r;
            this.m = json.func_74762_e("meta");
            this.n = this.n < 0 ? Short.MAX_VALUE : this.n;
            this.tags = json.func_74775_l("nbt");
            this.n = json.func_74762_e("amount");
            this.oreDict = json.func_74779_i("oreDict");
        }

        public BigItemStack getItemStack() {
            BigItemStack stack = null;
            if (this.b == null || Item.func_150898_a((Block)this.b) == null) {
                stack = new BigItemStack(ItemPlaceholder.placeholder, this.n, 0);
                stack.getBaseStack().func_151001_c("NULL");
                if (this.b != null) {
                    stack.getBaseStack().func_151001_c(this.b.func_149732_F());
                    stack.GetTagCompound().func_74778_a("orig_id", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.b)).toString());
                } else {
                    stack.getBaseStack().func_151001_c("NULL");
                    stack.GetTagCompound().func_74778_a("orig_id", "NULL");
                }
            } else {
                stack = new BigItemStack(this.b, this.n, this.m);
            }
            stack.oreDict = this.oreDict;
            return stack;
        }
    }
}

