/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.rewards.loot;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import bq_standard.core.BQ_Standard;
import bq_standard.network.StandardPacketType;
import bq_standard.rewards.loot.LootGroup;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.logging.log4j.Level;

public class LootRegistry {
    public static CopyOnWriteArrayList<LootGroup> lootGroups = new CopyOnWriteArrayList();
    public static boolean updateUI = false;
    static File worldDir = null;

    public static void registerGroup(LootGroup group) {
        if (group == null || lootGroups.contains(group)) {
            return;
        }
        lootGroups.add(group);
    }

    public static LootGroup getWeightedGroup(float weight, Random rand) {
        int total = LootRegistry.getTotalWeight();
        if (total <= 0) {
            BQ_Standard.logger.log(Level.WARN, "Unable to get random loot group! Reason: No registered groups/weights");
            return null;
        }
        float r = rand.nextFloat() * (float)total / 4.0f + weight * (float)total * 0.75f;
        int cnt = 0;
        ArrayList<LootGroup> sorted = new ArrayList<LootGroup>(lootGroups);
        Collections.sort(sorted);
        for (LootGroup entry : sorted) {
            if (!((float)(cnt += entry.weight) >= r)) continue;
            return entry;
        }
        BQ_Standard.logger.log(Level.WARN, "Unable to get random loot group! Reason: Unknown");
        return null;
    }

    public static int getTotalWeight() {
        int i = 0;
        for (LootGroup group : lootGroups) {
            i += group.weight;
        }
        return i;
    }

    public static ArrayList<BigItemStack> getStandardLoot(EntityPlayer player) {
        ArrayList<BigItemStack> stacks = new ArrayList<BigItemStack>();
        LootTable table = player.field_70170_p.func_184146_ak().func_186521_a(LootTableList.field_186422_d);
        LootContext.Builder lcBuilder = new LootContext.Builder((WorldServer)player.field_70170_p);
        for (ItemStack s : table.func_186462_a(player.func_70681_au(), lcBuilder.func_186471_a())) {
            stacks.add(new BigItemStack(s));
        }
        return stacks;
    }

    public static void updateClients() {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound json = new NBTTagCompound();
        LootRegistry.writeToJson(json);
        tags.func_74782_a("Database", (NBTBase)json);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToAll(new QuestingPacket(StandardPacketType.LOOT_SYNC.GetLocation(), tags));
    }

    public static void sendDatabase(EntityPlayerMP player) {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound json = new NBTTagCompound();
        LootRegistry.writeToJson(json);
        tags.func_74782_a("Database", (NBTBase)json);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToPlayer(new QuestingPacket(StandardPacketType.LOOT_SYNC.GetLocation(), tags), player);
    }

    public static void writeToJson(NBTTagCompound json) {
        NBTTagList jRew = new NBTTagList();
        for (LootGroup entry : lootGroups) {
            NBTTagCompound jGrp = new NBTTagCompound();
            entry.writeToJson(jGrp);
            jRew.func_74742_a((NBTBase)jGrp);
        }
        json.func_74782_a("groups", (NBTBase)jRew);
    }

    public static void readFromJson(NBTTagCompound json) {
        lootGroups.clear();
        NBTTagList list = json.func_150295_c("groups", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTBase entry = list.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 10) continue;
            LootGroup group = new LootGroup();
            group.readFromJson((NBTTagCompound)entry);
            lootGroups.add(group);
        }
        updateUI = true;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K || worldDir != null) {
            return;
        }
        MinecraftServer server = event.getWorld().func_73046_m();
        worldDir = BQ_Standard.proxy.isClient() ? server.func_71209_f("saves/" + server.func_71270_I()) : server.func_71209_f(server.func_71270_I());
        File f1 = new File(worldDir, "QuestLoot.json");
        JsonObject j1 = new JsonObject();
        if (f1.exists()) {
            j1 = JsonHelper.ReadFromFile((File)f1);
        } else {
            f1 = server.func_71209_f("config/betterquesting/DefaultLoot.json");
            if (f1.exists()) {
                j1 = JsonHelper.ReadFromFile((File)f1);
            }
        }
        LootRegistry.readFromJson(NBTConverter.JSONtoNBT_Object((JsonObject)j1, (NBTTagCompound)new NBTTagCompound(), (boolean)true));
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K && worldDir != null && event.getWorld().field_73011_w.getDimension() == 0) {
            NBTTagCompound jsonQ = new NBTTagCompound();
            LootRegistry.writeToJson(jsonQ);
            JsonHelper.WriteToFile((File)new File(worldDir, "QuestLoot.json"), (JsonObject)NBTConverter.NBTtoJSON_Compound((NBTTagCompound)jsonQ, (JsonObject)new JsonObject(), (boolean)true));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K && !event.getWorld().func_73046_m().func_71278_l()) {
            worldDir = null;
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            LootRegistry.sendDatabase((EntityPlayerMP)event.player);
        }
    }
}

