/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.rewards.loot;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class LootGroup
implements Comparable<LootGroup> {
    public String name = "Loot Group";
    public int weight = 1;
    public ArrayList<LootEntry> lootEntry = new ArrayList();

    public ArrayList<BigItemStack> getRandomReward(Random rand) {
        int total = this.getTotalWeight();
        float r = rand.nextFloat() * (float)total;
        int cnt = 0;
        for (LootEntry entry : this.lootEntry) {
            if (!((float)(cnt += entry.weight) >= r)) continue;
            return entry.items;
        }
        return new ArrayList<BigItemStack>();
    }

    public int getTotalWeight() {
        int i = 0;
        for (LootEntry entry : this.lootEntry) {
            i += entry.weight;
        }
        return i;
    }

    public void readFromJson(NBTTagCompound json) {
        this.name = json.func_150297_b("name", 8) ? json.func_74779_i("name") : "Loot Group";
        this.weight = json.func_74762_e("weight");
        this.weight = Math.max(1, this.weight);
        this.lootEntry = new ArrayList();
        NBTTagList jRew = json.func_150295_c("rewards", 10);
        for (int i = 0; i < jRew.func_74745_c(); ++i) {
            NBTBase entry = jRew.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 10) continue;
            LootEntry loot = new LootEntry();
            loot.readFromJson((NBTTagCompound)entry);
            this.lootEntry.add(loot);
        }
    }

    public void writeToJson(NBTTagCompound json) {
        json.func_74778_a("name", this.name);
        json.func_74768_a("weight", this.weight);
        NBTTagList jRew = new NBTTagList();
        for (LootEntry entry : this.lootEntry) {
            if (entry == null) continue;
            NBTTagCompound jLoot = new NBTTagCompound();
            entry.writeToJson(jLoot);
            jRew.func_74742_a((NBTBase)jLoot);
        }
        json.func_74782_a("rewards", (NBTBase)jRew);
    }

    @Override
    public int compareTo(LootGroup group) {
        return (int)Math.signum(group.weight - this.weight);
    }

    public static class LootEntry
    implements Comparable<LootEntry> {
        public int weight = 1;
        public ArrayList<BigItemStack> items = new ArrayList();

        public void readFromJson(NBTTagCompound json) {
            this.weight = json.func_74762_e("weight");
            this.weight = Math.max(1, this.weight);
            this.items = new ArrayList();
            NBTTagList jItm = json.func_150295_c("items", 10);
            for (int i = 0; i < jItm.func_74745_c(); ++i) {
                BigItemStack stack;
                NBTBase entry = jItm.func_179238_g(i);
                if (entry == null || entry.func_74732_a() != 10 || (stack = JsonHelper.JsonToItemStack((NBTTagCompound)((NBTTagCompound)entry))) == null) continue;
                this.items.add(stack);
            }
        }

        public void writeToJson(NBTTagCompound json) {
            json.func_74768_a("weight", this.weight);
            NBTTagList jItm = new NBTTagList();
            for (BigItemStack stack : this.items) {
                jItm.func_74742_a((NBTBase)JsonHelper.ItemStackToJson((BigItemStack)stack, (NBTTagCompound)new NBTTagCompound()));
            }
            json.func_74782_a("items", (NBTBase)jItm);
        }

        @Override
        public int compareTo(LootEntry entry) {
            return (int)Math.signum(entry.weight - this.weight);
        }
    }
}

