/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.rewards;

import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import bq_standard.client.gui.rewards.GuiRewardScoreboard;
import bq_standard.core.BQ_Standard;
import bq_standard.rewards.factory.FactoryRewardScoreboard;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class RewardScoreboard
implements IReward {
    public String score = "Reputation";
    public String type = "dummy";
    public boolean relative = true;
    public int value = 1;

    public ResourceLocation getFactoryID() {
        return FactoryRewardScoreboard.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_standard.reward.scoreboard";
    }

    public boolean canClaim(EntityPlayer player, IQuest quest) {
        return true;
    }

    public void claimReward(EntityPlayer player, IQuest quest) {
        Scoreboard board = player.func_96123_co();
        if (board == null) {
            return;
        }
        ScoreObjective scoreObj = board.func_96518_b(this.score);
        if (scoreObj == null) {
            try {
                IScoreCriteria criteria = (IScoreCriteria)IScoreCriteria.field_96643_a.get(this.type);
                criteria = criteria != null ? criteria : new ScoreCriteria(this.score);
                scoreObj = board.func_96535_a(this.score, criteria);
                scoreObj.func_96681_a(this.score);
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to create score '" + this.score + "' for reward!", (Throwable)e);
            }
        }
        if (scoreObj == null || scoreObj.func_96680_c().func_96637_b()) {
            return;
        }
        Score s = board.func_96529_a(player.func_70005_c_(), scoreObj);
        if (this.relative) {
            s.func_96649_a(this.value);
        } else {
            s.func_96647_c(this.value);
        }
    }

    public void readFromNBT(NBTTagCompound json, EnumSaveType saveType) {
        this.score = json.func_74779_i("score");
        this.type = json.func_74779_i("type");
        this.value = json.func_74762_e("value");
        this.relative = json.func_74767_n("relative");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json, EnumSaveType saveType) {
        json.func_74778_a("score", this.score);
        json.func_74778_a("type", "dummy");
        json.func_74768_a("value", this.value);
        json.func_74757_a("relative", this.relative);
        return json;
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiEmbedded getRewardGui(int posX, int posY, int sizeX, int sizeY, IQuest quest) {
        return new GuiRewardScoreboard(this, posX, posY, sizeX, sizeY);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getRewardEditor(GuiScreen screen, IQuest quest) {
        return null;
    }

    public IJsonDoc getDocumentation() {
        return null;
    }
}

