/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.rewards;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import bq_standard.NBTReplaceUtil;
import bq_standard.client.gui.rewards.GuiRewardItem;
import bq_standard.core.BQ_Standard;
import bq_standard.rewards.factory.FactoryRewardItem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class RewardItem
implements IReward {
    public ArrayList<BigItemStack> items = new ArrayList();

    public ResourceLocation getFactoryID() {
        return FactoryRewardItem.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_standard.reward.item";
    }

    public boolean canClaim(EntityPlayer player, IQuest quest) {
        return true;
    }

    public void claimReward(EntityPlayer player, IQuest quest) {
        for (BigItemStack r : this.items) {
            BigItemStack stack = r.copy();
            for (ItemStack s : stack.getCombinedStacks()) {
                if (s.func_77978_p() != null) {
                    s.func_77982_d(NBTReplaceUtil.replaceStrings(s.func_77978_p(), "VAR_NAME", player.func_70005_c_()));
                    s.func_77982_d(NBTReplaceUtil.replaceStrings(s.func_77978_p(), "VAR_UUID", QuestingAPI.getQuestingUUID((EntityPlayer)player).toString()));
                }
                if (player.field_71071_by.func_70441_a(s)) continue;
                player.func_146097_a(s, true, false);
            }
        }
    }

    public void readFromNBT(NBTTagCompound json, EnumSaveType saveType) {
        this.items = new ArrayList();
        NBTTagList rList = json.func_150295_c("rewards", 10);
        for (int i = 0; i < rList.func_74745_c(); ++i) {
            NBTBase entry = rList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 10) continue;
            try {
                BigItemStack item = JsonHelper.JsonToItemStack((NBTTagCompound)((NBTTagCompound)entry));
                if (item == null) continue;
                this.items.add(item);
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load reward item data", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json, EnumSaveType saveType) {
        NBTTagList rJson = new NBTTagList();
        for (BigItemStack stack : this.items) {
            rJson.func_74742_a((NBTBase)JsonHelper.ItemStackToJson((BigItemStack)stack, (NBTTagCompound)new NBTTagCompound()));
        }
        json.func_74782_a("rewards", (NBTBase)rJson);
        return json;
    }

    public IGuiEmbedded getRewardGui(int posX, int posY, int sizeX, int sizeY, IQuest quest) {
        return new GuiRewardItem(this, posX, posY, sizeX, sizeY);
    }

    public GuiScreen getRewardEditor(GuiScreen screen, IQuest quest) {
        return null;
    }

    public IJsonDoc getDocumentation() {
        return null;
    }
}

