/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.IPacketHandler;
import bq_standard.core.BQ_Standard;
import bq_standard.network.StandardPacketType;
import bq_standard.rewards.loot.LootGroup;
import bq_standard.rewards.loot.LootRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.Level;

public class PktHandlerLootImport
implements IPacketHandler {
    public ResourceLocation getRegistryName() {
        return StandardPacketType.LOOT_IMPORT.GetLocation();
    }

    public void handleServer(NBTTagCompound tag, EntityPlayerMP sender) {
        if (sender == null) {
            return;
        }
        boolean isOP = sender.field_70170_p.func_73046_m().func_184103_al().func_152596_g(sender.func_146103_bH());
        if (!isOP) {
            BQ_Standard.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to import loot without OP permissions!");
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You need to be OP to edit loot!"));
            return;
        }
        NBTTagList list = tag.func_74775_l("data").func_150295_c("groups", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTBase je = list.func_179238_g(i);
            if (je == null || je.func_74732_a() != 10) continue;
            LootGroup group = new LootGroup();
            group.readFromJson((NBTTagCompound)je);
            LootRegistry.registerGroup(group);
        }
        LootRegistry.updateClients();
    }

    public void handleClient(NBTTagCompound tag) {
    }
}

