/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.items;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api.utils.BigItemStack;
import bq_standard.core.BQ_Standard;
import bq_standard.network.StandardPacketType;
import bq_standard.rewards.loot.LootGroup;
import bq_standard.rewards.loot.LootRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class ItemLootChest
extends Item {
    public ItemLootChest() {
        this.func_77625_d(1);
        this.func_77655_b("bq_standard.loot_chest");
        this.func_77637_a((CreativeTabs)QuestingAPI.getAPI((ApiKey)ApiReference.CREATIVE_TAB));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (stack.func_77952_i() >= 102) {
            if (((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).canUserEdit(player)) {
                player.openGui((Object)BQ_Standard.instance, 0, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            ArrayList<BigItemStack> loot;
            LootGroup group = stack.func_77952_i() == 101 ? LootRegistry.getWeightedGroup(field_77697_d.nextFloat(), field_77697_d) : LootRegistry.getWeightedGroup((float)MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)100) / 100.0f, field_77697_d);
            String title = "Dungeon Loot";
            if (group == null) {
                loot = LootRegistry.getStandardLoot(player);
            } else {
                title = group.name;
                loot = group.getRandomReward(field_77697_d);
                if (loot == null || loot.size() <= 0) {
                    BQ_Standard.logger.log(Level.WARN, "Unable to get random loot entry from group " + group.name + "! Reason: Contains 0 loot entries");
                    title = "Dungeon Loot";
                    loot = LootRegistry.getStandardLoot(player);
                }
            }
            for (BigItemStack s1 : loot) {
                for (ItemStack s2 : s1.getCombinedStacks()) {
                    if (player.field_71071_by.func_70441_a(s2)) continue;
                    player.func_146097_a(s2, true, false);
                }
                player.field_71071_by.func_70296_d();
                player.field_71069_bz.func_75142_b();
            }
            if (player instanceof EntityPlayerMP) {
                this.sendGui((EntityPlayerMP)player, loot, title);
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private void sendGui(EntityPlayerMP player, List<BigItemStack> loot, String title) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("title", title);
        NBTTagList list = new NBTTagList();
        for (BigItemStack stack : loot) {
            if (stack == null) continue;
            list.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        tags.func_74782_a("rewards", (NBTBase)list);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToPlayer(new QuestingPacket(StandardPacketType.LOOT_CLAIM.GetLocation(), tags), player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == CreativeTabs.field_78027_g || tab == this.func_77640_w()) {
            list.add((Object)new ItemStack((Item)this, 1, 0));
            list.add((Object)new ItemStack((Item)this, 1, 25));
            list.add((Object)new ItemStack((Item)this, 1, 50));
            list.add((Object)new ItemStack((Item)this, 1, 75));
            list.add((Object)new ItemStack((Item)this, 1, 100));
            list.add((Object)new ItemStack((Item)this, 1, 101));
            list.add((Object)new ItemStack((Item)this, 1, 102));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77952_i() > 101;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77952_i() > 101) {
            tooltip.add(I18n.func_135052_a((String)"betterquesting.btn.edit", (Object[])new Object[0]));
        } else if (((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue()) {
            if (stack.func_77952_i() == 101) {
                tooltip.add(I18n.func_135052_a((String)"bq_standard.tooltip.loot_chest", (Object[])new Object[]{"???"}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"bq_standard.tooltip.loot_chest", (Object[])new Object[]{MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)100) + "%"}));
            }
        }
    }
}

