/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.importers.hqm;

import betterquesting.api.client.importers.IImporter;
import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.FileExtensionFilter;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.storage.IDatabaseNBT;
import bq_standard.core.BQ_Standard;
import bq_standard.importers.hqm.HQMUtilities;
import bq_standard.importers.hqm.converters.rewards.HQMReward;
import bq_standard.importers.hqm.converters.rewards.HQMRewardChoice;
import bq_standard.importers.hqm.converters.rewards.HQMRewardCommand;
import bq_standard.importers.hqm.converters.rewards.HQMRewardReputation;
import bq_standard.importers.hqm.converters.rewards.HQMRewardStandard;
import bq_standard.importers.hqm.converters.tasks.HQMTask;
import bq_standard.importers.hqm.converters.tasks.HQMTaskCraft;
import bq_standard.importers.hqm.converters.tasks.HQMTaskDetect;
import bq_standard.importers.hqm.converters.tasks.HQMTaskKill;
import bq_standard.importers.hqm.converters.tasks.HQMTaskLocation;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import org.apache.logging.log4j.Level;

public class HQMQuestImporter
implements IImporter {
    public static HQMQuestImporter instance = new HQMQuestImporter();
    private static HashMap<String, HQMTask> taskConverters = new HashMap();
    private static HashMap<String, HQMReward> rewardConverters = new HashMap();
    public HashMap<Integer, String> reputations = new HashMap();
    private HashMap<String, IQuest> idMap = new HashMap();

    public FileFilter getFileFilter() {
        return new FileExtensionFilter(".json");
    }

    public String getUnlocalisedName() {
        return "bq_standard.importer.hqm_quest.name";
    }

    public String getUnlocalisedDescription() {
        return "bq_standard.importer.hqm_quest.desc";
    }

    public void loadFiles(IQuestDatabase questDB, IQuestLineDatabase lineDB, File[] files) {
        this.reputations.clear();
        this.idMap.clear();
        for (File selected : files) {
            if (selected == null || !selected.exists()) continue;
            JsonObject json = JsonHelper.ReadFromFile((File)selected);
            this.ImportQuestLine(questDB, lineDB, json);
        }
    }

    private void LoadReputations(JsonObject jsonRoot) {
        this.reputations.clear();
        int i = -1;
        for (JsonElement e : JsonHelper.GetArray((JsonObject)jsonRoot, (String)"reputation")) {
            JsonObject jRep;
            ++i;
            if (e == null || !e.isJsonObject() || !(jRep = e.getAsJsonObject()).has("name")) continue;
            this.reputations.put(i, JsonHelper.GetString((JsonObject)jRep, (String)"name", (String)("Reputation(" + i + ")")));
        }
    }

    private IQuest GetNewQuest(String oldID, IQuestDatabase qdb) {
        if (this.idMap.containsKey(oldID)) {
            return this.idMap.get(oldID);
        }
        IQuest quest = qdb.createNew(qdb.nextID());
        this.idMap.put(oldID, quest);
        return quest;
    }

    /*
     * Could not resolve type clashes
     */
    private void ImportQuestLine(IQuestDatabase questDB, IQuestLineDatabase lineDB, JsonObject json) {
        IQuestLine questLine = lineDB.createNew(lineDB.nextID());
        IPropertyContainer qlProps = questLine.getProperties();
        qlProps.setProperty(NativeProps.NAME, (Object)JsonHelper.GetString((JsonObject)json, (String)"name", (String)"HQM Quest Line"));
        qlProps.setProperty(NativeProps.DESC, (Object)JsonHelper.GetString((JsonObject)json, (String)"description", (String)"No description"));
        this.LoadReputations(json);
        JsonArray qlJson = JsonHelper.GetArray((JsonObject)json, (String)"quests");
        ArrayList<String> loadedQuests = new ArrayList<String>();
        for (int i = 0; i < qlJson.size(); ++i) {
            String idName;
            JsonElement element = qlJson.get(i);
            if (element == null || !element.isJsonObject()) continue;
            JsonObject jQuest = element.getAsJsonObject();
            String name = JsonHelper.GetString((JsonObject)jQuest, (String)"name", (String)"HQM Quest");
            String string = idName = jQuest.has("uuid") ? JsonHelper.GetString((JsonObject)jQuest, (String)"uuid", (String)name) : name;
            if (loadedQuests.contains(idName)) {
                int n = 1;
                while (loadedQuests.contains(idName + " (" + n + ")")) {
                    ++n;
                }
                BQ_Standard.logger.log(Level.WARN, "Found duplicate quest " + name + ". Any quests with this pre-requisite will need repair!");
                idName = name + " (" + n + ")";
            }
            loadedQuests.add(idName);
            IQuest quest = this.GetNewQuest(idName, questDB);
            IPropertyContainer qProps = quest.getProperties();
            qProps.setProperty(NativeProps.NAME, (Object)name);
            qProps.setProperty(NativeProps.DESC, (Object)JsonHelper.GetString((JsonObject)jQuest, (String)"description", (String)"No Description"));
            BigItemStack tmp = HQMUtilities.HQMStackT1(JsonHelper.GetObject((JsonObject)jQuest, (String)"icon"));
            if (tmp != null) {
                qProps.setProperty(NativeProps.ICON, (Object)tmp);
            } else {
                qProps.setProperty(NativeProps.ICON, (Object)new BigItemStack(Items.field_151156_bN));
            }
            if (json.has("repeat")) {
                JsonObject jRpt = JsonHelper.GetObject((JsonObject)jQuest, (String)"repeat");
                int rTime = 0;
                rTime += JsonHelper.GetNumber((JsonObject)jRpt, (String)"days", (Number)0).intValue() * 24000;
                qProps.setProperty(NativeProps.REPEAT_TIME, (Object)(rTime += JsonHelper.GetNumber((JsonObject)jRpt, (String)"hours", (Number)0).intValue() * 1000));
            }
            for (JsonElement er : JsonHelper.GetArray((JsonObject)jQuest, (String)"prerequisites")) {
                String[] nParts;
                if (er == null || !er.isJsonPrimitive() || !er.getAsJsonPrimitive().isString()) continue;
                String id = er.getAsJsonPrimitive().getAsString();
                if (id.startsWith("{") && id.contains("[") && (nParts = id.split("\\[")).length > 1) {
                    id = nParts[1].replaceFirst("]", "");
                }
                IQuest preReq = this.GetNewQuest(id, questDB);
                quest.getPrerequisites().add(preReq);
            }
            for (JsonElement jt : JsonHelper.GetArray((JsonObject)jQuest, (String)"tasks")) {
                JsonObject jTask;
                String tType;
                if (jt == null || !jt.isJsonObject() || (tType = JsonHelper.GetString((JsonObject)(jTask = jt.getAsJsonObject()), (String)"type", (String)"")) == null || tType.length() <= 0) continue;
                if (!taskConverters.containsKey(tType)) {
                    BQ_Standard.logger.log(Level.WARN, "Unidentified HQM task '" + tType + "'! Please report this so that it can be supported in future builds");
                    continue;
                }
                List<ITask> tsks = taskConverters.get(tType).Convert(jTask);
                if (tsks == null || tsks.size() <= 0) continue;
                IDatabaseNBT taskReg = quest.getTasks();
                for (ITask t : tsks) {
                    taskReg.add(taskReg.nextID(), (Object)t);
                }
            }
            for (Map.Entry entry : rewardConverters.entrySet()) {
                List<IReward> rews;
                if (!jQuest.has((String)entry.getKey()) || (rews = ((HQMReward)entry.getValue()).Convert(jQuest.get((String)entry.getKey()))) == null || rews.size() <= 0) continue;
                IDatabaseNBT rewardReg = quest.getRewards();
                for (IReward r : rews) {
                    rewardReg.add(rewardReg.nextID(), (Object)r);
                }
            }
            if (questLine.getValue(questDB.getID((Object)quest)) != null) {
                BQ_Standard.logger.log(Level.WARN, "Tried to add duplicate quest " + quest + " to quest line " + questLine.getUnlocalisedName());
                continue;
            }
            IQuestLineEntry qle = questLine.createNewEntry(questDB.getID((Object)quest));
            qle.setPosition(JsonHelper.GetNumber((JsonObject)jQuest, (String)"x", (Number)0).intValue(), JsonHelper.GetNumber((JsonObject)jQuest, (String)"y", (Number)0).intValue());
        }
    }

    static {
        taskConverters.put("DETECT", new HQMTaskDetect(false));
        taskConverters.put("CONSUME", new HQMTaskDetect(true));
        taskConverters.put("CONSUME_QDS", new HQMTaskDetect(true));
        taskConverters.put("KILL", new HQMTaskKill());
        taskConverters.put("LOCATION", new HQMTaskLocation());
        taskConverters.put("CRAFT", new HQMTaskCraft());
        rewardConverters.put("reward", new HQMRewardStandard());
        rewardConverters.put("rewardchoice", new HQMRewardChoice());
        rewardConverters.put("reputationrewards", new HQMRewardReputation());
        rewardConverters.put("commandrewards", new HQMRewardCommand());
    }
}

