/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.importers;

import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api2.storage.DBEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuestMergeUtility {
    private final IQuestDatabase questDB;
    private final IQuestLineDatabase lineDB;

    public QuestMergeUtility(IQuestDatabase questDB, IQuestLineDatabase lineDB) {
        this.questDB = questDB;
        this.lineDB = lineDB;
    }

    public void merge(IQuestDatabase qdb, IQuestLineDatabase ldb) {
        HashMap<Integer, Integer> remapped = this.getRemappedIDs(this.stripKeys(qdb.getEntries()));
        for (Map.Entry<Integer, Integer> entry : remapped.entrySet()) {
            this.questDB.add(entry.getValue().intValue(), qdb.getValue(entry.getKey().intValue()));
        }
        for (DBEntry questLine : ldb.getEntries()) {
            for (DBEntry qle : ((IQuestLine)questLine.getValue()).getEntries()) {
                int oldID = qle.getID();
                ((IQuestLine)questLine.getValue()).removeID(oldID);
                ((IQuestLine)questLine.getValue()).add(remapped.get(oldID).intValue(), qle.getValue());
            }
            this.lineDB.add(this.lineDB.nextID(), questLine.getValue());
        }
    }

    private HashMap<Integer, Integer> getRemappedIDs(List<Integer> idList) {
        List<Integer> existing = this.stripKeys(this.questDB.getEntries());
        HashMap<Integer, Integer> remapped = new HashMap<Integer, Integer>();
        int n = 0;
        for (int id : idList) {
            while (existing.contains(n) || remapped.containsValue(n)) {
                ++n;
            }
            remapped.put(id, n);
        }
        return remapped;
    }

    private List<Integer> stripKeys(DBEntry[] entries) {
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        for (DBEntry e : entries) {
            keyList.add(e.getID());
        }
        return keyList;
    }
}

