/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.importers;

import betterquesting.api.client.importers.IImporter;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.utils.FileExtensionFilter;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import bq_standard.importers.ImportedQuestLines;
import bq_standard.importers.ImportedQuests;
import bq_standard.importers.QuestMergeUtility;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileFilter;
import net.minecraft.nbt.NBTTagCompound;

public class NativeFileImporter
implements IImporter {
    public static NativeFileImporter instance = new NativeFileImporter();

    public String getUnlocalisedName() {
        return "bq_standard.importer.nat_file.name";
    }

    public String getUnlocalisedDescription() {
        return "bq_standard.importer.nat_file.desc";
    }

    public FileFilter getFileFilter() {
        return new FileExtensionFilter(".json");
    }

    public void loadFiles(IQuestDatabase questDB, IQuestLineDatabase lineDB, File[] files) {
        QuestMergeUtility mergeUtil = new QuestMergeUtility(questDB, lineDB);
        for (File selected : files) {
            if (selected == null || !selected.exists()) continue;
            NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object((JsonObject)JsonHelper.ReadFromFile((File)selected), (NBTTagCompound)new NBTTagCompound(), (boolean)true);
            ImportedQuests impQ = new ImportedQuests(questDB);
            ImportedQuestLines impL = new ImportedQuestLines(lineDB);
            impQ.readFromNBT(nbt.func_150295_c("questDatabase", 10), EnumSaveType.CONFIG);
            impL.readFromNBT(nbt.func_150295_c("questLines", 10), EnumSaveType.CONFIG);
            mergeUtil.merge(impQ, impL);
        }
    }
}

