/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.importers;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.api2.utils.QuestLineSorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ImportedQuestLines
extends SimpleDatabase<IQuestLine>
implements IQuestLineDatabase {
    private final List<Integer> lineOrder = new ArrayList<Integer>();
    private final IQuestLineDatabase parent;
    private final QuestLineSorter SORTER = new QuestLineSorter((IQuestLineDatabase)this);

    public ImportedQuestLines(IQuestLineDatabase parent) {
        this.parent = parent;
    }

    public int getOrderIndex(int lineID) {
        if (this.getValue(lineID) == null) {
            return -1;
        }
        if (!this.lineOrder.contains(lineID)) {
            this.lineOrder.add(lineID);
        }
        return this.lineOrder.indexOf(lineID);
    }

    public void setOrderIndex(int lineID, int index) {
        this.lineOrder.remove((Object)lineID);
        this.lineOrder.add(index, lineID);
    }

    public DBEntry<IQuestLine>[] getSortedEntries() {
        DBEntry[] ary = this.getEntries();
        Arrays.sort(ary, this.SORTER);
        return ary;
    }

    public NBTTagList writeToNBT(NBTTagList json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return json;
        }
        for (DBEntry entry : this.getEntries()) {
            if (entry.getValue() == null) continue;
            int id = entry.getID();
            NBTTagCompound jObj = (NBTTagCompound)((IQuestLine)entry.getValue()).writeToNBT((NBTBase)new NBTTagCompound(), saveType);
            jObj.func_74768_a("lineID", id);
            jObj.func_74768_a("order", this.getOrderIndex(id));
            json.func_74742_a((NBTBase)jObj);
        }
        return json;
    }

    public void readFromNBT(NBTTagList json, EnumSaveType saveType) {
        if (saveType != EnumSaveType.CONFIG) {
            return;
        }
        this.reset();
        HashMap<Integer, Integer> orderMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            int order;
            NBTBase entry = json.func_179238_g(i);
            if (entry.func_74732_a() != 10) continue;
            NBTTagCompound jql = (NBTTagCompound)entry;
            int id = jql.func_150297_b("lineID", 99) ? jql.func_74762_e("lineID") : -1;
            int n = order = jql.func_150297_b("order", 99) ? jql.func_74762_e("order") : -1;
            if (id < 0) continue;
            IQuestLine line = this.createNew(id);
            line.readFromNBT((NBTBase)jql, saveType);
            if (order < 0) continue;
            orderMap.put(order, id);
        }
        ArrayList orderKeys = new ArrayList(orderMap.keySet());
        Collections.sort(orderKeys);
        this.lineOrder.clear();
        Iterator iterator = orderKeys.iterator();
        while (iterator.hasNext()) {
            int o = (Integer)iterator.next();
            this.lineOrder.add((Integer)orderMap.get(o));
        }
    }

    public QuestingPacket getSyncPacket() {
        return null;
    }

    public void readPacket(NBTTagCompound payload) {
    }

    public void removeQuest(int questID) {
        for (DBEntry ql : this.getEntries()) {
            ((IQuestLine)ql.getValue()).removeID(questID);
        }
    }

    public IQuestLine createNew(int id) {
        IQuestLine ql = this.parent.createNew(id);
        this.parent.removeID(id);
        this.add(id, ql);
        ql.setParentDatabase((IQuestLineDatabase)this);
        return ql;
    }
}

