/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.QuestCache;
import bq_standard.handlers.ConfigHandler;
import bq_standard.tasks.TaskBlockBreak;
import bq_standard.tasks.TaskCrafting;
import bq_standard.tasks.TaskHunt;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class EventHandler {
    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.player == null || event.player.field_70170_p.field_72995_K) {
            return;
        }
        for (Map.Entry entry : QuestCache.INSTANCE.getActiveTasks(QuestingAPI.getQuestingUUID((EntityPlayer)event.player), TaskCrafting.class).entrySet()) {
            ((TaskCrafting)entry.getKey()).onItemCrafted((IQuest)entry.getValue(), event.player, event.crafting.func_77946_l());
        }
    }

    @SubscribeEvent
    public void onItemSmelted(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player == null || event.player.field_70170_p.field_72995_K) {
            return;
        }
        for (Map.Entry entry : QuestCache.INSTANCE.getActiveTasks(QuestingAPI.getQuestingUUID((EntityPlayer)event.player), TaskCrafting.class).entrySet()) {
            ((TaskCrafting)entry.getKey()).onItemSmelted((IQuest)entry.getValue(), event.player, event.smelting.func_77946_l());
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        if (event.getSource() == null || !(event.getSource().func_76346_g() instanceof EntityPlayer) || event.getSource().func_76346_g().field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        for (Map.Entry entry : QuestCache.INSTANCE.getActiveTasks(QuestingAPI.getQuestingUUID((EntityPlayer)player), TaskHunt.class).entrySet()) {
            ((TaskHunt)entry.getKey()).onKilledByPlayer((IQuest)entry.getValue(), event.getEntityLiving(), event.getSource());
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null || event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        for (Map.Entry entry : QuestCache.INSTANCE.getActiveTasks(QuestingAPI.getQuestingUUID((EntityPlayer)event.getPlayer()), TaskBlockBreak.class).entrySet()) {
            ((TaskBlockBreak)entry.getKey()).onBlockBreak((IQuest)entry.getValue(), event.getPlayer(), event.getState(), event.getPos());
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("bq_standard")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }
}

