/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.lists.GuiScrollingItems;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.BigItemStack;
import bq_standard.tasks.TaskRetrieval;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;

public class GuiTaskRetrieval
extends GuiElement
implements IGuiEmbedded {
    GuiScrollingItems scrollList;
    IQuest quest;
    TaskRetrieval task;
    private Minecraft mc = Minecraft.func_71410_x();
    private int posX = 0;
    private int posY = 0;

    public GuiTaskRetrieval(TaskRetrieval task, IQuest quest, int posX, int posY, int sizeX, int sizeY) {
        this.task = task;
        this.posX = posX;
        this.posY = posY;
        this.scrollList = new GuiScrollingItems(this.mc, posX, posY + 16, sizeX, sizeY - 16);
        if (task == null) {
            return;
        }
        int[] progress = quest == null || (Boolean)quest.getProperties().getProperty(NativeProps.GLOBAL) == false ? task.getPartyProgress(QuestingAPI.getQuestingUUID((EntityPlayer)this.mc.field_71439_g)) : task.getGlobalProgress();
        for (int i = 0; i < task.requiredItems.size(); ++i) {
            BigItemStack stack = task.requiredItems.get(i);
            if (stack == null) continue;
            String txt = stack.getBaseStack().func_82833_r();
            if (stack.oreDict.length() > 0) {
                txt = txt + " (" + stack.oreDict + ")";
            }
            txt = txt + "\n";
            txt = task.consume ? txt + progress[i] + "/" + stack.stackSize : txt + stack.stackSize;
            txt = progress[i] >= stack.stackSize || task.isComplete(QuestingAPI.getQuestingUUID((EntityPlayer)this.mc.field_71439_g)) ? txt + "\n" + TextFormatting.GREEN + I18n.func_135052_a((String)"betterquesting.tooltip.complete", (Object[])new Object[0]) : txt + "\n" + TextFormatting.RED + I18n.func_135052_a((String)"betterquesting.tooltip.incomplete", (Object[])new Object[0]);
            this.scrollList.addItem(stack, txt);
        }
    }

    public void drawBackground(int mx, int my, float partialTick) {
        String sCon = (this.task.consume ? TextFormatting.RED : TextFormatting.GREEN) + I18n.func_135052_a((String)(this.task.consume ? "gui.yes" : "gui.no"), (Object[])new Object[0]);
        this.mc.field_71466_p.func_175065_a(I18n.func_135052_a((String)"bq_standard.btn.consume", (Object[])new Object[]{sCon}), (float)this.posX, (float)this.posY, GuiTaskRetrieval.getTextColor(), false);
        this.scrollList.drawBackground(mx, my, partialTick);
    }

    public void drawForeground(int mx, int my, float partialTick) {
        this.scrollList.drawForeground(mx, my, partialTick);
    }

    public void onMouseClick(int mx, int my, int click) {
    }

    public void onMouseScroll(int mx, int my, int scroll) {
    }

    public void onKeyTyped(char c, int keyCode) {
    }
}

