/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.utils.RenderUtils;
import bq_standard.tasks.TaskLocation;
import java.awt.Color;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;

public class GuiTaskLocation
extends GuiElement
implements IGuiEmbedded {
    static HashMap<Integer, String> dimNameCache;
    TaskLocation task;
    private Minecraft mc = Minecraft.func_71410_x();
    private int posX = 0;
    private int posY = 0;
    private int sizeX = 0;
    private int sizeY = 0;

    public GuiTaskLocation(TaskLocation task, int posX, int posY, int sizeX, int sizeY) {
        this.task = task;
        this.posX = posX;
        this.posY = posY;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    public void drawBackground(int mx, int my, float partialTick) {
        double la = Math.atan2((double)this.task.z - this.mc.field_71439_g.field_70161_v, (double)this.task.x - this.mc.field_71439_g.field_70165_t);
        int radius = Math.min(this.sizeY / 2, this.sizeX / 4) - 12;
        int dx = (int)(Math.cos(la) * (double)radius);
        int dy = (int)(Math.sin(la) * (double)(-radius));
        int cx = this.posX + this.sizeX - radius - 12;
        int cy = this.posY + this.sizeY / 2;
        int i = this.sizeY / 2 - radius;
        this.mc.field_71466_p.func_175065_a(this.task.name, (float)this.posX, (float)(this.posY + i), GuiTaskLocation.getTextColor(), false);
        i += 12;
        if (!this.task.hideInfo) {
            if (this.task.range >= 0) {
                this.mc.field_71466_p.func_175065_a(I18n.func_135052_a((String)"bq_standard.gui.location", (Object[])new Object[]{"(" + this.task.x + ", " + this.task.y + ", " + this.task.z + ")"}), (float)this.posX, (float)(this.posY + i), GuiTaskLocation.getTextColor(), false);
                this.mc.field_71466_p.func_175065_a(I18n.func_135052_a((String)"bq_standard.gui.distance", (Object[])new Object[]{(int)this.mc.field_71439_g.func_70011_f((double)this.task.x, (double)this.task.y, (double)this.task.z) + "m"}), (float)this.posX, (float)(this.posY + (i += 12)), GuiTaskLocation.getTextColor(), false);
                i += 12;
            }
            this.mc.field_71466_p.func_175065_a(I18n.func_135052_a((String)"bq_standard.gui.dimension", (Object[])new Object[]{GuiTaskLocation.getDimName(this.task.dim)}), (float)this.posX, (float)(this.posY + i), GuiTaskLocation.getTextColor(), false);
            i += 12;
        }
        if (this.task.isComplete(QuestingAPI.getQuestingUUID((EntityPlayer)this.mc.field_71439_g))) {
            this.mc.field_71466_p.func_175065_a(I18n.func_135052_a((String)"bq_standard.gui.found", (Object[])new Object[0]), (float)this.posX, (float)(this.posY + i), Color.GREEN.getRGB(), false);
        } else {
            this.mc.field_71466_p.func_175065_a(TextFormatting.BOLD + I18n.func_135052_a((String)"bq_standard.gui.undiscovered", (Object[])new Object[0]), (float)this.posX, (float)(this.posY + i), Color.RED.getRGB(), true);
        }
        Gui.func_73734_a((int)(cx - radius), (int)(cy - radius), (int)(cx + radius), (int)(cy + radius), (int)Color.BLACK.getRGB());
        RenderUtils.DrawLine((int)(cx - radius), (int)(cy - radius), (int)(cx + radius), (int)(cy - radius), (float)4.0f, (int)Color.WHITE.getRGB());
        RenderUtils.DrawLine((int)(cx - radius), (int)(cy - radius), (int)(cx - radius), (int)(cy + radius), (float)4.0f, (int)Color.WHITE.getRGB());
        RenderUtils.DrawLine((int)(cx + radius), (int)(cy + radius), (int)(cx + radius), (int)(cy - radius), (float)4.0f, (int)Color.WHITE.getRGB());
        RenderUtils.DrawLine((int)(cx + radius), (int)(cy + radius), (int)(cx - radius), (int)(cy + radius), (float)4.0f, (int)Color.WHITE.getRGB());
        this.mc.field_71466_p.func_78276_b(TextFormatting.BOLD + "N", cx - 4, cy - radius - 9, GuiTaskLocation.getTextColor());
        this.mc.field_71466_p.func_78276_b(TextFormatting.BOLD + "S", cx - 4, cy + radius + 2, GuiTaskLocation.getTextColor());
        this.mc.field_71466_p.func_78276_b(TextFormatting.BOLD + "E", cx + radius + 2, cy - 4, GuiTaskLocation.getTextColor());
        this.mc.field_71466_p.func_78276_b(TextFormatting.BOLD + "W", cx - radius - 8, cy - 4, GuiTaskLocation.getTextColor());
        if (this.task.hideInfo || this.task.range < 0 || this.mc.field_71439_g.field_71093_bK != this.task.dim) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            this.mc.field_71466_p.func_78276_b(TextFormatting.BOLD + "?", cx / 2 - 4, cy / 2 - 4, Color.RED.getRGB());
            GlStateManager.func_179121_F();
        } else {
            RenderUtils.DrawLine((int)cx, (int)cy, (int)(cx + dx), (int)(cy - dy), (float)4.0f, (int)Color.RED.getRGB());
        }
    }

    public static String getDimName(int dim) {
        String name;
        if (dimNameCache == null) {
            Integer[] dimNums;
            dimNameCache = new HashMap();
            for (Integer i : dimNums = DimensionManager.getStaticDimensionIDs()) {
                try {
                    WorldProvider prov = DimensionManager.createProviderFor((int)i);
                    if (prov == null) continue;
                    dimNameCache.put(i, prov.func_186058_p().func_186065_b());
                }
                catch (Exception e) {
                    dimNameCache.put(i, "ERROR");
                }
            }
        }
        return (name = dimNameCache.get(dim)) != null ? name : "?";
    }

    public void drawForeground(int mx, int my, float partialTick) {
    }

    public void onMouseClick(int mx, int my, int click) {
    }

    public void onMouseScroll(int mx, int my, int scroll) {
    }

    public void onKeyTyped(char c, int keyCode) {
    }
}

