/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.lists.GuiScrollingItems;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.BigItemStack;
import bq_standard.tasks.TaskBlockBreak;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;

public class GuiTaskBlockBreak
extends GuiElement
implements IGuiEmbedded {
    private GuiScrollingItems scrollList;
    private Minecraft mc = Minecraft.func_71410_x();

    public GuiTaskBlockBreak(TaskBlockBreak task, IQuest quest, int posX, int posY, int sizeX, int sizeY) {
        this.scrollList = new GuiScrollingItems(this.mc, posX, posY + 16, sizeX, sizeY - 16);
        if (task == null) {
            return;
        }
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.mc.field_71439_g);
        int[] progress = quest == null || (Boolean)quest.getProperties().getProperty(NativeProps.GLOBAL) == false ? task.getPartyProgress(playerID) : task.getGlobalProgress();
        for (int i = 0; i < task.blockTypes.size(); ++i) {
            BigItemStack stack = task.blockTypes.get(i).getItemStack();
            if (stack == null) continue;
            String txt = stack.getBaseStack().func_82833_r();
            if (stack.oreDict.length() > 0) {
                txt = txt + " (" + stack.oreDict + ")";
            }
            txt = txt + "\n";
            txt = txt + progress[i] + "/" + stack.stackSize;
            txt = progress[i] >= stack.stackSize || task.isComplete(playerID) ? txt + "\n" + TextFormatting.GREEN + I18n.func_135052_a((String)"betterquesting.tooltip.complete", (Object[])new Object[0]) : txt + "\n" + TextFormatting.RED + I18n.func_135052_a((String)"betterquesting.tooltip.incomplete", (Object[])new Object[0]);
            this.scrollList.addItem(stack, txt);
        }
    }

    public void drawBackground(int mx, int my, float partialTick) {
        this.scrollList.drawBackground(mx, my, partialTick);
    }

    public void drawForeground(int mx, int my, float partialTick) {
        this.scrollList.drawForeground(mx, my, partialTick);
    }

    public void onMouseClick(int mx, int my, int click) {
    }

    public void onMouseScroll(int mx, int my, int scroll) {
    }

    public void onKeyTyped(char c, int keyCode) {
    }
}

