/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.editors;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.controls.GuiNumberField;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.utils.RenderUtils;
import bq_standard.client.gui.editors.GuiLootEntryEditor;
import bq_standard.network.StandardPacketType;
import bq_standard.rewards.loot.LootGroup;
import bq_standard.rewards.loot.LootRegistry;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiLootGroupEditor
extends GuiScreenThemed
implements IVolatileScreen {
    GuiTextField lineTitle;
    GuiNumberField lineWeight;
    LootGroup selected;
    int selIndex = -1;
    int leftScroll = 0;
    int maxRows = 0;

    public GuiLootGroupEditor(GuiScreen parent) {
        super(parent, "bq_standard.title.edit_loot_groups");
    }

    public void func_73866_w_() {
        GuiButtonThemed btn;
        int i;
        super.func_73866_w_();
        if (this.selected != null && !LootRegistry.updateUI) {
            this.SendChanges();
        }
        this.maxRows = (this.sizeY - 80) / 20;
        int btnWidth = this.sizeX / 2 - 16;
        int sx = this.sizeX - 32;
        this.lineTitle = new GuiTextField(0, this.field_146297_k.field_71466_p, this.guiLeft + this.sizeX / 2 + 9, this.field_146295_m / 2 - 59, btnWidth - 18, 18);
        this.lineTitle.func_146203_f(Integer.MAX_VALUE);
        this.lineWeight = new GuiNumberField(this.field_146297_k.field_71466_p, this.guiLeft + this.sizeX / 2 + 9, this.field_146295_m / 2 - 19, btnWidth / 2 - 10, 18);
        this.lineWeight.func_146203_f(Integer.MAX_VALUE);
        this.field_146292_n.add(new GuiButtonThemed(1, this.guiLeft + 16 + sx / 4 - 50, this.guiTop + this.sizeY - 48, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.new", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonThemed(2, this.guiLeft + 16 + sx / 4 * 3 - 75, this.guiTop + this.sizeY / 2 + 20, 150, 20, I18n.func_135052_a((String)"bq_standard.btn.add_remove_drops", (Object[])new Object[0])));
        for (i = 0; i < this.maxRows; ++i) {
            btn = new GuiButtonThemed(this.field_146292_n.size(), this.guiLeft + 36, this.guiTop + 32 + i * 20, btnWidth - 36, 20, "NULL");
            this.field_146292_n.add(btn);
        }
        for (i = 0; i < this.maxRows; ++i) {
            btn = new GuiButtonThemed(this.field_146292_n.size(), this.guiLeft + 16, this.guiTop + 32 + i * 20, 20, 20, "" + TextFormatting.RED + TextFormatting.BOLD + "x");
            this.field_146292_n.add(btn);
        }
        this.RefreshColumns();
    }

    public void func_73863_a(int mx, int my, float partialTick) {
        int s;
        super.func_73863_a(mx, my, partialTick);
        if (LootRegistry.updateUI) {
            this.RefreshColumns();
            LootRegistry.updateUI = false;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.currentTheme().getGuiTexture());
        this.func_73729_b(this.guiLeft + this.sizeX / 2 - 16, this.guiTop + 32, 248, 0, 8, 20);
        for (s = 20; s < (this.maxRows - 1) * 20; s += 20) {
            this.func_73729_b(this.guiLeft + this.sizeX / 2 - 16, this.guiTop + 32 + s, 248, 20, 8, 20);
        }
        this.func_73729_b(this.guiLeft + this.sizeX / 2 - 16, this.guiTop + 32 + s, 248, 40, 8, 20);
        this.func_73729_b(this.guiLeft + this.sizeX / 2 - 16, this.guiTop + 32 + (int)Math.max(0.0f, (float)s * (float)this.leftScroll / (float)(LootRegistry.lootGroups.size() - this.maxRows)), 248, 60, 8, 20);
        RenderUtils.DrawLine((int)(this.field_146294_l / 2), (int)(this.guiTop + 32), (int)(this.field_146294_l / 2), (int)(this.guiTop + this.sizeY - 48), (float)2.0f, (int)this.getTextColor());
        this.field_146297_k.field_71466_p.func_175065_a(I18n.func_135052_a((String)"betterquesting.gui.name", (Object[])new Object[0]), (float)(this.guiLeft + this.sizeX / 2 + 8), (float)(this.guiTop + this.sizeY / 2 - 72), this.getTextColor(), false);
        this.field_146297_k.field_71466_p.func_175065_a(I18n.func_135052_a((String)"bq_standard.gui.weight", (Object[])new Object[0]), (float)(this.guiLeft + this.sizeX / 2 + 8), (float)(this.guiTop + this.sizeY / 2 - 32), this.getTextColor(), false);
        if (this.selected != null) {
            this.field_146297_k.field_71466_p.func_175065_a("" + new DecimalFormat("0.##").format((float)this.selected.weight / (float)LootRegistry.getTotalWeight() * 100.0f) + "%", (float)(this.guiLeft + 16 + (this.sizeX - 32) / 4 * 3 + 8), (float)(this.guiTop + this.sizeY / 2 - 14), this.getTextColor(), false);
        }
        this.lineTitle.func_146194_f();
        this.lineWeight.func_146194_f();
    }

    public void SendChanges() {
        NBTTagCompound json = new NBTTagCompound();
        LootRegistry.writeToJson(json);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("ID", 1);
        tags.func_74782_a("Database", (NBTBase)json);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToServer(new QuestingPacket(StandardPacketType.LOOT_SYNC.GetLocation(), tags));
    }

    public void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (btn.field_146127_k == 1) {
            LootRegistry.lootGroups.add(new LootGroup());
            this.SendChanges();
            this.RefreshColumns();
        } else if (btn.field_146127_k == 2) {
            if (this.selected != null) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiLootEntryEditor((GuiScreen)this, this.selected));
            }
        } else if (btn.field_146127_k > 2) {
            int n1 = btn.field_146127_k - 3;
            int n2 = n1 / this.maxRows;
            int n3 = n1 % this.maxRows + this.leftScroll;
            if (n2 == 0) {
                if (n3 >= 0 && n3 < LootRegistry.lootGroups.size()) {
                    this.selected = LootRegistry.lootGroups.get(n3);
                    this.selIndex = n3;
                } else {
                    this.selected = null;
                    this.selIndex = -1;
                }
                this.RefreshColumns();
            } else if (n2 == 1 && n3 >= 0 && n3 < LootRegistry.lootGroups.size()) {
                LootRegistry.lootGroups.remove(n3);
                this.SendChanges();
            }
        }
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        super.func_73869_a(character, keyCode);
        if (this.selected != null) {
            this.lineWeight.func_146201_a(character, keyCode);
            this.lineTitle.func_146201_a(character, keyCode);
        }
    }

    protected void func_73864_a(int mx, int my, int click) throws IOException {
        super.func_73864_a(mx, my, click);
        this.lineTitle.func_146192_a(mx, my, click);
        this.lineWeight.func_146192_a(mx, my, click);
        if (this.selected != null) {
            boolean flag = false;
            if (!this.lineTitle.func_146206_l() && !this.lineTitle.func_146179_b().equals(this.selected.name)) {
                this.selected.name = this.lineTitle.func_146179_b();
                flag = true;
            }
            if (!this.lineWeight.func_146206_l() && this.lineWeight.getNumber().intValue() != this.selected.weight) {
                this.selected.weight = this.lineWeight.getNumber().intValue();
                flag = true;
            }
            if (flag) {
                this.SendChanges();
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mx = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int my = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int SDX = (int)(-Math.signum(Mouse.getEventDWheel()));
        if (SDX != 0 && this.isWithin(mx, my, this.guiLeft, this.guiTop, this.sizeX / 2, this.sizeY)) {
            this.leftScroll = Math.max(0, MathHelper.func_76125_a((int)(this.leftScroll + SDX), (int)0, (int)(LootRegistry.lootGroups.size() - this.maxRows)));
            this.RefreshColumns();
        }
    }

    public void RefreshColumns() {
        this.leftScroll = Math.max(0, MathHelper.func_76125_a((int)this.leftScroll, (int)0, (int)(LootRegistry.lootGroups.size() - this.maxRows)));
        if (this.selected != null && !LootRegistry.lootGroups.contains(this.selected)) {
            if (this.selIndex >= 0 && this.selIndex < LootRegistry.lootGroups.size()) {
                this.selected = LootRegistry.lootGroups.get(this.selIndex);
            } else {
                this.selected = null;
                this.selIndex = -1;
            }
        }
        List btnList = this.field_146292_n;
        for (int i = 3; i < btnList.size(); ++i) {
            GuiButton btn = (GuiButton)btnList.get(i);
            int n1 = btn.field_146127_k - 3;
            int n2 = n1 / this.maxRows;
            int n3 = n1 % this.maxRows + this.leftScroll;
            if (n2 == 0) {
                if (n3 >= 0 && n3 < LootRegistry.lootGroups.size()) {
                    btn.field_146126_j = I18n.func_135052_a((String)LootRegistry.lootGroups.get((int)n3).name, (Object[])new Object[0]);
                    btn.field_146125_m = true;
                    btn.field_146124_l = true;
                    continue;
                }
                btn.field_146126_j = "NULL";
                btn.field_146125_m = false;
                btn.field_146124_l = false;
                continue;
            }
            if (n2 != 1) continue;
            btn.field_146125_m = n3 >= 0 && n3 < LootRegistry.lootGroups.size();
            btn.field_146124_l = btn.field_146125_m;
        }
        if (this.selected == null) {
            this.lineTitle.func_146180_a("");
            this.lineTitle.func_146184_c(false);
            this.lineWeight.func_146180_a("");
            this.lineWeight.func_146184_c(false);
        } else {
            this.lineTitle.func_146180_a(this.selected.name);
            this.lineTitle.func_146184_c(true);
            this.lineWeight.func_146180_a("" + this.selected.weight);
            this.lineWeight.func_146184_c(true);
        }
    }
}

