/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui;

import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.lists.GuiScrollingBase;
import betterquesting.api.client.gui.lists.IScrollingEntry;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class GuiScrollingItemsSmall
extends GuiScrollingBase<ScrollingEntryItem> {
    private final Minecraft mc;

    public GuiScrollingItemsSmall(Minecraft mc, int x, int y, int w, int h) {
        super(mc, x, y, w, h);
        this.mc = mc;
        this.allowDragScroll(true);
    }

    public void addItem(BigItemStack stack) {
        this.addItem(stack, stack.getBaseStack().func_82833_r());
    }

    public void addItem(BigItemStack stack, String description) {
        this.getEntryList().add(new ScrollingEntryItem(this.mc, stack, description));
    }

    public static class ScrollingEntryItem
    extends GuiElement
    implements IScrollingEntry {
        private final Minecraft mc;
        private BigItemStack stack;
        private String desc = "";
        private NonNullList<ItemStack> subStacks = NonNullList.func_191196_a();

        public ScrollingEntryItem(Minecraft mc, BigItemStack stack, String desc) {
            this.mc = mc;
            this.stack = stack;
            this.setDescription(desc);
            if (stack == null) {
                return;
            }
            if (stack.oreDict != null && stack.oreDict.length() > 0) {
                for (ItemStack oreStack : OreDictionary.getOres((String)stack.oreDict)) {
                    if (oreStack == null) continue;
                    Item oItem = oreStack.func_77973_b();
                    NonNullList tmp = NonNullList.func_191196_a();
                    if (oreStack.func_77952_i() == Short.MAX_VALUE) {
                        oItem.func_150895_a(CreativeTabs.field_78027_g, tmp);
                    }
                    if (tmp.size() <= 0) {
                        if (this.subStacks.contains((Object)oreStack)) continue;
                        this.subStacks.add((Object)oreStack.func_77946_l());
                        continue;
                    }
                    for (ItemStack s : tmp) {
                        if (this.subStacks.contains((Object)s)) continue;
                        this.subStacks.add((Object)s.func_77946_l());
                    }
                }
            } else if (stack.getBaseStack().func_77952_i() == Short.MAX_VALUE) {
                stack.getBaseStack().func_77973_b().func_150895_a(CreativeTabs.field_78027_g, this.subStacks);
            }
            if (this.subStacks.size() <= 0) {
                this.subStacks.add((Object)stack.getBaseStack());
            }
        }

        public void setDescription(String desc) {
            this.desc = desc == null ? "" : desc;
        }

        public void drawBackground(int mx, int my, int px, int py, int width) {
            GlStateManager.func_179094_E();
            RenderUtils.DrawLine((int)px, (int)py, (int)(px + width), (int)py, (float)1.0f, (int)ScrollingEntryItem.getTextColor());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)px, (float)py, (float)0.0f);
            this.mc.field_71446_o.func_110577_a(ScrollingEntryItem.currentTheme().getGuiTexture());
            this.drawTexturedModalRect(0, 0, 0, 48, 18, 18);
            GlStateManager.func_179126_j();
            if (this.stack != null) {
                ItemStack tmpStack = ((ItemStack)this.subStacks.get((int)(Minecraft.func_71386_F() / 1000L) % this.subStacks.size())).func_77946_l();
                tmpStack.func_77982_d(this.stack.GetTagCompound());
                try {
                    RenderUtils.RenderItemStack((Minecraft)this.mc, (ItemStack)tmpStack, (int)1, (int)1, (String)(this.stack.stackSize > 1 ? "" + this.stack.stackSize : ""));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179121_F();
            RenderUtils.drawSplitString((FontRenderer)this.mc.field_71466_p, (String)this.desc, (int)(px + 20), (int)(py + 4), (int)(width - 20), (int)ScrollingEntryItem.getTextColor(), (boolean)false, (int)0, (int)0);
        }

        public void drawForeground(int mx, int my, int px, int py, int width) {
            if (this.stack != null && this.isWithin(mx, my, px + 1, py + 1, 16, 16)) {
                ItemStack tmpStack = ((ItemStack)this.subStacks.get((int)(Minecraft.func_71386_F() / 1000L) % this.subStacks.size())).func_77946_l();
                tmpStack.func_77982_d(this.stack.GetTagCompound());
                try {
                    this.drawTooltip(tmpStack.func_82840_a((EntityPlayer)this.mc.field_71439_g, (ITooltipFlag)(this.mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)), mx, my, this.mc.field_71466_p);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void onMouseClick(int mx, int my, int px, int py, int click, int index) {
        }

        public int getHeight() {
            return 18;
        }

        public boolean canDrawOutsideBox(boolean isForeground) {
            return isForeground;
        }
    }
}

