/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.quests.QuestInterface;

public class QuestLocation
extends QuestInterface {
    public String location = "";
    public String location2 = "";
    public String location3 = "";

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        this.location = compound.func_74779_i("QuestLocation");
        this.location2 = compound.func_74779_i("QuestLocation2");
        this.location3 = compound.func_74779_i("QuestLocation3");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        compound.func_74778_a("QuestLocation", this.location);
        compound.func_74778_a("QuestLocation2", this.location2);
        compound.func_74778_a("QuestLocation3", this.location3);
    }

    @Override
    public boolean isCompleted(EntityPlayer player) {
        PlayerQuestData playerdata = PlayerData.get((EntityPlayer)player).questData;
        QuestData data = playerdata.activeQuests.get(this.questId);
        if (data == null) {
            return false;
        }
        return this.getFound(data, 0);
    }

    @Override
    public void handleComplete(EntityPlayer player) {
    }

    @Override
    public String[] getQuestLogStatus(EntityPlayer player) {
        Vector<String> vec = new Vector<String>();
        PlayerQuestData playerdata = PlayerData.get((EntityPlayer)player).questData;
        QuestData data = playerdata.activeQuests.get(this.questId);
        if (data == null) {
            return new String[0];
        }
        String found = I18n.func_74838_a((String)"quest.found");
        String notfound = I18n.func_74838_a((String)"quest.notfound");
        if (!this.location.isEmpty()) {
            vec.add(this.location + ": " + (this.getFound(data, 1) ? found : notfound));
        }
        if (!this.location2.isEmpty()) {
            vec.add(this.location2 + ": " + (this.getFound(data, 2) ? found : notfound));
        }
        if (!this.location3.isEmpty()) {
            vec.add(this.location3 + ": " + (this.getFound(data, 3) ? found : notfound));
        }
        return vec.toArray(new String[vec.size()]);
    }

    public boolean getFound(QuestData data, int i) {
        if (i == 1) {
            return data.extraData.func_74767_n("LocationFound");
        }
        if (i == 2) {
            return data.extraData.func_74767_n("Location2Found");
        }
        if (i == 3) {
            return data.extraData.func_74767_n("Location3Found");
        }
        if (!this.location.isEmpty() && !data.extraData.func_74767_n("LocationFound")) {
            return false;
        }
        if (!this.location2.isEmpty() && !data.extraData.func_74767_n("Location2Found")) {
            return false;
        }
        return this.location3.isEmpty() || data.extraData.func_74767_n("Location3Found");
    }

    public boolean setFound(QuestData data, String location) {
        if (location.equalsIgnoreCase(this.location) && !data.extraData.func_74767_n("LocationFound")) {
            data.extraData.func_74757_a("LocationFound", true);
            return true;
        }
        if (location.equalsIgnoreCase(this.location2) && !data.extraData.func_74767_n("LocationFound2")) {
            data.extraData.func_74757_a("Location2Found", true);
            return true;
        }
        if (location.equalsIgnoreCase(this.location3) && !data.extraData.func_74767_n("LocationFound3")) {
            data.extraData.func_74757_a("Location3Found", true);
            return true;
        }
        return false;
    }
}

