/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.roles.RoleInterface;

public class ItemSoulstoneEmpty
extends Item {
    public ItemSoulstoneEmpty() {
        this.func_77625_d(64);
    }

    public Item func_77655_b(String name) {
        super.func_77655_b(name);
        this.setRegistryName(new ResourceLocation("customnpcs", name));
        return this;
    }

    public boolean store(EntityLivingBase entity, ItemStack stack, EntityPlayer player) {
        if (!this.hasPermission(entity, player) || entity instanceof EntityPlayer) {
            return false;
        }
        ItemStack stone = new ItemStack(CustomItems.soulstoneFull);
        NBTTagCompound compound = new NBTTagCompound();
        if (!entity.func_70039_c(compound)) {
            return false;
        }
        ServerCloneController.Instance.cleanTags(compound);
        stone.func_77983_a("Entity", (NBTBase)compound);
        String name = EntityList.func_75621_b((Entity)entity);
        if (name == null) {
            name = "generic";
        }
        stone.func_77983_a("Name", (NBTBase)new NBTTagString("entity." + name + ".name"));
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            stone.func_77983_a("DisplayName", (NBTBase)new NBTTagString(entity.func_70005_c_()));
            if (npc.advanced.role == 6) {
                RoleCompanion role = (RoleCompanion)npc.roleInterface;
                stone.func_77983_a("ExtraText", (NBTBase)new NBTTagString("companion.stage,: ," + role.stage.name));
            }
        } else if (entity instanceof EntityLiving && ((EntityLiving)entity).func_145818_k_()) {
            stone.func_77983_a("DisplayName", (NBTBase)new NBTTagString(((EntityLiving)entity).func_95999_t()));
        }
        NoppesUtilServer.GivePlayerItem((Entity)player, player, stone);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_77979_a(1);
            if (stack.func_190916_E() <= 0) {
                player.field_71071_by.func_184437_d(stack);
            }
        }
        entity.field_70128_L = true;
        return true;
    }

    public boolean hasPermission(EntityLivingBase entity, EntityPlayer player) {
        if (NoppesUtilServer.isOp(player)) {
            return true;
        }
        if (CustomNpcsPermissions.hasPermission(player, CustomNpcsPermissions.SOULSTONE_ALL)) {
            return true;
        }
        if (entity instanceof EntityNPCInterface) {
            RoleInterface role;
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            if (npc.advanced.role == 6 && ((RoleCompanion)(role = (RoleCompanion)npc.roleInterface)).getOwner() == player) {
                return true;
            }
            if (npc.advanced.role == 2 && ((RoleFollower)(role = (RoleFollower)npc.roleInterface)).getOwner() == player) {
                return !((RoleFollower)role).refuseSoulStone;
            }
            return CustomNpcs.SoulStoneNPCs;
        }
        if (entity instanceof EntityAnimal) {
            return CustomNpcs.SoulStoneAnimals;
        }
        return false;
    }
}

