/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNPCStringSlot;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiSelectionListener;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiNPCQuestSelection
extends GuiNPCInterface
implements IScrollData {
    private GuiNPCStringSlot slot;
    private GuiScreen parent;
    private HashMap<String, Integer> data;
    private boolean selectCategory = true;
    public GuiSelectionListener listener;
    private int quest;

    public GuiNPCQuestSelection(EntityNPCInterface npc, GuiScreen parent, int quest) {
        super(npc);
        this.drawDefaultBackground = false;
        this.title = "";
        this.parent = parent;
        this.data = new HashMap();
        this.quest = quest;
        if (parent instanceof GuiSelectionListener) {
            this.listener = (GuiSelectionListener)parent;
        }
    }

    @Override
    public void initPacket() {
        if (this.quest >= 0) {
            Client.sendData(EnumPacketServer.QuestsGetFromQuest, this.quest);
            this.selectCategory = false;
            this.title = "";
        } else {
            Client.sendData(EnumPacketServer.QuestCategoriesGet, this.quest);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Vector<String> list = new Vector<String>();
        this.slot = new GuiNPCStringSlot(list, this, false, 18);
        this.slot.func_148134_d(4, 5);
        this.addButton(new GuiNpcButton(2, this.field_146294_l / 2 - 100, this.field_146295_m - 41, 98, 20, "gui.back"));
        this.addButton(new GuiNpcButton(4, this.field_146294_l / 2 + 2, this.field_146295_m - 41, 98, 20, "mco.template.button.select"));
    }

    public void func_146274_d() throws IOException {
        this.slot.func_178039_p();
        super.func_146274_d();
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        this.slot.func_148128_a(i, j, f);
        super.func_73863_a(i, j, f);
    }

    @Override
    protected void func_146284_a(GuiButton guibutton) {
        int id = guibutton.field_146127_k;
        if (id == 2) {
            if (this.selectCategory) {
                this.close();
                NoppesUtil.openGUI((EntityPlayer)this.player, this.parent);
            } else {
                this.title = "";
                this.selectCategory = true;
                Client.sendData(EnumPacketServer.QuestCategoriesGet, this.quest);
            }
        }
        if (id == 4) {
            if (this.slot.selected == null || this.slot.selected.isEmpty()) {
                return;
            }
            this.doubleClicked();
        }
    }

    public String getSelected() {
        return this.slot.selected;
    }

    @Override
    public void doubleClicked() {
        if (this.slot.selected == null || this.slot.selected.isEmpty()) {
            return;
        }
        if (this.selectCategory) {
            this.selectCategory = false;
            this.title = "";
            Client.sendData(EnumPacketServer.QuestsGet, this.data.get(this.slot.selected));
        } else {
            this.quest = this.data.get(this.slot.selected);
            this.close();
            NoppesUtil.openGUI((EntityPlayer)this.player, this.parent);
        }
    }

    @Override
    public void save() {
        if (this.quest >= 0 && this.listener != null) {
            this.listener.selected(this.quest, this.slot.selected);
        }
    }

    @Override
    public void setData(Vector<String> list, HashMap<String, Integer> data) {
        this.data = data;
        this.slot.setList(list);
        if (this.quest >= 0) {
            for (String name : data.keySet()) {
                if (data.get(name) != this.quest) continue;
                this.slot.selected = name;
            }
        }
    }

    @Override
    public void setSelected(String selected) {
    }
}

