/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.util.HashMap;
import java.util.Vector;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.GuiNpcSoundSelection;
import noppes.npcs.client.gui.SubGuiNpcAvailability;
import noppes.npcs.client.gui.SubGuiNpcCommand;
import noppes.npcs.client.gui.SubGuiNpcFactionOptions;
import noppes.npcs.client.gui.SubGuiNpcTextArea;
import noppes.npcs.client.gui.global.GuiNPCQuestSelection;
import noppes.npcs.client.gui.global.SubGuiNpcDialogExtra;
import noppes.npcs.client.gui.global.SubGuiNpcDialogOption;
import noppes.npcs.client.gui.global.SubGuiNpcDialogOptions;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.GuiSelectionListener;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiNPCManageDialogs
extends GuiNPCInterface2
implements IScrollData,
ISubGuiListener,
GuiSelectionListener,
ICustomScrollListener,
ITextfieldListener,
IGuiData {
    private GuiCustomScroll scroll;
    private HashMap<String, Integer> data = new HashMap();
    private Dialog dialog = new Dialog(null);
    private DialogCategory category = new DialogCategory();
    private boolean categorySelection = true;
    private GuiNpcSoundSelection gui;

    public GuiNPCManageDialogs(EntityNPCInterface npc) {
        super(npc);
        Client.sendData(EnumPacketServer.DialogCategoriesGet, new Object[0]);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addButton(new GuiNpcButton(0, this.guiLeft + 358, this.guiTop + 8, 58, 20, this.categorySelection ? "dialog.dialogs" : "gui.categories"));
        this.addButton(new GuiNpcButton(1, this.guiLeft + 358, this.guiTop + 38, 58, 20, "gui.add"));
        this.addButton(new GuiNpcButton(2, this.guiLeft + 358, this.guiTop + 61, 58, 20, "gui.remove"));
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(143, 208);
        }
        this.scroll.guiLeft = this.guiLeft + 214;
        this.scroll.guiTop = this.guiTop + 4;
        this.addScroll(this.scroll);
        if (this.categorySelection && this.category.id >= 0) {
            this.categoryGuiInit();
        }
        if (!this.categorySelection && this.dialog.id >= 0) {
            this.dialogGuiInit();
        }
    }

    private void dialogGuiInit() {
        this.addLabel(new GuiNpcLabel(1, "gui.title", this.guiLeft + 4, this.guiTop + 8));
        this.addTextField(new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 36, this.guiTop + 3, 140, 20, this.dialog.title));
        this.addLabel(new GuiNpcLabel(0, "ID", this.guiLeft + 178, this.guiTop + 4));
        this.addLabel(new GuiNpcLabel(2, this.dialog.id + "", this.guiLeft + 178, this.guiTop + 14));
        this.addLabel(new GuiNpcLabel(3, "dialog.dialogtext", this.guiLeft + 4, this.guiTop + 30));
        this.addButton(new GuiNpcButton(3, this.guiLeft + 120, this.guiTop + 25, 50, 20, "selectServer.edit"));
        this.addLabel(new GuiNpcLabel(4, "availability.options", this.guiLeft + 4, this.guiTop + 51));
        this.addButton(new GuiNpcButton(4, this.guiLeft + 120, this.guiTop + 46, 50, 20, "selectServer.edit"));
        this.addLabel(new GuiNpcLabel(5, "faction.options", this.guiLeft + 4, this.guiTop + 72));
        this.addButton(new GuiNpcButton(5, this.guiLeft + 120, this.guiTop + 67, 50, 20, "selectServer.edit"));
        this.addLabel(new GuiNpcLabel(6, "dialog.options", this.guiLeft + 4, this.guiTop + 93));
        this.addButton(new GuiNpcButton(6, this.guiLeft + 120, this.guiTop + 89, 50, 20, "selectServer.edit"));
        this.addButton(new GuiNpcButton(7, this.guiLeft + 4, this.guiTop + 114, 144, 20, "availability.selectquest"));
        this.addButton(new GuiNpcButton(8, this.guiLeft + 150, this.guiTop + 114, 20, 20, "X"));
        this.addLabel(new GuiNpcLabel(9, "gui.selectSound", this.guiLeft + 4, this.guiTop + 138));
        this.addTextField(new GuiNpcTextField(2, this, this.field_146289_q, this.guiLeft + 4, this.guiTop + 148, 144, 20, this.dialog.sound));
        this.addButton(new GuiNpcButton(9, this.guiLeft + 150, this.guiTop + 148, 60, 20, "mco.template.button.select"));
        this.addButton(new GuiNpcButton(10, this.guiLeft + 4, this.guiTop + 172, 120, 20, "gui.extraoptions"));
    }

    private void categoryGuiInit() {
        this.addTextField(new GuiNpcTextField(0, this, this.field_146289_q, this.guiLeft + 8, this.guiTop + 8, 160, 16, this.category.title));
    }

    @Override
    public void elementClicked() {
        this.getTextField(2).func_146180_a(this.gui.getSelected());
        this.unFocused(this.getTextField(2));
    }

    @Override
    public void buttonEvent(GuiButton guibutton) {
        int id = guibutton.field_146127_k;
        if (id == 0) {
            this.save();
            if (this.categorySelection) {
                if (this.category.id < 0) {
                    return;
                }
                this.dialog = new Dialog(this.category);
                Client.sendData(EnumPacketServer.DialogsGet, this.category.id);
            } else if (!this.categorySelection) {
                this.dialog = new Dialog(null);
                this.category = new DialogCategory();
                Client.sendData(EnumPacketServer.DialogCategoriesGet, new Object[0]);
            }
            this.categorySelection = !this.categorySelection;
            this.getButton(0).setEnabled(false);
            this.scroll.clear();
            this.data.clear();
        }
        if (id == 1) {
            this.save();
            String name = I18n.func_74838_a((String)"gui.new");
            while (this.data.containsKey(name)) {
                name = name + "_";
            }
            if (this.categorySelection) {
                DialogCategory category = new DialogCategory();
                category.title = name;
                Client.sendData(EnumPacketServer.DialogCategorySave, category.writeNBT(new NBTTagCompound()));
            } else {
                Dialog dialog = new Dialog(this.category);
                dialog.title = name;
                Client.sendData(EnumPacketServer.DialogSave, this.category.id, dialog.writeToNBT(new NBTTagCompound()));
            }
        }
        if (id == 2 && this.data.containsKey(this.scroll.getSelected())) {
            if (this.categorySelection) {
                Client.sendData(EnumPacketServer.DialogCategoryRemove, this.category.id);
                this.category = new DialogCategory();
            } else {
                Client.sendData(EnumPacketServer.DialogRemove, this.dialog.id);
                this.dialog = new Dialog(this.category);
            }
            this.scroll.clear();
        }
        if (id == 3 && this.dialog.id >= 0) {
            this.setSubGui(new SubGuiNpcTextArea(this.dialog.text));
        }
        if (id == 4 && this.dialog.id >= 0) {
            this.setSubGui(new SubGuiNpcAvailability(this.dialog.availability));
        }
        if (id == 5 && this.dialog.id >= 0) {
            this.setSubGui(new SubGuiNpcFactionOptions(this.dialog.factionOptions));
        }
        if (id == 6 && this.dialog.id >= 0) {
            this.setSubGui(new SubGuiNpcDialogOptions(this.dialog));
        }
        if (id == 7 && this.dialog.id >= 0) {
            NoppesUtil.openGUI((EntityPlayer)this.player, new GuiNPCQuestSelection(this.npc, this, this.dialog.quest));
        }
        if (id == 8 && this.dialog.id >= 0) {
            this.dialog.quest = -1;
            this.func_73866_w_();
        }
        if (id == 9 && this.dialog.id >= 0) {
            this.gui = new GuiNpcSoundSelection(this, this.getTextField(2).func_146179_b());
            NoppesUtil.openGUI((EntityPlayer)this.player, (Object)this.gui);
        }
        if (id == 10) {
            this.setSubGui(new SubGuiNpcDialogExtra(this.dialog, this));
        }
    }

    @Override
    public void unFocused(GuiNpcTextField guiNpcTextField) {
        String old;
        String name;
        if (guiNpcTextField.field_175208_g == 0) {
            if (this.category.id < 0) {
                guiNpcTextField.func_146180_a("");
            } else {
                name = guiNpcTextField.func_146179_b();
                if (name.isEmpty() || this.data.containsKey(name)) {
                    guiNpcTextField.func_146180_a(this.category.title);
                } else if (this.categorySelection && this.category.id >= 0) {
                    old = this.category.title;
                    this.data.remove(this.category.title);
                    this.category.title = name;
                    this.data.put(this.category.title, this.category.id);
                    this.scroll.replace(old, this.category.title);
                }
            }
        }
        if (guiNpcTextField.field_175208_g == 1) {
            if (this.dialog.id < 0) {
                guiNpcTextField.func_146180_a("");
            } else {
                name = guiNpcTextField.func_146179_b();
                if (name.isEmpty() || this.data.containsKey(name)) {
                    guiNpcTextField.func_146180_a(this.dialog.title);
                } else if (!this.categorySelection && this.dialog.id >= 0) {
                    old = this.dialog.title;
                    this.data.remove(old);
                    this.dialog.title = name;
                    this.data.put(this.dialog.title, this.dialog.id);
                    this.scroll.replace(old, this.dialog.title);
                }
            }
        }
        if (guiNpcTextField.field_175208_g == 2) {
            this.dialog.sound = guiNpcTextField.func_146179_b();
        }
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (this.categorySelection) {
            this.category.readNBT(compound);
            this.setSelected(this.category.title);
            this.func_73866_w_();
        } else {
            this.dialog.readNBT(compound);
            this.setSelected(this.dialog.title);
            this.func_73866_w_();
            if (compound.func_74764_b("DialogQuestName")) {
                this.getButton(7).setDisplayText(compound.func_74779_i("DialogQuestName"));
            }
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui instanceof SubGuiNpcTextArea) {
            SubGuiNpcTextArea gui = (SubGuiNpcTextArea)subgui;
            this.dialog.text = gui.text;
        }
        if (subgui instanceof SubGuiNpcDialogOption) {
            this.setSubGui(new SubGuiNpcDialogOptions(this.dialog));
        }
        if (subgui instanceof SubGuiNpcCommand) {
            this.dialog.command = ((SubGuiNpcCommand)subgui).command;
        }
    }

    @Override
    public void setData(Vector<String> list, HashMap<String, Integer> data) {
        this.getButton(0).setEnabled(true);
        String name = this.scroll.getSelected();
        this.data = data;
        this.scroll.setList(list);
        if (name != null) {
            this.scroll.setSelected(name);
        }
        this.func_73866_w_();
    }

    @Override
    public void setSelected(String selected) {
    }

    @Override
    public void selected(int ob, String name) {
        this.dialog.quest = ob;
        Client.sendData(EnumPacketServer.DialogSave, this.category.id, this.dialog.writeToNBT(new NBTTagCompound()));
        Client.sendData(EnumPacketServer.DialogGet, this.dialog.id);
    }

    @Override
    public void customScrollClicked(int i, int j, int k, GuiCustomScroll guiCustomScroll) {
        if (guiCustomScroll.id == 0) {
            this.save();
            String selected = this.scroll.getSelected();
            if (this.categorySelection) {
                this.category = new DialogCategory();
                Client.sendData(EnumPacketServer.DialogCategoryGet, this.data.get(selected));
            } else {
                this.dialog = new Dialog(this.category);
                Client.sendData(EnumPacketServer.DialogGet, this.data.get(selected));
            }
        }
    }

    @Override
    public void save() {
        GuiNpcTextField.unfocus();
        if (!this.categorySelection && this.dialog.id >= 0) {
            Client.sendData(EnumPacketServer.DialogSave, this.category.id, this.dialog.writeToNBT(new NBTTagCompound()));
        } else if (this.categorySelection && this.category.id >= 0) {
            Client.sendData(EnumPacketServer.DialogCategorySave, this.category.writeNBT(new NBTTagCompound()));
        }
    }
}

