/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.render;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.bonsaitrees.BonsaiTrees;
import org.dave.bonsaitrees.misc.ConfigurationHandler;
import org.dave.bonsaitrees.tile.TileBonsaiPot;
import org.dave.bonsaitrees.trees.TreeBlockAccess;
import org.dave.bonsaitrees.trees.TreeShape;

@SideOnly(value=Side.CLIENT)
public class TESRBonsaiPot
extends TileEntitySpecialRenderer<TileBonsaiPot> {
    private IBlockAccess blockAccess;
    private TreeShape treeShape;
    private static Map<TreeShape, Integer> glLists = new HashMap<TreeShape, Integer>();
    private static boolean clearLists = false;

    public static void clearGlLists() {
        clearLists = true;
    }

    private void renderSoil(TileBonsaiPot te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.getSoilBlockState() == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179101_C();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179106_n();
        GlStateManager.func_179140_f();
        RenderHelper.func_74518_a();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179152_a((float)0.0625f, (float)0.0625f, (float)0.0625f);
        GlStateManager.func_179137_b((double)2.0, (double)1.1, (double)2.0);
        GlStateManager.func_179152_a((float)12.0f, (float)1.0f, (float)12.0f);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.TRANSLUCENT);
        try {
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            blockrendererdispatcher.func_175018_a(te.getSoilBlockState(), new BlockPos(0, 0, 0), (IBlockAccess)te.func_145831_w(), buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ForgeHooksClient.setRenderLayer(null);
        tessellator.func_78381_a();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179129_p();
        GlStateManager.func_179145_e();
        GlStateManager.func_179091_B();
        GlStateManager.func_179117_G();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    public void render(TileBonsaiPot te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.renderSoil(te, x, y, z, partialTicks, destroyStage, alpha);
        if (te.getBonsaiShapeName() == null) {
            return;
        }
        this.treeShape = te.getShapeFilename();
        if (this.treeShape == null) {
            return;
        }
        if (te.getTreeType() == null) {
            return;
        }
        List<BlockPos> toRender = this.treeShape.getToRenderPositions();
        if (toRender.isEmpty()) {
            return;
        }
        if (clearLists) {
            for (int listId : glLists.values()) {
                GlStateManager.func_187449_e((int)listId, (int)1);
            }
            glLists = new HashMap<TreeShape, Integer>();
            clearLists = false;
        }
        if (glLists.containsKey(this.treeShape)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179101_C();
            float rotateOffsetX = (float)(this.treeShape.getWidth() + 1) / 2.0f;
            float rotateOffsetY = 0.0f;
            float rotateOffsetZ = (float)(this.treeShape.getDepth() + 1) / 2.0f;
            GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)0.5f);
            GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
            double scale = this.treeShape.getScaleRatio(false);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            float maxSize = ConfigurationHandler.ClientSettings.maxTreeScale;
            GlStateManager.func_179152_a((float)maxSize, (float)maxSize, (float)maxSize);
            double progress = te.getProgress() / (double)BonsaiTrees.instance.typeRegistry.getFinalGrowTime(te.getTreeType(), te.getBonsaiSoil());
            GlStateManager.func_179139_a((double)progress, (double)progress, (double)progress);
            GlStateManager.func_179109_b((float)(-rotateOffsetX), (float)(-rotateOffsetY), (float)(-rotateOffsetZ));
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179106_n();
            GlStateManager.func_179140_f();
            RenderHelper.func_74518_a();
            GlStateManager.func_179147_l();
            GlStateManager.func_179089_o();
            GlStateManager.func_179141_d();
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            textureManager.func_110577_a(TextureMap.field_110575_b);
            textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179148_o((int)glLists.get(this.treeShape));
            textureManager.func_110577_a(TextureMap.field_110575_b);
            textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179117_G();
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
        } else {
            int listId;
            this.blockAccess = new TreeBlockAccess(this.treeShape, te.func_145831_w(), te.func_174877_v());
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            listId = GLAllocation.func_74526_a((int)1);
            glLists.put(this.treeShape, listId);
            GlStateManager.func_187423_f((int)listId, (int)4864);
            GlStateManager.func_179123_a();
            GlStateManager.func_179094_E();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            GlStateManager.func_179118_c();
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.SOLID, toRender);
            GlStateManager.func_179141_d();
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT_MIPPED, toRender);
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT, toRender);
            GlStateManager.func_179103_j((int)7424);
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.TRANSLUCENT, toRender);
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
            GlStateManager.func_187415_K();
        }
    }

    public void renderLayer(BlockRendererDispatcher blockrendererdispatcher, BufferBuilder buffer, BlockRenderLayer renderLayer, List<BlockPos> toRender) {
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
        for (BlockPos pos : toRender) {
            IBlockState state = this.treeShape.getStateAtPos(pos);
            if (!state.func_177230_c().canRenderInLayer(state, renderLayer)) continue;
            try {
                blockrendererdispatcher.func_175018_a(state, pos, this.blockAccess, buffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ForgeHooksClient.setRenderLayer(null);
    }
}

