/*
 * Decompiled with CFR 0.152.
 */
package squeek.wailaharvestability.helpers;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;

public class BlockHelper {
    private static final HashMap<String, ItemStack> testTools = new HashMap();

    public static String getEffectiveToolOf(World world, BlockPos blockPos, Block block, IBlockState blockState) {
        float hardness;
        String effectiveTool = block.getHarvestTool(blockState);
        if (effectiveTool == null && (hardness = block.func_176195_g(blockState, world, blockPos)) > 0.0f) {
            for (Map.Entry<String, ItemStack> testToolEntry : testTools.entrySet()) {
                ItemStack testTool = testToolEntry.getValue();
                if (testTool == null || !(testTool.func_77973_b() instanceof ItemTool) || !(testTool.func_150997_a(blockState) >= Item.ToolMaterial.WOOD.func_77998_b())) continue;
                effectiveTool = testToolEntry.getKey();
                break;
            }
        }
        return effectiveTool;
    }

    public static boolean isBlockUnbreakable(Block block, World world, BlockPos blockPos, IBlockState blockState) {
        return block.func_176195_g(blockState, world, blockPos) == -1.0f;
    }

    public static boolean isAdventureModeAndBlockIsUnbreakable(EntityPlayer player, Block block) {
        NetHandlerPlayClient netHandler = Minecraft.func_71410_x().func_147114_u();
        if (netHandler == null) {
            return false;
        }
        NetworkPlayerInfo networkplayerinfo = netHandler.func_175102_a(player.func_146103_bH().getId());
        GameType gameType = networkplayerinfo.func_178848_b();
        if (!gameType.func_82752_c()) {
            return false;
        }
        if (player.func_175142_cm()) {
            return false;
        }
        ItemStack heldItem = player.func_184614_ca();
        return gameType == GameType.SPECTATOR || heldItem.func_190926_b() || !heldItem.func_179544_c(block);
    }

    public static boolean canHarvestBlock(Block block, EntityPlayer player, IBlockState state) {
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.field_71071_by.func_70448_g();
        String tool = block.getHarvestTool(state);
        if (stack.func_190926_b() || tool == null) {
            return player.func_184823_b(state);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.func_184823_b(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    static {
        testTools.put("pickaxe", new ItemStack(Items.field_151039_o));
        testTools.put("shovel", new ItemStack(Items.field_151038_n));
        testTools.put("axe", new ItemStack(Items.field_151053_p));
    }
}

