/*
 * Decompiled with CFR 0.152.
 */
package com.sixonethree.durabilityshow.client.gui;

import com.google.common.collect.Lists;
import com.sixonethree.durabilityshow.client.gui.EnumCorner;
import com.sixonethree.durabilityshow.client.gui.EnumGuiState;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiSubtitleOverlay;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GuiItemDurability
extends Gui
implements ISoundEventListener {
    private static Minecraft minecraftInstance;
    private static List<GuiSubtitleOverlay.Subtitle> subtitles;
    private static boolean subtitlesEnabled;
    private static EnumGuiState guiState;
    private static EnumCorner corner;
    private static int offsetPosition;
    private static int closeSize;
    private static int color_white;
    private static FontRenderer fontRenderer;
    private static RenderItem itemRender;
    private static boolean renderCharacter;
    private static boolean renderBaubles;
    private static int overrideRenderCharacterTime;
    private static Object[][] lastArmorSet;
    private static final int BOOTS = 1;
    private static final int LEGGINGS = 2;
    private static final int CHESTPLATE = 3;
    private static final int HELMET = 4;

    public static EnumGuiState getGuiState() {
        return guiState;
    }

    public static int getOffset() {
        return offsetPosition;
    }

    public static void setGuiState(EnumGuiState State) {
        guiState = State;
    }

    public static EnumCorner getCorner() {
        if (corner == EnumCorner.BOTTOM_RIGHT && !subtitles.isEmpty() && subtitlesEnabled) {
            return EnumCorner.BOTTOM_LEFT;
        }
        return corner;
    }

    public static void setCorner(EnumCorner newCorner) {
        corner = newCorner;
    }

    public static void lowerOffset() {
        --offsetPosition;
    }

    public static void raiseOffset() {
        ++offsetPosition;
    }

    public static void setCloseSize(int size) {
        closeSize = size;
    }

    public static int getCloseSize() {
        return closeSize;
    }

    public static int getOverrideTime() {
        return overrideRenderCharacterTime;
    }

    public static void decOverrideTime() {
        --overrideRenderCharacterTime;
    }

    public static boolean getRenderCharacter() {
        return renderCharacter;
    }

    public static void setRenderChararcter(boolean render) {
        renderCharacter = render;
    }

    public static boolean getRenderBaubles() {
        return renderBaubles;
    }

    public static void setRenderBaubles(boolean render) {
        renderBaubles = render;
    }

    public GuiItemDurability(Minecraft MC) {
        minecraftInstance = MC;
        fontRenderer = MC.field_71466_p;
        itemRender = MC.func_175599_af();
    }

    private int getArrowsInInventory() {
        int arrows = 0;
        for (ItemStack stack : GuiItemDurability.minecraftInstance.field_71439_g.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArrow)) continue;
            arrows += stack.func_190916_E();
        }
        return arrows;
    }

    private ItemStack getArrowToDraw() {
        if (this.isArrow(GuiItemDurability.minecraftInstance.field_71439_g.func_184586_b(EnumHand.OFF_HAND))) {
            return GuiItemDurability.minecraftInstance.field_71439_g.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isArrow(GuiItemDurability.minecraftInstance.field_71439_g.func_184586_b(EnumHand.MAIN_HAND))) {
            return GuiItemDurability.minecraftInstance.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < GuiItemDurability.minecraftInstance.field_71439_g.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = GuiItemDurability.minecraftInstance.field_71439_g.field_71071_by.func_70301_a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    protected boolean isArrow(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemArrow;
    }

    public boolean allNull(ItemStack ... stacks) {
        for (ItemStack s : stacks) {
            if (s.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRender(RenderGameOverlayEvent.Post event) {
        this.updateSubtitles();
        EntityPlayerSP effectivePlayer = GuiItemDurability.minecraftInstance.field_71439_g;
        boolean noSpec = false;
        if (GuiItemDurability.minecraftInstance.field_71439_g.func_175149_v()) {
            Entity spec = minecraftInstance.func_175606_aa();
            if (spec != null) {
                if (spec instanceof EntityPlayer) {
                    effectivePlayer = (EntityPlayer)spec;
                } else {
                    noSpec = true;
                }
            } else {
                noSpec = true;
            }
        }
        ItemStack current = effectivePlayer.func_184582_a(EntityEquipmentSlot.MAINHAND);
        ItemStack secondary = effectivePlayer.func_184582_a(EntityEquipmentSlot.OFFHAND);
        ItemStack boots = effectivePlayer.func_184582_a(EntityEquipmentSlot.FEET);
        ItemStack leggings = effectivePlayer.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack chestplate = effectivePlayer.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack helmet = effectivePlayer.func_184582_a(EntityEquipmentSlot.HEAD);
        RayTraceResult rayTraceResult = GuiItemDurability.minecraftInstance.field_71476_x;
        if (rayTraceResult != null && rayTraceResult.field_72313_a != null && rayTraceResult.field_72313_a == RayTraceResult.Type.ENTITY && rayTraceResult.field_72308_g instanceof EntityArmorStand) {
            EntityArmorStand stand = (EntityArmorStand)rayTraceResult.field_72308_g;
            current = stand.func_184582_a(EntityEquipmentSlot.MAINHAND);
            secondary = stand.func_184582_a(EntityEquipmentSlot.OFFHAND);
            boots = stand.func_184582_a(EntityEquipmentSlot.FEET);
            leggings = stand.func_184582_a(EntityEquipmentSlot.LEGS);
            chestplate = stand.func_184582_a(EntityEquipmentSlot.CHEST);
            helmet = stand.func_184582_a(EntityEquipmentSlot.HEAD);
        }
        if (event.isCanceled() || this.allNull(current, boots, leggings, chestplate, helmet) || GuiItemDurability.minecraftInstance.field_71439_g.field_71075_bZ.field_75098_d || noSpec || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        String curHelmetName = "";
        String curChestplateName = "";
        String curLeggingsName = "";
        String curBootsName = "";
        Integer curHelmetDur = 0;
        Integer curChestplateDur = 0;
        Integer curLeggingsDur = 0;
        Integer curBootsDur = 0;
        if (!helmet.func_190926_b()) {
            curHelmetName = helmet.func_77977_a();
            curHelmetDur = helmet.func_77952_i();
        }
        if (!chestplate.func_190926_b()) {
            curChestplateName = chestplate.func_77977_a();
            curChestplateDur = chestplate.func_77952_i();
        }
        if (!leggings.func_190926_b()) {
            curLeggingsName = leggings.func_77977_a();
            curLeggingsDur = leggings.func_77952_i();
        }
        if (!boots.func_190926_b()) {
            curBootsName = boots.func_77977_a();
            curBootsDur = boots.func_77952_i();
        }
        String lastHelmetName = (String)lastArmorSet[0][0];
        String lastChestplateName = (String)lastArmorSet[0][1];
        String lastLeggingsName = (String)lastArmorSet[0][2];
        String lastBootsName = (String)lastArmorSet[0][3];
        if (!(lastHelmetName.equalsIgnoreCase(curHelmetName) && lastArmorSet[1][0] == Integer.valueOf(curHelmetDur) && lastChestplateName.equalsIgnoreCase(curChestplateName) && lastArmorSet[1][1] == Integer.valueOf(curChestplateDur) && lastLeggingsName.equalsIgnoreCase(curLeggingsName) && lastArmorSet[1][2] == Integer.valueOf(curLeggingsDur) && lastBootsName.equalsIgnoreCase(curBootsName) && lastArmorSet[1][3] == Integer.valueOf(curBootsDur))) {
            overrideRenderCharacterTime = 40;
        }
        GuiItemDurability.lastArmorSet[0][0] = curHelmetName;
        GuiItemDurability.lastArmorSet[0][1] = curChestplateName;
        GuiItemDurability.lastArmorSet[0][2] = curLeggingsName;
        GuiItemDurability.lastArmorSet[0][3] = curBootsName;
        GuiItemDurability.lastArmorSet[1][0] = curHelmetDur;
        GuiItemDurability.lastArmorSet[1][1] = curChestplateDur;
        GuiItemDurability.lastArmorSet[1][2] = curLeggingsDur;
        GuiItemDurability.lastArmorSet[1][3] = curBootsDur;
        ScaledResolution scaled = new ScaledResolution(minecraftInstance);
        if (renderCharacter && overrideRenderCharacterTime <= 0) {
            this.renderCharacter(GuiItemDurability.getCorner(), 10, scaled, (EntityPlayer)effectivePlayer);
        } else {
            int armorOffset = 16;
            int width = scaled.func_78326_a() + offsetPosition;
            int height = scaled.func_78328_b();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74519_b();
            RenderHelper.func_74520_c();
            boolean armorAllNull = this.allNull(boots, leggings, chestplate, helmet);
            int[] params = new int[]{width, height, armorOffset, armorAllNull ? 1 : 0};
            int[] params2 = new int[]{width, height, 0, armorAllNull ? 1 : 0};
            if (GuiItemDurability.getCorner().name().contains("RIGHT")) {
                params2 = this.renderItem(current, secondary, params, 1);
                if (!armorAllNull) {
                    this.renderArmor(boots, 1, params2, 2);
                    this.renderArmor(leggings, 2, params2, 2);
                    this.renderArmor(chestplate, 3, params2, 2);
                    this.renderArmor(helmet, 4, params2, 2);
                }
            } else {
                boolean params2gotten = false;
                if (!boots.func_190926_b()) {
                    if (!params2gotten) {
                        params2 = this.renderArmor(boots, 1, params, 1);
                        params2gotten = true;
                    } else {
                        this.renderArmor(boots, 1, params, 1);
                    }
                }
                if (!leggings.func_190926_b()) {
                    if (!params2gotten) {
                        params2 = this.renderArmor(leggings, 2, params, 1);
                        params2gotten = true;
                    } else {
                        this.renderArmor(leggings, 2, params, 1);
                    }
                }
                if (!chestplate.func_190926_b()) {
                    if (!params2gotten) {
                        params2 = this.renderArmor(chestplate, 3, params, 1);
                        params2gotten = true;
                    } else {
                        this.renderArmor(chestplate, 3, params, 1);
                    }
                }
                if (!helmet.func_190926_b()) {
                    if (!params2gotten) {
                        params2 = this.renderArmor(helmet, 4, params, 1);
                        params2gotten = true;
                    } else {
                        this.renderArmor(helmet, 4, params, 1);
                    }
                }
                this.renderItem(current, secondary, params2, 2);
                RenderHelper.func_74518_a();
            }
        }
    }

    private void renderItemAndEffectIntoGUI(ItemStack stack, int x, int y) {
        itemRender.func_180450_b(stack, x, y);
    }

    private int[] renderItem(ItemStack mainHand, ItemStack offHand, int[] params, int turn) {
        int arrows;
        int itemX;
        boolean secondaryBow;
        int width = params[0];
        int height = params[1];
        boolean armorAllNull = params[3] == 1;
        int[] retStatement = new int[]{params[0], params[1], params[2], params[3]};
        ItemStack firstStack = ItemStack.field_190927_a;
        ItemStack secondStack = ItemStack.field_190927_a;
        if (mainHand.func_190926_b() && offHand.func_190926_b()) {
            return retStatement;
        }
        if (mainHand.func_190926_b()) {
            if (offHand.func_77984_f()) {
                firstStack = offHand;
            }
        } else if (mainHand.func_77984_f()) {
            firstStack = mainHand;
            if (!offHand.func_190926_b() && offHand.func_77984_f()) {
                secondStack = offHand;
            }
        } else if (!offHand.func_190926_b() && offHand.func_77984_f()) {
            firstStack = offHand;
        }
        if (firstStack.func_190926_b() && secondStack.func_190926_b()) {
            return retStatement;
        }
        boolean mainBow = firstStack.func_77973_b() instanceof ItemBow;
        boolean bl = secondaryBow = !secondStack.func_190926_b() ? secondStack.func_77973_b() instanceof ItemBow : false;
        int n = GuiItemDurability.getCorner().name().contains("LEFT") ? params[2] - (armorAllNull ? offsetPosition : 0) : (itemX = width - 20);
        int mainHandY = GuiItemDurability.getCorner().name().contains("TOP") ? (!armorAllNull ? 16 : 0) : (armorAllNull ? height - 16 : height - 48);
        int arrowY = mainHandY + 16;
        int offHandY = mainHandY + ((mainBow || secondaryBow) && this.getArrowsInInventory() > 0 ? 32 : 16);
        String mainDamage = String.valueOf(firstStack.func_77958_k() - firstStack.func_77952_i());
        int damageStringWidth = fontRenderer.func_78256_a(mainDamage) + 2;
        this.renderItemAndEffectIntoGUI(firstStack, itemX - (GuiItemDurability.getCorner().name().contains("LEFT") ? 0 : damageStringWidth - 2), mainHandY);
        if (firstStack.func_77973_b() instanceof ItemBow && (arrows = this.getArrowsInInventory()) > 0) {
            this.renderItemAndEffectIntoGUI(this.getArrowToDraw(), itemX - (GuiItemDurability.getCorner().name().contains("LEFT") ? 0 : damageStringWidth - 2), arrowY);
            fontRenderer.func_78276_b(String.valueOf(arrows), GuiItemDurability.getCorner().name().contains("RIGHT") ? itemX - damageStringWidth + 18 : itemX + 18, arrowY + GuiItemDurability.fontRenderer.field_78288_b / 2, color_white);
        }
        fontRenderer.func_78276_b(String.valueOf(mainDamage), GuiItemDurability.getCorner().name().contains("RIGHT") ? itemX - damageStringWidth + 18 : itemX + 18, mainHandY + GuiItemDurability.fontRenderer.field_78288_b / 2, color_white);
        if (!secondStack.func_190926_b()) {
            int arrows2;
            String offHandDamage = String.valueOf(secondStack.func_77958_k() - secondStack.func_77952_i());
            damageStringWidth = Math.max(damageStringWidth, fontRenderer.func_78256_a(offHandDamage) + 2);
            this.renderItemAndEffectIntoGUI(secondStack, itemX - (GuiItemDurability.getCorner().name().contains("LEFT") ? 0 : damageStringWidth - 2), offHandY);
            if (secondStack.func_77973_b() instanceof ItemBow && !(firstStack.func_77973_b() instanceof ItemBow) && (arrows2 = this.getArrowsInInventory()) > 0) {
                this.renderItemAndEffectIntoGUI(this.getArrowToDraw(), itemX - (GuiItemDurability.getCorner().name().contains("LEFT") ? 0 : damageStringWidth - 2), arrowY);
                fontRenderer.func_78276_b(String.valueOf(arrows2), GuiItemDurability.getCorner().name().contains("RIGHT") ? itemX - damageStringWidth + 18 : itemX + 18, arrowY + GuiItemDurability.fontRenderer.field_78288_b / 2, color_white);
            }
            fontRenderer.func_78276_b(String.valueOf(offHandDamage), GuiItemDurability.getCorner().name().contains("RIGHT") ? itemX - damageStringWidth + 18 : itemX + 18, offHandY + GuiItemDurability.fontRenderer.field_78288_b / 2, color_white);
        }
        retStatement[2] = damageStringWidth + 34;
        if (turn == 1 && armorAllNull) {
            GuiItemDurability.setCloseSize(18 + damageStringWidth);
        }
        if (turn == 2 && armorAllNull) {
            GuiItemDurability.setCloseSize(18 + damageStringWidth);
        }
        if (turn == 2 && !armorAllNull) {
            GuiItemDurability.setCloseSize(fontRenderer.func_78256_a("9999") + 36 + damageStringWidth);
        }
        return retStatement;
    }

    private int[] renderArmor(ItemStack stack, int type, int[] params, int turn) {
        int width = params[0];
        int height = params[1];
        int armorOffset = params[2];
        int[] retStatement = new int[4];
        retStatement[0] = params[0];
        retStatement[1] = params[1];
        retStatement[3] = params[3];
        if (!stack.func_190926_b()) {
            int damageStringWidth;
            int x = GuiItemDurability.getCorner().name().contains("LEFT") ? 0 + (armorOffset - 16) - offsetPosition : width - armorOffset;
            int y = GuiItemDurability.getCorner().name().contains("TOP") ? (4 - type) * 16 : height - 16 * type;
            String damage = String.valueOf(stack.func_77958_k() - stack.func_77952_i());
            int n = damageStringWidth = GuiItemDurability.getCorner().name().contains("LEFT") ? Math.max(fontRenderer.func_78256_a(damage) + 2, fontRenderer.func_78256_a("9999") + 2) : fontRenderer.func_78256_a(damage) + 2;
            if (GuiItemDurability.getCorner().name().contains("LEFT")) {
                x += damageStringWidth;
            }
            this.renderItemAndEffectIntoGUI(stack, x, y);
            fontRenderer.func_78276_b(String.valueOf(damage), x - (GuiItemDurability.getCorner().name().contains("LEFT") ? damageStringWidth - 2 : damageStringWidth), y + GuiItemDurability.fontRenderer.field_78288_b / 2, color_white);
            retStatement[2] = x + 18;
            if (turn == 2) {
                GuiItemDurability.setCloseSize(16 + damageStringWidth + armorOffset);
            }
        }
        return retStatement;
    }

    private int renderBauble(ItemStack stack, int baubleNumber, int width, int height) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (!stack.func_77984_f()) {
            return 0;
        }
        int x = GuiItemDurability.getCorner().name().contains("LEFT") ? 0 - offsetPosition : width - 16;
        int y = GuiItemDurability.getCorner().name().contains("TOP") ? baubleNumber * 16 : height - (baubleNumber + 1) * 16;
        String damage = String.valueOf(stack.func_77958_k() - stack.func_77952_i());
        this.renderItemAndEffectIntoGUI(stack, x, y);
        int textX = x + (GuiItemDurability.getCorner().name().contains("LEFT") ? 16 : -fontRenderer.func_78256_a(damage));
        fontRenderer.func_78276_b(damage, textX, y + GuiItemDurability.fontRenderer.field_78288_b / 2, color_white);
        GuiItemDurability.setCloseSize(fontRenderer.func_78256_a("9999") + 16);
        return 1;
    }

    private void renderCharacter(EnumCorner side, int xPos, ScaledResolution scaled, EntityPlayer effectivePlayer) {
        if (side.name().contains("LEFT")) {
            GuiInventory.func_147046_a((int)(xPos - offsetPosition), (int)scaled.func_78328_b(), (int)(xPos - xPos / 2 * -1 * 2), (float)-50.0f, (float)(-effectivePlayer.field_70125_A), (EntityLivingBase)effectivePlayer);
        } else {
            GuiInventory.func_147046_a((int)(scaled.func_78326_a() - xPos + offsetPosition), (int)scaled.func_78328_b(), (int)(xPos - xPos / 2 * -1 * 2), (float)50.0f, (float)(-effectivePlayer.field_70125_A), (EntityLivingBase)effectivePlayer);
        }
    }

    private void updateSubtitles() {
        if (!GuiItemDurability.minecraftInstance.field_71474_y.field_186717_N && !subtitlesEnabled) {
            return;
        }
        if (GuiItemDurability.minecraftInstance.field_71474_y.field_186717_N && !subtitlesEnabled) {
            minecraftInstance.func_147118_V().func_184402_a((ISoundEventListener)this);
            subtitlesEnabled = true;
        } else if (!GuiItemDurability.minecraftInstance.field_71474_y.field_186717_N && subtitlesEnabled) {
            minecraftInstance.func_147118_V().func_184400_b((ISoundEventListener)this);
            subtitlesEnabled = false;
        } else {
            subtitlesEnabled = GuiItemDurability.minecraftInstance.field_71474_y.field_186717_N;
        }
        if (!subtitles.isEmpty()) {
            Iterator<GuiSubtitleOverlay.Subtitle> iterator = subtitles.iterator();
            while (iterator.hasNext()) {
                GuiSubtitleOverlay.Subtitle subtitle = iterator.next();
                if (subtitle.func_186825_b() + 3000L > Minecraft.func_71386_F()) continue;
                iterator.remove();
            }
        }
    }

    public void func_184067_a(ISound soundIn, SoundEventAccessor accessor) {
        if (!subtitlesEnabled) {
            return;
        }
        if (accessor.func_188712_c() != null) {
            String s = accessor.func_188712_c().func_150254_d();
            if (!subtitles.isEmpty()) {
                for (GuiSubtitleOverlay.Subtitle subtitle : subtitles) {
                    if (!subtitle.func_186824_a().equals(s)) continue;
                    subtitle.func_186823_a(new Vec3d(0.0, 0.0, 0.0));
                    return;
                }
            }
            GuiSubtitleOverlay guiSubtitleOverlay = new GuiSubtitleOverlay(minecraftInstance);
            guiSubtitleOverlay.getClass();
            GuiSubtitleOverlay.Subtitle newsub = new GuiSubtitleOverlay.Subtitle(guiSubtitleOverlay, s, new Vec3d(0.0, 0.0, 0.0));
            subtitles.add(newsub);
        }
    }

    static {
        subtitles = Lists.newArrayList();
        subtitlesEnabled = false;
        guiState = EnumGuiState.OPEN;
        corner = EnumCorner.BOTTOM_RIGHT;
        offsetPosition = 0;
        closeSize = 16;
        color_white = Color.WHITE.getRGB();
        renderCharacter = false;
        renderBaubles = false;
        overrideRenderCharacterTime = 0;
        lastArmorSet = new Object[][]{{"", "", "", ""}, {0, 0, 0, 0}};
    }
}

