/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.lib.LibLog;
import org.orecruncher.lib.math.MathStuff;

public final class ConfigProcessor {
    public static void process(@Nonnull Configuration config, @Nonnull Class<?> clazz) {
        ConfigProcessor.process(config, clazz, null);
    }

    public static void process(@Nonnull Configuration config, @Nonnull Class<?> clazz, @Nullable Object parameters) {
        ConfigProcessor.process(config, null, clazz, parameters);
    }

    private static void process(@Nonnull Configuration config, @Nullable String category, @Nonnull Class<?> clazz, @Nullable Object parameters) {
        Annotation annotation;
        for (Field field : clazz.getFields()) {
            annotation = field.getAnnotation(Option.class);
            if (annotation == null) continue;
            String property = annotation.value();
            String language = field.getAnnotation(LangKey.class) != null ? field.getAnnotation(LangKey.class).value() : null;
            String comment = field.getAnnotation(Comment.class) != null ? field.getAnnotation(Comment.class).value() : null;
            String defaultValue = field.getAnnotation(DefaultValue.class) != null ? field.getAnnotation(DefaultValue.class).value() : null;
            try {
                ConfigCategory cat = config.getCategory(category);
                Property prop = cat.get(property);
                Object fieldValue = field.get(parameters);
                if (fieldValue instanceof Boolean) {
                    boolean dv;
                    boolean bl = dv = StringUtils.isEmpty((CharSequence)defaultValue) ? false : Boolean.valueOf(defaultValue);
                    if (prop == null || prop != null && prop.getType() != Property.Type.BOOLEAN) {
                        cat.remove((Object)property);
                        prop = new Property(property, Boolean.toString(dv), Property.Type.BOOLEAN);
                        cat.put(property, prop);
                    }
                    field.set(parameters, config.getBoolean(property, category, dv, comment));
                } else if (fieldValue instanceof Integer) {
                    int dv;
                    int minInt = Integer.MIN_VALUE;
                    int maxInt = Integer.MAX_VALUE;
                    RangeInt mmi = field.getAnnotation(RangeInt.class);
                    if (mmi != null) {
                        minInt = mmi.min();
                        maxInt = mmi.max();
                    }
                    int n = dv = StringUtils.isEmpty((CharSequence)defaultValue) ? MathStuff.clamp(0, minInt, maxInt) : Integer.valueOf(defaultValue);
                    if (prop == null || prop != null && prop.getType() != Property.Type.INTEGER) {
                        cat.remove((Object)property);
                        prop = new Property(property, Integer.toString(dv), Property.Type.INTEGER);
                        cat.put(property, prop);
                    }
                    field.set(parameters, config.getInt(property, category, dv, minInt, maxInt, comment));
                    prop.setValue(field.getInt(parameters));
                } else if (fieldValue instanceof Float) {
                    float dv;
                    float minFloat = Float.MIN_VALUE;
                    float maxFloat = Float.MAX_VALUE;
                    RangeFloat mmf = field.getAnnotation(RangeFloat.class);
                    if (mmf != null) {
                        minFloat = mmf.min();
                        maxFloat = mmf.max();
                    }
                    float f = dv = StringUtils.isEmpty((CharSequence)defaultValue) ? MathStuff.clamp(0.0f, minFloat, maxFloat) : Float.valueOf(defaultValue).floatValue();
                    if (prop == null || prop != null && prop.getType() != Property.Type.DOUBLE) {
                        cat.remove((Object)property);
                        prop = new Property(property, Double.toString(dv), Property.Type.DOUBLE);
                        cat.put(property, prop);
                    }
                    field.set(parameters, Float.valueOf(config.getFloat(property, category, dv, minFloat, maxFloat, comment)));
                    prop.setValue((double)field.getFloat(parameters));
                } else if (fieldValue instanceof String) {
                    field.set(parameters, config.getString(property, category, defaultValue, comment));
                } else if (fieldValue instanceof String[]) {
                    field.set(parameters, config.getStringList(property, category, StringUtils.split((String)defaultValue, (char)','), comment));
                }
                if (!StringUtils.isEmpty((CharSequence)language)) {
                    prop.setLanguageKey(language);
                }
                if (field.getAnnotation(RestartRequired.class) != null) {
                    RestartRequired restart = field.getAnnotation(RestartRequired.class);
                    prop.setRequiresMcRestart(restart.server());
                    prop.setRequiresWorldRestart(restart.world());
                } else {
                    prop.setRequiresMcRestart(false);
                    prop.setRequiresWorldRestart(false);
                }
                prop.setShowInGui(field.getAnnotation(Hidden.class) == null);
            }
            catch (Throwable t) {
                LibLog.log().error("Unable to parse configuration", t);
            }
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredClasses()) {
            RestartRequired rr;
            annotation = ((Class)annotatedElement).getAnnotation(Category.class);
            if (annotation == null) continue;
            String s = StringUtils.isEmpty((CharSequence)category) ? annotation.value() : category + "." + annotation.value();
            LangKey lk = ((Class)annotatedElement).getAnnotation(LangKey.class);
            if (lk != null) {
                config.setCategoryLanguageKey(s, lk.value());
            }
            if ((rr = ((Class)annotatedElement).getAnnotation(RestartRequired.class)) != null) {
                config.setCategoryRequiresMcRestart(s, rr.server());
                config.setCategoryRequiresWorldRestart(s, rr.world());
            } else {
                config.setCategoryRequiresMcRestart(s, false);
                config.setCategoryRequiresWorldRestart(s, false);
            }
            try {
                List order;
                Field sortOrder = ReflectionHelper.findField((Class)annotatedElement, (String[])new String[]{"SORT"});
                if (sortOrder != null && (order = (List)sortOrder.get(null)) != null) {
                    config.setCategoryPropertyOrder(s, order);
                }
            }
            catch (Exception sortOrder) {
                // empty catch block
            }
            try {
                Field path = ReflectionHelper.findField((Class)annotatedElement, (String[])new String[]{"PATH"});
                if (path != null) {
                    path.set(null, s);
                }
            }
            catch (Exception path) {
                // empty catch block
            }
            Comment com = ((Class)annotatedElement).getAnnotation(Comment.class);
            if (com != null) {
                config.setCategoryComment(s, com.value());
            }
            ConfigProcessor.process(config, s, annotatedElement, parameters);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface RestartRequired {
        public boolean world() default true;

        public boolean server() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface RangeFloat {
        public float min() default 1.4E-45f;

        public float max() default 3.4028235E38f;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface RangeInt {
        public int min() default -2147483648;

        public int max() default 0x7FFFFFFF;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DefaultValue {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface Comment {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface LangKey {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Option {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Category {
        public String value();
    }
}

