/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.item;

import com.oblivioussp.spartanshields.item.ItemShieldBasic;
import com.oblivioussp.spartanshields.util.ConfigHandler;
import com.oblivioussp.spartanshields.util.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;

@Optional.Interface(iface="vazkii.botania.api.mana.IManaUsingItem", modid="botania")
public class ItemShieldBotania
extends ItemShieldBasic
implements IManaUsingItem {
    protected int manaPerDamage = 60;

    public ItemShieldBotania(String unlocName, int maxDamage, Item.ToolMaterial toolMaterial) {
        super(unlocName, maxDamage, toolMaterial);
    }

    public ItemShieldBotania(String unlocName, int maxDamage, Item.ToolMaterial toolMaterial, int manaUsePerDamage) {
        this(unlocName, maxDamage, toolMaterial);
        this.manaPerDamage = manaUsePerDamage;
    }

    @Override
    public void damageShield(ItemStack shieldStack, EntityPlayer player, Entity attacker, float damage) {
        int requestedMana = (1 + MathHelper.func_76141_d((float)damage)) * this.manaPerDamage;
        boolean useManaInstead = ManaItemHandler.requestManaExactForTool((ItemStack)shieldStack, (EntityPlayer)player, (int)requestedMana, (boolean)true);
        if (!useManaInstead) {
            super.damageShield(shieldStack, player, attacker, damage);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K && entityIn instanceof EntityPlayer && stack.func_77952_i() > 0 && this.requestManaForRepair(stack, (EntityPlayer)entityIn, this.manaPerDamage * 2)) {
            stack.func_77964_b(this.getDamage(stack) - 1);
        }
    }

    @Optional.Method(modid="botania")
    protected boolean requestManaForRepair(ItemStack stack, EntityPlayer player, int manaRequested) {
        return ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)manaRequested, (boolean)true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (!Loader.isModLoaded((String)"botania") && !ConfigHandler.forceDisableUncraftableTooltips) {
            tooltip.add(TextFormatting.RED + StringHelper.translateString("cantCraftMissingMods", "tooltip"));
            tooltip.add(TextFormatting.RED + StringHelper.translateString("botania", "mod"));
        }
        tooltip.add(StringHelper.translateFormattedString("protection", "tooltip", this.func_77612_l()));
    }

    public boolean usesMana(ItemStack stack) {
        return true;
    }
}

