/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.init;

import com.oblivioussp.spartanshields.init.ItemRegistrySS;
import com.oblivioussp.spartanshields.item.ItemShieldExtraMaterial;
import com.oblivioussp.spartanshields.util.ConfigHandler;
import com.oblivioussp.spartanshields.util.LogHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RecipeRegistry {
    public static void addRecipes(RegistryEvent.Register<IRecipe> ev) {
        IForgeRegistry reg = ev.getRegistry();
        RecipeRegistry.addRecipe((IForgeRegistry<IRecipe>)reg, "spartanshields:shield_wood_1", (Item)ItemRegistrySS.shieldWood, " pp", "psp", "pp ", Character.valueOf('p'), "plankWood", Character.valueOf('s'), "stickWood");
        RecipeRegistry.addRecipe((IForgeRegistry<IRecipe>)reg, "spartanshields:shield_wood_2", (Item)ItemRegistrySS.shieldWood, "pp ", "psp", " pp", Character.valueOf('p'), "plankWood", Character.valueOf('s'), "stickWood");
        RecipeRegistry.addRecipe((IForgeRegistry<IRecipe>)reg, "spartanshields:shield_stone", (Item)ItemRegistrySS.shieldStone, new Object[]{" c ", "csc", " c ", Character.valueOf('c'), "cobblestone", Character.valueOf('s'), ItemRegistrySS.shieldWood});
        RecipeRegistry.addRecipe((IForgeRegistry<IRecipe>)reg, "spartanshields:shield_iron", (Item)ItemRegistrySS.shieldIron, new Object[]{" i ", "isi", " i ", Character.valueOf('i'), "ingotIron", Character.valueOf('s'), ItemRegistrySS.shieldWood});
        RecipeRegistry.addRecipe((IForgeRegistry<IRecipe>)reg, "spartanshields:shield_gold", (Item)ItemRegistrySS.shieldGold, new Object[]{" i ", "isi", " i ", Character.valueOf('i'), "ingotGold", Character.valueOf('s'), ItemRegistrySS.shieldWood});
        RecipeRegistry.addRecipe((IForgeRegistry<IRecipe>)reg, "spartanshields:shield_diamond", (Item)ItemRegistrySS.shieldDiamond, new Object[]{" g ", "gsg", " g ", Character.valueOf('g'), "gemDiamond", Character.valueOf('s'), ItemRegistrySS.shieldWood});
        if (ConfigHandler.enableObsidianShield) {
            RecipeRegistry.addRecipe((IForgeRegistry<IRecipe>)reg, "spartanshields:shield_obsidian", (Item)ItemRegistrySS.shieldObsidian, new Object[]{" o ", "oso", " o ", Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('s'), ItemRegistrySS.shieldWood});
        }
        LogHelper.info("Recipes added!");
    }

    public static void addCompatRecipes() {
        if (ConfigHandler.vanillaOnly) {
            return;
        }
    }

    public static void addRecipe(IForgeRegistry<IRecipe> registry, String recipePath, Item result, Object ... input) {
        ShapedOreRecipe recipe = new ShapedOreRecipe(new ResourceLocation("recipePath"), result, input);
        recipe.setRegistryName(recipePath);
        registry.register((IForgeRegistryEntry)recipe);
    }

    public static void addRecipe(IForgeRegistry<IRecipe> registry, String recipePath, ItemStack result, Object ... input) {
        ShapedOreRecipe recipe = new ShapedOreRecipe(new ResourceLocation("recipePath"), result, input);
        recipe.setRegistryName(recipePath);
        registry.register((IForgeRegistryEntry)recipe);
    }

    public static boolean addShieldRecipeIfValid(IForgeRegistry<IRecipe> registry, String recipePath, ItemShieldExtraMaterial shield, String oreDict, boolean enabledFlag) {
        RecipeRegistry.addRecipe(registry, recipePath, (Item)shield, new Object[]{" i ", "isi", " i ", Character.valueOf('i'), oreDict, Character.valueOf('s'), ItemRegistrySS.shieldWood});
        return true;
    }
}

